// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/
package javax.faces.component.html;

import javax.el.ValueExpression;
import javax.faces.component.UICommand;
import javax.faces.context.FacesContext;

/**
 *
 * <h4>Events:</h4>
 * <table border="1" width="100%" cellpadding="3" summary="">
 * <tr bgcolor="#CCCCFF" class="TableHeadingColor">
 * <th align="left">Type</th>
 * <th align="left">Phases</th>
 * <th align="left">Description</th>
 * </tr>
 * <tr class="TableRowColor">
 * <td valign="top"><code>javax.faces.event.ActionEvent</code></td>
 * <td valign="top" nowrap>Invoke Application<br>Apply Request Values</td>
 * <td valign="top">Event delivered when the "action" of the component has been
invoked;  for example, by clicking on a button.  The action may result
in page navigation.</td>
 * </tr>
 * </table>
 */
public class HtmlCommandButton extends UICommand
{

  static public final String COMPONENT_FAMILY =
    "javax.faces.Command";
  static public final String COMPONENT_TYPE =
    "javax.faces.HtmlCommandButton";

  /**
   * Construct an instance of the HtmlCommandButton.
   */
  public HtmlCommandButton()
  {
    setRendererType("javax.faces.Button");
  }

  // Property: style
  private String _style;

  /**
   * Gets CSS styling instructions.
   *
   * @return  the new style value
   */
  public String getStyle()
  {
    if (_style != null)
    {
      return _style;
    }
    ValueExpression expression = getValueExpression("style");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets CSS styling instructions.
   * 
   * @param style  the new style value
   */
  public void setStyle(String style)
  {
    this._style = style;
  }

  // Property: styleClass
  private String _styleClass;

  /**
   * Gets The CSS class for this element. Corresponds to the HTML 'class' attribute.
   *
   * @return  the new styleClass value
   */
  public String getStyleClass()
  {
    if (_styleClass != null)
    {
      return _styleClass;
    }
    ValueExpression expression = getValueExpression("styleClass");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets The CSS class for this element. Corresponds to the HTML 'class' attribute.
   * 
   * @param styleClass  the new styleClass value
   */
  public void setStyleClass(String styleClass)
  {
    this._styleClass = styleClass;
  }

  // Property: dir
  private String _dir;

  /**
   * Gets The direction of text display, either 'ltr' (left-to-right) or 'rtl' (right-to-left).
   *
   * @return  the new dir value
   */
  public String getDir()
  {
    if (_dir != null)
    {
      return _dir;
    }
    ValueExpression expression = getValueExpression("dir");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets The direction of text display, either 'ltr' (left-to-right) or 'rtl' (right-to-left).
   * 
   * @param dir  the new dir value
   */
  public void setDir(String dir)
  {
    this._dir = dir;
  }

  // Property: lang
  private String _lang;

  /**
   * Gets The base language of this document.
   *
   * @return  the new lang value
   */
  public String getLang()
  {
    if (_lang != null)
    {
      return _lang;
    }
    ValueExpression expression = getValueExpression("lang");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets The base language of this document.
   * 
   * @param lang  the new lang value
   */
  public void setLang(String lang)
  {
    this._lang = lang;
  }

  // Property: title
  private String _title;

  /**
   * Gets An advisory title for this element. Often used by the user agent as a tooltip.
   *
   * @return  the new title value
   */
  public String getTitle()
  {
    if (_title != null)
    {
      return _title;
    }
    ValueExpression expression = getValueExpression("title");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets An advisory title for this element. Often used by the user agent as a tooltip.
   * 
   * @param title  the new title value
   */
  public void setTitle(String title)
  {
    this._title = title;
  }

  // Property: onclick
  private String _onclick;

  /**
   * Gets Script to be invoked when the element is clicked.
   *
   * @return  the new onclick value
   */
  public String getOnclick()
  {
    if (_onclick != null)
    {
      return _onclick;
    }
    ValueExpression expression = getValueExpression("onclick");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when the element is clicked.
   * 
   * @param onclick  the new onclick value
   */
  public void setOnclick(String onclick)
  {
    this._onclick = onclick;
  }

  // Property: ondblclick
  private String _ondblclick;

  /**
   * Gets Script to be invoked when the element is double-clicked.
   *
   * @return  the new ondblclick value
   */
  public String getOndblclick()
  {
    if (_ondblclick != null)
    {
      return _ondblclick;
    }
    ValueExpression expression = getValueExpression("ondblclick");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when the element is double-clicked.
   * 
   * @param ondblclick  the new ondblclick value
   */
  public void setOndblclick(String ondblclick)
  {
    this._ondblclick = ondblclick;
  }

  // Property: onmousedown
  private String _onmousedown;

  /**
   * Gets Script to be invoked when the pointing device is pressed over this element.
   *
   * @return  the new onmousedown value
   */
  public String getOnmousedown()
  {
    if (_onmousedown != null)
    {
      return _onmousedown;
    }
    ValueExpression expression = getValueExpression("onmousedown");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when the pointing device is pressed over this element.
   * 
   * @param onmousedown  the new onmousedown value
   */
  public void setOnmousedown(String onmousedown)
  {
    this._onmousedown = onmousedown;
  }

  // Property: onmouseup
  private String _onmouseup;

  /**
   * Gets Script to be invoked when the pointing device is released over this element.
   *
   * @return  the new onmouseup value
   */
  public String getOnmouseup()
  {
    if (_onmouseup != null)
    {
      return _onmouseup;
    }
    ValueExpression expression = getValueExpression("onmouseup");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when the pointing device is released over this element.
   * 
   * @param onmouseup  the new onmouseup value
   */
  public void setOnmouseup(String onmouseup)
  {
    this._onmouseup = onmouseup;
  }

  // Property: onmouseover
  private String _onmouseover;

  /**
   * Gets Script to be invoked when the pointing device is moved into this element.
   *
   * @return  the new onmouseover value
   */
  public String getOnmouseover()
  {
    if (_onmouseover != null)
    {
      return _onmouseover;
    }
    ValueExpression expression = getValueExpression("onmouseover");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when the pointing device is moved into this element.
   * 
   * @param onmouseover  the new onmouseover value
   */
  public void setOnmouseover(String onmouseover)
  {
    this._onmouseover = onmouseover;
  }

  // Property: onmousemove
  private String _onmousemove;

  /**
   * Gets Script to be invoked when the pointing device is moved while it is in this element.
   *
   * @return  the new onmousemove value
   */
  public String getOnmousemove()
  {
    if (_onmousemove != null)
    {
      return _onmousemove;
    }
    ValueExpression expression = getValueExpression("onmousemove");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when the pointing device is moved while it is in this element.
   * 
   * @param onmousemove  the new onmousemove value
   */
  public void setOnmousemove(String onmousemove)
  {
    this._onmousemove = onmousemove;
  }

  // Property: onmouseout
  private String _onmouseout;

  /**
   * Gets Script to be invoked when the pointing device is moves out of this element.
   *
   * @return  the new onmouseout value
   */
  public String getOnmouseout()
  {
    if (_onmouseout != null)
    {
      return _onmouseout;
    }
    ValueExpression expression = getValueExpression("onmouseout");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when the pointing device is moves out of this element.
   * 
   * @param onmouseout  the new onmouseout value
   */
  public void setOnmouseout(String onmouseout)
  {
    this._onmouseout = onmouseout;
  }

  // Property: onkeypress
  private String _onkeypress;

  /**
   * Gets Script to be invoked when a key is pressed over this element.
   *
   * @return  the new onkeypress value
   */
  public String getOnkeypress()
  {
    if (_onkeypress != null)
    {
      return _onkeypress;
    }
    ValueExpression expression = getValueExpression("onkeypress");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when a key is pressed over this element.
   * 
   * @param onkeypress  the new onkeypress value
   */
  public void setOnkeypress(String onkeypress)
  {
    this._onkeypress = onkeypress;
  }

  // Property: onkeydown
  private String _onkeydown;

  /**
   * Gets Script to be invoked when a key is pressed down over this element.
   *
   * @return  the new onkeydown value
   */
  public String getOnkeydown()
  {
    if (_onkeydown != null)
    {
      return _onkeydown;
    }
    ValueExpression expression = getValueExpression("onkeydown");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when a key is pressed down over this element.
   * 
   * @param onkeydown  the new onkeydown value
   */
  public void setOnkeydown(String onkeydown)
  {
    this._onkeydown = onkeydown;
  }

  // Property: onkeyup
  private String _onkeyup;

  /**
   * Gets Script to be invoked when a key is released over this element.
   *
   * @return  the new onkeyup value
   */
  public String getOnkeyup()
  {
    if (_onkeyup != null)
    {
      return _onkeyup;
    }
    ValueExpression expression = getValueExpression("onkeyup");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Script to be invoked when a key is released over this element.
   * 
   * @param onkeyup  the new onkeyup value
   */
  public void setOnkeyup(String onkeyup)
  {
    this._onkeyup = onkeyup;
  }

  // Property: onblur
  private String _onblur;

  /**
   * Gets Specifies a script to be invoked when the element loses focus.
   *
   * @return  the new onblur value
   */
  public String getOnblur()
  {
    if (_onblur != null)
    {
      return _onblur;
    }
    ValueExpression expression = getValueExpression("onblur");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Specifies a script to be invoked when the element loses focus.
   * 
   * @param onblur  the new onblur value
   */
  public void setOnblur(String onblur)
  {
    this._onblur = onblur;
  }

  // Property: onfocus
  private String _onfocus;

  /**
   * Gets Specifies a script to be invoked when the element receives focus.
   *
   * @return  the new onfocus value
   */
  public String getOnfocus()
  {
    if (_onfocus != null)
    {
      return _onfocus;
    }
    ValueExpression expression = getValueExpression("onfocus");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Specifies a script to be invoked when the element receives focus.
   * 
   * @param onfocus  the new onfocus value
   */
  public void setOnfocus(String onfocus)
  {
    this._onfocus = onfocus;
  }

  // Property: onchange
  private String _onchange;

  /**
   * Gets Specifies a script to be invoked when the element is modified.
   *
   * @return  the new onchange value
   */
  public String getOnchange()
  {
    if (_onchange != null)
    {
      return _onchange;
    }
    ValueExpression expression = getValueExpression("onchange");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Specifies a script to be invoked when the element is modified.
   * 
   * @param onchange  the new onchange value
   */
  public void setOnchange(String onchange)
  {
    this._onchange = onchange;
  }

  // Property: onselect
  private String _onselect;

  /**
   * Gets Specifies a script to be invoked when the element is selected.
   *
   * @return  the new onselect value
   */
  public String getOnselect()
  {
    if (_onselect != null)
    {
      return _onselect;
    }
    ValueExpression expression = getValueExpression("onselect");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Specifies a script to be invoked when the element is selected.
   * 
   * @param onselect  the new onselect value
   */
  public void setOnselect(String onselect)
  {
    this._onselect = onselect;
  }

  // Property: accesskey
  private String _accesskey;

  /**
   * Gets Sets the access key for this element.
   *
   * @return  the new accesskey value
   */
  public String getAccesskey()
  {
    if (_accesskey != null)
    {
      return _accesskey;
    }
    ValueExpression expression = getValueExpression("accesskey");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Sets the access key for this element.
   * 
   * @param accesskey  the new accesskey value
   */
  public void setAccesskey(String accesskey)
  {
    this._accesskey = accesskey;
  }

  // Property: tabindex
  private String _tabindex;

  /**
   * Gets Specifies the position of this element within the tab order of the document.
   *
   * @return  the new tabindex value
   */
  public String getTabindex()
  {
    if (_tabindex != null)
    {
      return _tabindex;
    }
    ValueExpression expression = getValueExpression("tabindex");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Specifies the position of this element within the tab order of the document.
   * 
   * @param tabindex  the new tabindex value
   */
  public void setTabindex(String tabindex)
  {
    this._tabindex = tabindex;
  }

  // Property: disabled
  private boolean _disabled;
  private boolean _disabledSet;

  /**
   * Gets When true, this element cannot receive focus.
   *
   * @return  the new disabled value
   */
  public boolean isDisabled()
  {
    if (_disabledSet)
    {
      return _disabled;
    }
    ValueExpression expression = getValueExpression("disabled");
    if (expression != null)
    {
      return (Boolean)expression.getValue(getFacesContext().getELContext());
    }
    return false;
  }

  /**
   * Sets When true, this element cannot receive focus.
   * 
   * @param disabled  the new disabled value
   */
  public void setDisabled(boolean disabled)
  {
    this._disabled = disabled;
    this._disabledSet = true;
  }

  // Property: readonly
  private boolean _readonly;
  private boolean _readonlySet;

  /**
   * Gets When true, indicates that this component cannot be modified by the user.
   *                 The element may receive focus unless it has also been disabled.
   *
   * @return  the new readonly value
   */
  public boolean isReadonly()
  {
    if (_readonlySet)
    {
      return _readonly;
    }
    ValueExpression expression = getValueExpression("readonly");
    if (expression != null)
    {
      return (Boolean)expression.getValue(getFacesContext().getELContext());
    }
    return false;
  }

  /**
   * Sets When true, indicates that this component cannot be modified by the user.
   *                 The element may receive focus unless it has also been disabled.
   * 
   * @param readonly  the new readonly value
   */
  public void setReadonly(boolean readonly)
  {
    this._readonly = readonly;
    this._readonlySet = true;
  }

  // Property: label
  private String _label;

  /**
   * Gets A diplay name for this component.
   *
   * @return  the new label value
   */
  public String getLabel()
  {
    if (_label != null)
    {
      return _label;
    }
    ValueExpression expression = getValueExpression("label");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets A diplay name for this component.
   * 
   * @param label  the new label value
   */
  public void setLabel(String label)
  {
    this._label = label;
  }

  // Property: image
  private String _image;

  /**
   * Gets Absolute or relative URL of the image
   *
   * @return  the new image value
   */
  public String getImage()
  {
    if (_image != null)
    {
      return _image;
    }
    ValueExpression expression = getValueExpression("image");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Absolute or relative URL of the image
   * 
   * @param image  the new image value
   */
  public void setImage(String image)
  {
    this._image = image;
  }

  // Property: alt
  private String _alt;

  /**
   * Gets Specifies alternative text that can be used by a browser that can't show this element.
   *
   * @return  the new alt value
   */
  public String getAlt()
  {
    if (_alt != null)
    {
      return _alt;
    }
    ValueExpression expression = getValueExpression("alt");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets Specifies alternative text that can be used by a browser that can't show this element.
   * 
   * @param alt  the new alt value
   */
  public void setAlt(String alt)
  {
    this._alt = alt;
  }

  // Property: type
  private String _type;

  /**
   * Gets A hint to the user agent about the content type of the linked resource.
   *
   * @return  the new type value
   */
  public String getType()
  {
    if (_type != null)
    {
      return _type;
    }
    ValueExpression expression = getValueExpression("type");
    if (expression != null)
    {
      return (String)expression.getValue(getFacesContext().getELContext());
    }
    return null;
  }

  /**
   * Sets A hint to the user agent about the content type of the linked resource.
   * 
   * @param type  the new type value
   */
  public void setType(String type)
  {
    this._type = type;
  }

  @Override
  public Object saveState(FacesContext facesContext)
  {
    Object[] values = new Object[30];
    values[0] = super.saveState(facesContext);
    values[1] = _style;
    values[2] = _styleClass;
    values[3] = _dir;
    values[4] = _lang;
    values[5] = _title;
    values[6] = _onclick;
    values[7] = _ondblclick;
    values[8] = _onmousedown;
    values[9] = _onmouseup;
    values[10] = _onmouseover;
    values[11] = _onmousemove;
    values[12] = _onmouseout;
    values[13] = _onkeypress;
    values[14] = _onkeydown;
    values[15] = _onkeyup;
    values[16] = _onblur;
    values[17] = _onfocus;
    values[18] = _onchange;
    values[19] = _onselect;
    values[20] = _accesskey;
    values[21] = _tabindex;
    values[22] = _disabled;
    values[23] = _disabledSet;
    values[24] = _readonly;
    values[25] = _readonlySet;
    values[26] = _label;
    values[27] = _image;
    values[28] = _alt;
    values[29] = _type;

    return values;
  }

  @Override
  public void restoreState(FacesContext facesContext, Object state)
  {
    Object[] values = (Object[])state;
    super.restoreState(facesContext,values[0]);
    _style = (String)values[1];
    _styleClass = (String)values[2];
    _dir = (String)values[3];
    _lang = (String)values[4];
    _title = (String)values[5];
    _onclick = (String)values[6];
    _ondblclick = (String)values[7];
    _onmousedown = (String)values[8];
    _onmouseup = (String)values[9];
    _onmouseover = (String)values[10];
    _onmousemove = (String)values[11];
    _onmouseout = (String)values[12];
    _onkeypress = (String)values[13];
    _onkeydown = (String)values[14];
    _onkeyup = (String)values[15];
    _onblur = (String)values[16];
    _onfocus = (String)values[17];
    _onchange = (String)values[18];
    _onselect = (String)values[19];
    _accesskey = (String)values[20];
    _tabindex = (String)values[21];
    _disabled = (Boolean)values[22];
    _disabledSet = (Boolean)values[23];
    _readonly = (Boolean)values[24];
    _readonlySet = (Boolean)values[25];
    _label = (String)values[26];
    _image = (String)values[27];
    _alt = (String)values[28];
    _type = (String)values[29];
  }

  @Override
  public String getFamily()
  {
    return COMPONENT_FAMILY;
  }
}
