/*
 * Copyright 2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package javax.faces.event;

import javax.faces.component.UIComponent;

/**
 * see Javadoc of <a href="http://java.sun.com/javaee/javaserverfaces/1.2/docs/api/index.html">JSF Specification</a>
 *
 * @author Thomas Spiegl (latest modification by $Author: mbr $)
 * @version $Revision: 512227 $ $Date: 2007-02-27 07:25:16 -0500 (Tue, 27 Feb 2007) $
 */
public class ValueChangeEvent extends FacesEvent {
    private static final long serialVersionUID = -2490528664421353795L;
    // FIELDS
    private Object _oldValue;
    private Object _newValue;

	// CONSTRUCTORS
	public ValueChangeEvent(UIComponent uiComponent, Object oldValue, Object newValue)
	{
        super(uiComponent);
        if (uiComponent == null) throw new IllegalArgumentException("uiComponent");
        _oldValue = oldValue;
        _newValue = newValue;
	}

	// METHODS
	public Object getNewValue()
	{
		return _newValue;
	}

	public Object getOldValue()
	{
		return _oldValue;
	}

	public boolean isAppropriateListener(FacesListener facesListeners)
	{
        return facesListeners instanceof ValueChangeListener;
    }

    public void processListener(FacesListener facesListeners)
    {
        ((ValueChangeListener)facesListeners).processValueChange(this);
    }
}
