/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package javax.faces.convert;

import javax.faces.FacesException;
import javax.faces.application.FacesMessage;

/**
 * see Javadoc of <a href="http://java.sun.com/javaee/javaserverfaces/1.2/docs/api/index.html">JSF Specification</a>
 *
 * @author Thomas Spiegl (latest modification by $Author: cjhoward $)
 * @version $Revision: 904057 $ $Date: 2010-01-28 07:15:57 -0500 (Thu, 28 Jan 2010) $
 */
public class ConverterException
        extends FacesException
{
    private static final long serialVersionUID = 8668056061177480197L;
    // FIELDS
    private FacesMessage _facesMessage;

    // CONSTRUCTORS
    public ConverterException()
    {
        super();
    }

    public ConverterException(FacesMessage facesMessage)
    {
        super((facesMessage == null) ? null : facesMessage.getSummary());
        _facesMessage = facesMessage;
    }

    public ConverterException(FacesMessage facesMessage, Throwable cause)
    {
        super(cause);
        _facesMessage = facesMessage;
    }

    public ConverterException(String message)
    {
        super(message);
    }

    public ConverterException(String message, Throwable cause)
    {
        super(message, cause);
    }

    public ConverterException(Throwable cause)
    {
        super(cause);
    }

    // METHODS
    public FacesMessage getFacesMessage()
    {
        return _facesMessage;
    }

}
