/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.ViewScopeProvider;
import org.apache.myfaces.spi.impl.DefaultViewScopeProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class ViewScopeProviderFactory
implements FacesWrapper<ViewScopeProviderFactory> {
    private static final String FACTORY_KEY = ViewScopeProviderFactory.class.getName();

    public static ViewScopeProviderFactory getViewScopeHandlerFactory(ExternalContext ctx) {
        ViewScopeProviderFactory instance = (ViewScopeProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        ViewScopeProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                lpf = (ViewScopeProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, ViewScopeProviderFactory.class, DefaultViewScopeProviderFactory.class));
            } else {
                lpf = (ViewScopeProviderFactory)SpiUtils.build(ctx, ViewScopeProviderFactory.class, DefaultViewScopeProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (lpf != null) {
            ViewScopeProviderFactory.setViewScopeHandlerFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setViewScopeHandlerFactory(ExternalContext ctx, ViewScopeProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract ViewScopeProvider getViewScopeHandler(ExternalContext var1);

    public ViewScopeProviderFactory getWrapped() {
        return null;
    }

    public abstract void setViewScopeHandler(ExternalContext var1, ViewScopeProvider var2);
}

