/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.component;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHandler;
import javax.faces.component.search.SearchExpressionHint;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.component.ResolveComponent;
import org.apache.myfaces.cdi.component.ResolveComponentInfo;
import org.apache.myfaces.cdi.viewTransient.ViewTransientScoped;
import org.apache.myfaces.shared.util.ClassUtils;

@Typed
public class DynamicUIComponentProxyProducer
implements Bean<UIComponent>,
Serializable,
PassivationCapable {
    private static final long serialVersionUID = 1L;
    private BeanManager beanManager;
    private ResolveComponentInfo typeInfo;
    private Set<Type> types;
    private Class<?> beanClass;
    private static final Set<SearchExpressionHint> EXPRESSION_HINTS = EnumSet.of(SearchExpressionHint.SKIP_VIRTUAL_COMPONENTS, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);

    public DynamicUIComponentProxyProducer(BeanManager beanManager, ResolveComponentInfo typeInfo) {
        this.beanManager = beanManager;
        this.typeInfo = typeInfo;
        this.types = new HashSet<Type>(Arrays.asList(typeInfo.getType(), Object.class));
        this.beanClass = ClassUtils.simpleClassForName(typeInfo.getType().getTypeName());
    }

    public String getId() {
        return this.typeInfo.getType() + "_" + this.typeInfo.getExpression();
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.singleton(new DefaultAnnotationLiteral(this.typeInfo.getExpression()));
    }

    public Class<? extends Annotation> getScope() {
        return ViewTransientScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return true;
    }

    public UIComponent create(CreationalContext<UIComponent> creationalContext) {
        if ("".equals(this.typeInfo.getExpression())) {
            return UIComponent.getCurrentComponent((FacesContext)FacesContext.getCurrentInstance());
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent refComponent = UIComponent.getCurrentComponent((FacesContext)facesContext);
        refComponent = refComponent == null ? facesContext.getViewRoot() : refComponent;
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        SearchExpressionContext searchContext = SearchExpressionContext.createSearchExpressionContext((FacesContext)facesContext, (UIComponent)refComponent, EXPRESSION_HINTS, null);
        FindComponentCallback callback = new FindComponentCallback();
        handler.resolveComponent(searchContext, this.typeInfo.getExpression(), (ContextCallback)callback);
        return callback.getComponent();
    }

    public void destroy(UIComponent t, CreationalContext<UIComponent> cc) {
    }

    public static <A extends Annotation> A getQualifier(InjectionPoint injectionPoint, Class<A> qualifierClass) {
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (!qualifierClass.isAssignableFrom(annotation.getClass())) continue;
            return (A)((Annotation)qualifierClass.cast(annotation));
        }
        return null;
    }

    private static class FindComponentCallback
    implements ContextCallback {
        private UIComponent component = null;

        private FindComponentCallback() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (this.component == null) {
                this.component = target;
            }
        }

        public UIComponent getComponent() {
            return this.component;
        }
    }

    public static class DefaultAnnotationLiteral
    extends AnnotationLiteral<ResolveComponent>
    implements ResolveComponent {
        private static final long serialVersionUID = 1L;
        private String value;

        public DefaultAnnotationLiteral(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

