/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.converter;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.convert.FacesConverter;
import org.apache.myfaces.cdi.converter.ConverterInfo;
import org.apache.myfaces.cdi.converter.DynamicConverterProducer;

public class FacesConverterExtension
implements Extension {
    private Set<ConverterInfo> types = new HashSet<ConverterInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesConverter.class)) {
            AnnotatedType annotated = event.getAnnotatedBeanClass();
            Type type = annotated.getBaseType();
            FacesConverter conv = (FacesConverter)annotated.getAnnotation(FacesConverter.class);
            if (conv.managed()) {
                boolean hasValue;
                boolean hasForClass = !Object.class.equals((Object)conv.forClass());
                boolean bl = hasValue = conv.value().length() > 0;
                if (hasForClass || hasValue) {
                    if (hasForClass) {
                        this.types.add(new ConverterInfo(type, conv.forClass(), ""));
                    }
                    if (hasValue) {
                        this.types.add(new ConverterInfo(type, Object.class, conv.value()));
                    }
                }
            }
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (ConverterInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new DynamicConverterProducer(beanManager, typeInfo));
        }
    }
}

