/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.validator;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.FacesException;
import javax.faces.validator.Validator;
import org.apache.myfaces.cdi.validator.FacesValidatorAnnotationLiteral;
import org.apache.myfaces.cdi.validator.ValidatorInfo;
import org.apache.myfaces.shared.util.ClassUtils;

@Typed
public class DynamicValidatorProducer
implements Bean<Validator>,
Serializable,
PassivationCapable {
    private static final long serialVersionUID = 1L;
    private BeanManager beanManager;
    private ValidatorInfo typeInfo;
    private Set<Type> types;
    private Class<?> beanClass;

    public DynamicValidatorProducer(BeanManager beanManager, ValidatorInfo typeInfo) {
        this.beanManager = beanManager;
        this.typeInfo = typeInfo;
        this.types = new HashSet<Type>(Arrays.asList(typeInfo.getType(), Object.class));
        this.beanClass = ClassUtils.simpleClassForName(typeInfo.getType().getTypeName());
    }

    public String getId() {
        String converterId = this.typeInfo.getValidatorId() == null ? "" : this.typeInfo.getValidatorId();
        return "" + this.typeInfo.getType() + "_" + converterId;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.singleton(new FacesValidatorAnnotationLiteral(this.typeInfo.getValidatorId() == null ? "" : this.typeInfo.getValidatorId(), false, true));
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return true;
    }

    public Validator create(CreationalContext<Validator> cc) {
        Class<?> converterClass = this.beanClass;
        Validator converter = null;
        try {
            converter = (Validator)converterClass.newInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(DynamicValidatorProducer.class.getName()).log(Level.SEVERE, "Could not instantiate converter " + this.beanClass.getName().toString(), ex);
            throw new FacesException("Could not instantiate converter: " + this.beanClass.getName().toString(), (Throwable)ex);
        }
        return converter;
    }

    public void destroy(Validator t, CreationalContext<Validator> cc) {
    }
}

