/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.validator;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.validator.FacesValidator;
import org.apache.myfaces.cdi.validator.DynamicValidatorProducer;
import org.apache.myfaces.cdi.validator.ValidatorInfo;

public class FacesValidatorExtension
implements Extension {
    private Set<ValidatorInfo> types = new HashSet<ValidatorInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesValidator.class)) {
            AnnotatedType annotated = event.getAnnotatedBeanClass();
            Type type = annotated.getBaseType();
            FacesValidator conv = (FacesValidator)annotated.getAnnotation(FacesValidator.class);
            if (conv.managed()) {
                boolean hasValue;
                boolean bl = hasValue = conv.value().length() > 0;
                if (hasValue) {
                    this.types.add(new ValidatorInfo(type, conv.value()));
                }
            }
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (ValidatorInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new DynamicValidatorProducer(beanManager, typeInfo));
        }
    }
}

