/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.ClientWindow;
import org.apache.myfaces.application.StateCache;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.renderkit.StateTokenProcessor;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.StateUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.spi.StateCacheProvider;
import org.apache.myfaces.spi.StateCacheProviderFactory;

public class HtmlResponseStateManager
extends MyfacesResponseStateManager {
    private static final Logger log = Logger.getLogger(HtmlResponseStateManager.class.getName());
    public static final String STANDARD_STATE_SAVING_PARAM = "javax.faces.ViewState";
    private static final String VIEW_STATE_COUNTER = "oam.partial.VIEW_STATE_COUNTER";
    private static final String CLIENT_WINDOW_COUNTER = "oam.partial.CLIENT_WINDOW_COUNTER";
    private static final String SESSION_TOKEN = "oam.rsm.SESSION_TOKEN";
    @Deprecated
    public static final String INIT_PARAM_HANDLE_STATE_CACHING_MECHANICS = "org.apache.myfaces.HANDLE_STATE_CACHING_MECHANICS";
    public static final String INIT_PARAM_AUTOCOMPLETE_OFF_VIEW_STATE = "org.apache.myfaces.AUTOCOMPLETE_OFF_VIEW_STATE";
    private StateCacheProvider _stateCacheFactory;
    private StateTokenProcessor _stateTokenProcessor = new DefaultStateTokenProcessor();
    private Boolean _autoCompleteOffViewState = null;

    public void writeState(FacesContext facesContext, Object state) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Object savedStateObject = null;
        if (!facesContext.getViewRoot().isTransient()) {
            savedStateObject = this.getStateCache(facesContext).encodeSerializedState(facesContext, state);
        }
        this.writeViewStateField(facesContext, responseWriter, savedStateObject);
        this.writeRenderKitIdField(facesContext, responseWriter);
        this.writeWindowIdField(facesContext, responseWriter);
    }

    private void writeWindowIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
        if (clientWindow != null) {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", (Object)"hidden", null);
            responseWriter.writeAttribute("id", (Object)HtmlResponseStateManager.generateUpdateClientWindowId(facesContext), null);
            responseWriter.writeAttribute("name", (Object)"javax.faces.ClientWindow", null);
            responseWriter.writeAttribute("value", (Object)clientWindow.getId(), null);
            responseWriter.endElement("input");
        }
    }

    @Override
    public void saveState(FacesContext facesContext, Object state) {
        if (!facesContext.getViewRoot().isTransient()) {
            this.getStateCache(facesContext).saveSerializedView(facesContext, state);
        }
    }

    private void writeViewStateField(FacesContext facesContext, ResponseWriter responseWriter, Object savedState) throws IOException {
        String serializedState = this._stateTokenProcessor.encode(facesContext, savedState);
        ExternalContext extContext = facesContext.getExternalContext();
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(extContext);
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)STANDARD_STATE_SAVING_PARAM, null);
        if (myfacesConfig.isRenderViewStateId()) {
            responseWriter.writeAttribute("id", (Object)HtmlResponseStateManager.generateUpdateViewStateId(facesContext), null);
        }
        responseWriter.writeAttribute("value", (Object)serializedState, null);
        if (this.isAutocompleteOffViewState(facesContext)) {
            responseWriter.writeAttribute("autocomplete", (Object)"off", null);
        }
        responseWriter.endElement("input");
    }

    private void writeRenderKitIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
        if (defaultRenderKitId != null && !"HTML_BASIC".equals(defaultRenderKitId)) {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", (Object)"hidden", null);
            responseWriter.writeAttribute("name", (Object)"javax.faces.RenderKitId", null);
            responseWriter.writeAttribute("value", (Object)defaultRenderKitId, null);
            responseWriter.endElement("input");
        }
    }

    public Object getState(FacesContext facesContext, String viewId) {
        Object savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return this.getStateCache(facesContext).restoreSerializedView(facesContext, viewId, savedState);
    }

    private Object getSavedState(FacesContext facesContext) {
        Object encodedState = facesContext.getExternalContext().getRequestParameterMap().get(STANDARD_STATE_SAVING_PARAM);
        if (encodedState == null || ((String)encodedState).length() == 0) {
            return null;
        }
        Object savedStateObject = this._stateTokenProcessor.decode(facesContext, (String)encodedState);
        return savedStateObject;
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(STANDARD_STATE_SAVING_PARAM);
    }

    public String getViewState(FacesContext facesContext, Object baseState) {
        if (baseState == null) {
            return null;
        }
        if (facesContext.getViewRoot().isTransient()) {
            return null;
        }
        Object state = this.getStateCache(facesContext).saveSerializedView(facesContext, baseState);
        return this._stateTokenProcessor.encode(facesContext, state);
    }

    public boolean isStateless(FacesContext context, String viewId) {
        if (context.isPostback()) {
            String encodedState = (String)context.getExternalContext().getRequestParameterMap().get(STANDARD_STATE_SAVING_PARAM);
            if (encodedState == null || encodedState.length() == 0) {
                return false;
            }
            return this._stateTokenProcessor.isStateless(context, encodedState);
        }
        throw new IllegalStateException("Cannot decide if the view is stateless or not, since the request is not postback (no preceding writeState(...)).");
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        String savedToken = (String)sessionMap.get(SESSION_TOKEN);
        if (savedToken == null) {
            savedToken = this.getStateCache(context).createCryptographicallyStrongTokenFromSession(context);
            sessionMap.put(SESSION_TOKEN, savedToken);
        }
        return savedToken;
    }

    @Override
    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        return this.getStateCache(facesContext).isWriteStateAfterRenderViewRequired(facesContext);
    }

    protected StateCache getStateCache(FacesContext facesContext) {
        if (this._stateCacheFactory == null) {
            this._stateCacheFactory = StateCacheProviderFactory.getStateCacheProviderFactory(facesContext.getExternalContext()).getStateCacheProvider(facesContext.getExternalContext());
        }
        return this._stateCacheFactory.getStateCache(facesContext);
    }

    public static String generateUpdateClientWindowId(FacesContext facesContext) {
        char separator = facesContext.getNamingContainerSeparatorChar();
        Integer count = (Integer)facesContext.getAttributes().get(CLIENT_WINDOW_COUNTER);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        String id = facesContext.getViewRoot().getContainerClientId(facesContext) + separator + "javax.faces.ClientWindow" + separator + count;
        facesContext.getAttributes().put(CLIENT_WINDOW_COUNTER, count);
        return id;
    }

    public static String generateUpdateViewStateId(FacesContext facesContext) {
        char separator = facesContext.getNamingContainerSeparatorChar();
        Integer count = (Integer)facesContext.getAttributes().get(VIEW_STATE_COUNTER);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        String id = facesContext.getViewRoot().getContainerClientId(facesContext) + separator + STANDARD_STATE_SAVING_PARAM + separator + count;
        facesContext.getAttributes().put(VIEW_STATE_COUNTER, count);
        return id;
    }

    private boolean isAutocompleteOffViewState(FacesContext facesContext) {
        if (this._autoCompleteOffViewState == null) {
            this._autoCompleteOffViewState = WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), INIT_PARAM_AUTOCOMPLETE_OFF_VIEW_STATE, true);
        }
        return this._autoCompleteOffViewState;
    }

    private static class DefaultStateTokenProcessor
    extends StateTokenProcessor {
        private static final String STATELESS_TOKEN = "stateless";

        private DefaultStateTokenProcessor() {
        }

        @Override
        public Object decode(FacesContext facesContext, String token) {
            if (STATELESS_TOKEN.equals(token)) {
                return null;
            }
            Object savedStateObject = StateUtils.reconstruct(token, facesContext.getExternalContext());
            return savedStateObject;
        }

        @Override
        public String encode(FacesContext facesContext, Object savedStateObject) {
            if (facesContext.getViewRoot().isTransient()) {
                return STATELESS_TOKEN;
            }
            String serializedState = StateUtils.construct(savedStateObject, facesContext.getExternalContext());
            return serializedState;
        }

        @Override
        public boolean isStateless(FacesContext facesContext, String token) {
            return STATELESS_TOKEN.equals(token);
        }
    }
}

