/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.application;

import java.util.Collection;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.shared.webapp.webxml.WebXml;

public class FacesServletMappingUtils {
    public static FacesServletMapping calculateGenericFacesServletMapping(FacesContext facesContext, String servletPath, String pathInfo) {
        if (ExternalContextUtils.isPortlet(facesContext.getExternalContext())) {
            return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
        }
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext) {
            if (pathInfo != null) {
                return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, false);
            }
            int slashPos = servletPath.lastIndexOf(47);
            int extensionPos = servletPath.lastIndexOf(46);
            if (extensionPos > -1 && extensionPos > slashPos) {
                String extension = servletPath.substring(extensionPos);
                return FacesServletMapping.createExtensionMapping(extension);
            }
            return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, false);
        }
        return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
    }

    public static FacesServletMapping calculateFacesServletMapping(FacesContext facesContext, String servletPath, String pathInfo) {
        if (ExternalContextUtils.isPortlet(facesContext.getExternalContext())) {
            return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
        }
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext) {
            if (pathInfo != null) {
                return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, true);
            }
            int slashPos = servletPath.lastIndexOf(47);
            int extensionPos = servletPath.lastIndexOf(46);
            if (extensionPos > -1 && extensionPos > slashPos) {
                String extension = servletPath.substring(extensionPos);
                return FacesServletMapping.createExtensionMapping(extension);
            }
            return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, true);
        }
        return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
    }

    private static FacesServletMapping createMappingFromServletRegistration(FacesContext facesContext, ServletContext servletContext, String servletPath, String pathInfo, boolean allowExactMatch) {
        try {
            Map map = servletContext.getServletRegistrations();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        if (!FacesServletMappingUtils.isFacesServlet(facesContext, ((ServletRegistration)entry.getValue()).getClassName())) continue;
                        Collection mappings = ((ServletRegistration)entry.getValue()).getMappings();
                        FacesServletMapping extensionMapping = null;
                        FacesServletMapping prefixMapping = null;
                        FacesServletMapping exactMapping = null;
                        for (String mapping : mappings) {
                            if (mapping.startsWith("*.")) {
                                extensionMapping = FacesServletMapping.createExtensionMapping(mapping.substring(1));
                                continue;
                            }
                            if (mapping.startsWith("/") && mapping.endsWith("/*")) {
                                prefixMapping = FacesServletMapping.createPrefixMapping(mapping.substring(0, mapping.length() - 2));
                                continue;
                            }
                            if (!allowExactMatch || !mapping.startsWith("/") || !mapping.equals(servletPath)) continue;
                            exactMapping = FacesServletMapping.createPrefixMapping(servletPath);
                        }
                        if (allowExactMatch && exactMapping != null) {
                            return exactMapping;
                        }
                        if (prefixMapping != null) {
                            return prefixMapping;
                        }
                        if (extensionMapping == null) continue;
                        return extensionMapping;
                    }
                    catch (Exception exception) {
                    }
                }
                return FacesServletMapping.createPrefixMapping(servletPath);
            }
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        catch (Exception ex) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
    }

    public static boolean isFacesServlet(FacesContext facesContext, String servletClassName) {
        Class servletClass = ClassUtils.simpleClassForName(servletClassName);
        return FacesServlet.class.isAssignableFrom(servletClass) || DelegatedFacesServlet.class.isAssignableFrom(servletClass) || servletClass.getName().equals(WebXml.getWebXml(facesContext.getExternalContext()).getDelegateFacesServlet());
    }

    private static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    public static FacesServletMapping calculateFacesServletMappingFromPrefixedExactMappingViewId(FacesContext facesContext, String prefixedExactMappingViewId) {
        Map map;
        Object context;
        FacesServletMapping mapping = null;
        if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext()) && (context = facesContext.getExternalContext().getContext()) instanceof ServletContext && (map = ((ServletContext)context).getServletRegistrations()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                try {
                    if (!FacesServletMappingUtils.isFacesServlet(facesContext, ((ServletRegistration)entry.getValue()).getClassName())) continue;
                    Collection mappings = ((ServletRegistration)entry.getValue()).getMappings();
                    for (String m : mappings) {
                        if (m.contains("*") || !prefixedExactMappingViewId.equals(m)) continue;
                        mapping = FacesServletMapping.createPrefixMapping(prefixedExactMappingViewId);
                    }
                }
                catch (Exception exception) {}
            }
        }
        return mapping;
    }
}

