/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlRadioRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlRadioRendererBase.class.getName());
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final Set<VisitHint> FIND_SELECT_LIST_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_UNRENDERED));

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        UISelectOne selectOne = (UISelectOne)uiComponent;
        String layout = this.getLayout((UIComponent)selectOne);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.severe("Wrong layout attribute for component " + selectOne.getClientId(facesContext) + ": " + layout);
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        String group = null;
        if (uiComponent instanceof HtmlSelectOneRadio) {
            group = ((HtmlSelectOneRadio)uiComponent).getGroup();
        }
        if (group != null && group.length() > 0) {
            String id = uiComponent.getId();
            if (id != null && HtmlRendererUtils.GROUP_INDEXED_ID_CHECKER.matcher(id).matches()) {
                int i;
                for (i = id.length() - 1; i > 0 && Character.isDigit(id.charAt(i)); --i) {
                }
                Integer itemNum = Integer.valueOf(id.substring(i + 1));
                List selectItemList = RendererUtils.getSelectItemList(selectOne, facesContext);
                Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, (UIComponent)selectOne);
                ValueExpression ve = selectOne.getValueExpression("value");
                Object currentValue = null;
                boolean currentValueSet = false;
                if (ve == null && (selectItemList == null || selectItemList.size() <= 0)) {
                    FormInfo formInfo = RendererUtils.findNestingForm(uiComponent, facesContext);
                    GetSelectItemListCallback callback = new GetSelectItemListCallback(group);
                    formInfo.getForm().visitTree(VisitContext.createVisitContext((FacesContext)facesContext, null, FIND_SELECT_LIST_HINTS), (VisitCallback)callback);
                    selectItemList = callback.getSelectItemList();
                    converter = callback.getConverter();
                    currentValueSet = true;
                    currentValue = callback.getCurrentValue();
                }
                if (selectItemList != null && selectItemList.size() > 0) {
                    if (!currentValueSet) {
                        currentValue = RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(facesContext, (UIComponent)selectOne);
                    }
                    SelectItem selectItem = (SelectItem)selectItemList.get(itemNum);
                    this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, selectItem, currentValue, converter, pageDirectionLayout, group, itemNum);
                }
            } else {
                List selectItemList = RendererUtils.getSelectItemList(selectOne, facesContext);
                Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, (UIComponent)selectOne);
                String currentValue = RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(facesContext, (UIComponent)selectOne);
                int itemNum = 0;
                for (SelectItem selectItem : selectItemList) {
                    itemNum = this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, selectItem, currentValue, converter, pageDirectionLayout, group, itemNum);
                }
            }
        } else {
            writer.startElement("table", (UIComponent)selectOne);
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectOne, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
            if (behaviors != null && !behaviors.isEmpty()) {
                writer.writeAttribute("id", (Object)selectOne.getClientId(facesContext), null);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)selectOne, facesContext);
            }
            if (!pageDirectionLayout) {
                writer.startElement("tr", null);
            }
            List selectItemList = RendererUtils.getSelectItemList(selectOne, facesContext);
            Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, (UIComponent)selectOne);
            String currentValue = RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(facesContext, (UIComponent)selectOne);
            int itemNum = 0;
            for (SelectItem selectItem : selectItemList) {
                itemNum = this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, selectItem, currentValue, converter, pageDirectionLayout, itemNum);
            }
            if (!pageDirectionLayout) {
                writer.endElement("tr");
            }
            writer.endElement("table");
        }
    }

    protected String getLayout(UIComponent selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getLayout();
        }
        return (String)selectOne.getAttributes().get("layout");
    }

    protected String getStyleClass(UISelectOne selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getStyleClass();
        }
        return (String)selectOne.getAttributes().get("styleClass");
    }

    protected int renderGroupOrItemRadio(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Object currentValue, Converter converter, boolean pageDirectionLayout, Integer itemNum) throws IOException {
        return this.renderGroupOrItemRadio(facesContext, uiComponent, selectItem, currentValue, converter, pageDirectionLayout, null, itemNum);
    }

    protected int renderGroupOrItemRadio(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Object currentValue, Converter converter, boolean pageDirectionLayout, String group, Integer itemNum) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        UISelectOne selectOne = (UISelectOne)uiComponent;
        if (isSelectItemGroup) {
            SelectItem[] selectItems;
            if (pageDirectionLayout) {
                writer.startElement("tr", null);
            }
            writer.startElement("td", null);
            if (selectItem.isEscape()) {
                writer.writeText((Object)selectItem.getLabel(), "label");
            } else {
                writer.write(selectItem.getLabel());
            }
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
                writer.startElement("tr", null);
            }
            writer.startElement("td", null);
            writer.startElement("table", null);
            writer.writeAttribute("border", (Object)"0", null);
            if (!pageDirectionLayout) {
                writer.startElement("tr", null);
            }
            SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
            for (SelectItem groupSelectItem : selectItems = selectItemGroup.getSelectItems()) {
                itemNum = this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, groupSelectItem, currentValue, converter, pageDirectionLayout, itemNum);
            }
            if (!pageDirectionLayout) {
                writer.endElement("tr");
            }
            writer.endElement("table");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        } else {
            boolean itemChecked;
            String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectOne, converter, selectItem.getValue());
            boolean bl = itemStrValue == null ? itemStrValue == currentValue : ("".equals(itemStrValue) ? currentValue == null || itemStrValue.equals(currentValue) : (itemChecked = itemStrValue.equals(currentValue)));
            if (HtmlRendererUtils.isHideNoSelectionOption(uiComponent) && selectItem.isNoSelectionOption() && currentValue != null && !"".equals(currentValue) && !itemChecked) {
                return itemNum;
            }
            boolean renderGroupId = false;
            if (group != null && group.length() > 0) {
                renderGroupId = true;
            } else {
                if (pageDirectionLayout) {
                    writer.startElement("tr", null);
                }
                writer.startElement("td", null);
            }
            boolean itemDisabled = selectItem.isDisabled();
            String itemId = this.renderRadio(facesContext, (UIInput)selectOne, itemStrValue, itemDisabled, itemChecked, renderGroupId, renderGroupId ? null : itemNum);
            boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectOne);
            boolean disabled = componentDisabled || itemDisabled;
            HtmlRendererUtils.renderLabel(writer, (UIComponent)selectOne, itemId, selectItem, disabled);
            if (group == null || group.length() <= 0) {
                writer.endElement("td");
                if (pageDirectionLayout) {
                    writer.endElement("tr");
                }
            }
            Integer n = itemNum;
            Integer n2 = itemNum = Integer.valueOf(itemNum + 1);
        }
        return itemNum;
    }

    @Deprecated
    protected void renderRadio(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId) throws IOException {
        this.renderRadio(facesContext, (UIInput)uiComponent, value, disabled, checked, renderId, 0);
    }

    protected String renderRadio(FacesContext facesContext, UIInput uiComponent, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = itemNum == null ? null : clientId + facesContext.getNamingContainerSeparatorChar() + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", (UIComponent)uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", (Object)itemId, null);
        } else if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        writer.writeAttribute("type", (Object)"radio", null);
        String group = null;
        if (uiComponent instanceof HtmlSelectOneRadio) {
            group = ((HtmlSelectOneRadio)uiComponent).getGroup();
        }
        if (group != null && group.length() > 0) {
            FormInfo formInfo = RendererUtils.findNestingForm((UIComponent)uiComponent, facesContext);
            writer.writeAttribute("name", (Object)(formInfo.getFormName() + facesContext.getNamingContainerSeparatorChar() + group), null);
        } else {
            writer.writeAttribute("name", (Object)clientId, null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (group != null && group.length() > 0) {
            if (value != null) {
                writer.writeAttribute("value", (Object)(clientId + facesContext.getNamingContainerSeparatorChar() + value), null);
            } else {
                writer.writeAttribute("value", (Object)(clientId + facesContext.getNamingContainerSeparatorChar() + ""), null);
            }
        } else if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        } else {
            writer.writeAttribute("value", (Object)"", null);
        }
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)uiComponent);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderChangeEventProperty(writer, commonPropertiesMarked, (UIComponent)uiComponent);
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, (UIComponent)uiComponent);
                CommonPropertyUtils.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, (UIComponent)uiComponent);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, (UIComponent)uiComponent, itemId != null ? itemId : clientId, behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked((UIComponent)uiComponent);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)uiComponent, itemId != null ? itemId : clientId, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, (UIComponent)uiComponent, itemId != null ? itemId : clientId, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)uiComponent, itemId != null ? itemId : clientId, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, (UIComponent)uiComponent, itemId != null ? itemId : clientId, behaviors);
                }
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);
        }
        if (this.isDisabled(facesContext, (UIComponent)uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UIInput) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        }
        if (uiComponent instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(uiComponent)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        return RendererUtils.getConvertedUISelectOneValue(facesContext, (UISelectOne)uiComponent, submittedValue);
    }

    private static class GetSelectItemListCallback
    implements VisitCallback {
        private String group;
        private List selectItemList;
        private Converter converter;
        private Object currentValue;

        public GetSelectItemListCallback(String group) {
            this.group = group;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target instanceof UISelectOne) {
                String targetGroup = ((UISelectOne)target).getGroup();
                if (this.getGroup().equals(targetGroup)) {
                    ValueExpression value = target.getValueExpression("value");
                    if (value != null) {
                        UISelectOne selectOne = (UISelectOne)target;
                        FacesContext facesContext = context.getFacesContext();
                        this.selectItemList = RendererUtils.getSelectItemList(selectOne, facesContext);
                        this.converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, (UIComponent)selectOne);
                        if (this.selectItemList != null && this.selectItemList.size() > 0) {
                            this.currentValue = RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(context.getFacesContext(), (UIComponent)selectOne);
                        }
                        return VisitResult.COMPLETE;
                    }
                } else {
                    return VisitResult.REJECT;
                }
            }
            return VisitResult.ACCEPT;
        }

        public String getGroup() {
            return this.group;
        }

        public List getSelectItemList() {
            return this.selectItemList;
        }

        public Converter getConverter() {
            return this.converter;
        }

        public Object getCurrentValue() {
            return this.currentValue;
        }
    }
}

