/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.faces.application.ResourceVisitOption;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;

public class ExternalContextResourceLoaderIterator
implements Iterator<String> {
    private FacesContext facesContext;
    private String basePath;
    private int maxDepth;
    private ResourceVisitOption[] options;
    private Deque<String> stack = new LinkedList<String>();

    public ExternalContextResourceLoaderIterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        this.facesContext = facesContext;
        this.basePath = path;
        this.maxDepth = maxDepth;
        this.options = options;
        Set paths = facesContext.getExternalContext().getResourcePaths(this.basePath);
        if (paths != null) {
            for (String p : paths) {
                if (p.startsWith("/WEB-INF") || p.startsWith("/META-INF")) continue;
                this.stack.add(p);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.stack.isEmpty()) {
            String path = this.stack.peek();
            do {
                if (!ResourceLoaderUtils.isDirectory(path)) continue;
                path = this.stack.pop();
                int depth = ResourceLoaderUtils.getDepth(path);
                if (depth < this.maxDepth) {
                    Set list = this.facesContext.getExternalContext().getResourcePaths(path);
                    for (String p : list) {
                        this.stack.add(p);
                    }
                }
                path = !this.stack.isEmpty() ? this.stack.peek() : null;
            } while (path != null && ResourceLoaderUtils.isDirectory(path) && !this.stack.isEmpty());
            return !this.stack.isEmpty();
        }
        return false;
    }

    @Override
    public String next() {
        if (!this.stack.isEmpty()) {
            String path = this.stack.pop();
            do {
                if (!ResourceLoaderUtils.isDirectory(path)) continue;
                int depth = ResourceLoaderUtils.getDepth(path);
                if (depth < this.maxDepth) {
                    Set list = this.facesContext.getExternalContext().getResourcePaths(path);
                    for (String p : list) {
                        this.stack.add(p);
                    }
                }
                path = !this.stack.isEmpty() ? this.stack.pop() : null;
            } while (path != null && ResourceLoaderUtils.isDirectory(path) && !this.stack.isEmpty());
            if (path != null) {
                return path;
            }
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

