/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewVisitOption;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.ViewMetadata;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.application.viewstate.StateCacheUtils;
import org.apache.myfaces.shared.application.DefaultViewHandlerSupport;
import org.apache.myfaces.shared.application.InvalidViewIdException;
import org.apache.myfaces.shared.application.ViewHandlerSupport;
import org.apache.myfaces.view.facelets.StateWriter;

public class ViewHandlerImpl
extends ViewHandler {
    private static final Logger log = Logger.getLogger(ViewHandlerImpl.class.getName());
    public static final String FORM_STATE_MARKER = "<!--@@JSF_FORM_STATE_MARKER@@-->";
    private ViewHandlerSupport _viewHandlerSupport;
    private ViewDeclarationLanguageFactory _vdlFactory;
    private Set<String> _protectedViewsSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> _unmodifiableProtectedViewsSet = Collections.unmodifiableSet(this._protectedViewsSet);

    public static ViewHandler getViewHandler(FacesContext facesContext) {
        return facesContext.getApplication().getViewHandler();
    }

    public ViewHandlerImpl() {
        this._vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New ViewHandler instance created");
        }
    }

    public String deriveViewId(FacesContext context, String input) {
        if (input != null) {
            try {
                return this.getViewHandlerSupport(context).calculateAndCheckViewId(context, input);
            }
            catch (InvalidViewIdException e) {
                this.sendSourceNotFound(context, e.getMessage());
            }
        }
        return input;
    }

    public String deriveLogicalViewId(FacesContext context, String rawViewId) {
        if (rawViewId != null) {
            try {
                return this.getViewHandlerSupport(context).calculateViewId(context, rawViewId);
            }
            catch (InvalidViewIdException e) {
                this.sendSourceNotFound(context, e.getMessage());
            }
        }
        return rawViewId;
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> viewParameters = includeViewParams ? this.getViewParameterList(context, viewId, parameters) : parameters;
        String actionEncodedViewId = ViewHandlerImpl.getViewHandler(context).getActionURL(context, viewId);
        ExternalContext externalContext = context.getExternalContext();
        String bookmarkEncodedURL = externalContext.encodeBookmarkableURL(actionEncodedViewId, viewParameters);
        return externalContext.encodeActionURL(bookmarkEncodedURL);
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> viewParameters = includeViewParams ? this.getViewParameterList(context, viewId, parameters) : parameters;
        String actionEncodedViewId = ViewHandlerImpl.getViewHandler(context).getActionURL(context, viewId);
        ExternalContext externalContext = context.getExternalContext();
        String redirectEncodedURL = externalContext.encodeRedirectURL(actionEncodedViewId, viewParameters);
        return externalContext.encodeActionURL(redirectEncodedURL);
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this._vdlFactory.getViewDeclarationLanguage(viewId);
    }

    public void initView(FacesContext context) throws FacesException {
        if (context.getExternalContext().getRequestCharacterEncoding() == null) {
            super.initView(context);
        }
    }

    public Locale calculateLocale(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        Iterator requestLocales = facesContext.getExternalContext().getRequestLocales();
        while (requestLocales.hasNext()) {
            Locale requestLocale = (Locale)requestLocales.next();
            Iterator supportedLocales = application.getSupportedLocales();
            while (supportedLocales.hasNext()) {
                Locale supportedLocale = (Locale)supportedLocales.next();
                if (requestLocale.getLanguage().equals(supportedLocale.getLanguage()) && (supportedLocale.getCountry() == null || supportedLocale.getCountry().length() == 0)) {
                    return supportedLocale;
                }
                if (!supportedLocale.equals(requestLocale)) continue;
                return supportedLocale;
            }
        }
        Locale defaultLocale = application.getDefaultLocale();
        return defaultLocale != null ? defaultLocale : Locale.getDefault();
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        Object renderKitId = facesContext.getExternalContext().getRequestMap().get("javax.faces.RenderKitId");
        if (renderKitId == null) {
            renderKitId = facesContext.getApplication().getDefaultRenderKitId();
        }
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId.toString();
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        this.checkNull(context, "facesContext");
        String calculatedViewId = this.getViewHandlerSupport(context).calculateViewId(context, viewId);
        ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(context, calculatedViewId);
        if (vdl == null) {
            this.sendSourceNotFound(context, viewId);
            return null;
        }
        return vdl.createView(context, calculatedViewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        this.checkNull(context, "facesContext");
        this.checkNull(viewId, "viewId");
        return this.getViewHandlerSupport(context).calculateActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        this.checkNull(facesContext, "facesContext");
        this.checkNull(path, "path");
        if (path.length() > 0 && path.charAt(0) == '/') {
            String contextPath = facesContext.getExternalContext().getRequestContextPath();
            if (contextPath == null) {
                return path;
            }
            if (contextPath.length() == 1 && contextPath.charAt(0) == '/') {
                return path;
            }
            return contextPath + path;
        }
        return path;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        this.checkNull(context, "context");
        this.checkNull(viewToRender, "viewToRender");
        this.getViewDeclarationLanguage(context, viewToRender.getViewId()).renderView(context, viewToRender);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.checkNull(context, "context");
        String calculatedViewId = this.getViewHandlerSupport(context).calculateViewId(context, viewId);
        ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(context, calculatedViewId);
        if (vdl == null) {
            this.sendSourceNotFound(context, viewId);
            return null;
        }
        return vdl.restoreView(context, calculatedViewId);
    }

    public void writeState(FacesContext context) throws IOException {
        this.checkNull(context, "context");
        if (context.getPartialViewContext().isAjaxRequest()) {
            return;
        }
        ResponseStateManager responseStateManager = context.getRenderKit().getResponseStateManager();
        this.setWritingState(context, responseStateManager);
        StateManager stateManager = context.getApplication().getStateManager();
        if (StateCacheUtils.isMyFacesResponseStateManager(responseStateManager)) {
            if (StateCacheUtils.getMyFacesResponseStateManager(responseStateManager).isWriteStateAfterRenderViewRequired(context)) {
                context.getResponseWriter().write(FORM_STATE_MARKER);
            } else {
                stateManager.writeState(context, (Object)new Object[2]);
            }
        } else {
            context.getResponseWriter().write(FORM_STATE_MARKER);
        }
    }

    public void addProtectedView(String urlPattern) {
        this._protectedViewsSet.add(urlPattern);
    }

    public boolean removeProtectedView(String urlPattern) {
        return this._protectedViewsSet.remove(urlPattern);
    }

    public Set<String> getProtectedViewsUnmodifiable() {
        return this._unmodifiableProtectedViewsSet;
    }

    private void setWritingState(FacesContext context, ResponseStateManager rsm) {
        StateWriter stateWriter = StateWriter.getCurrentInstance(context);
        if (stateWriter != null) {
            if (StateCacheUtils.isMyFacesResponseStateManager(rsm)) {
                if (StateCacheUtils.getMyFacesResponseStateManager(rsm).isWriteStateAfterRenderViewRequired(context)) {
                    stateWriter.writingState();
                } else {
                    stateWriter.writingStateWithoutWrapper();
                }
            } else {
                stateWriter.writingState();
            }
        }
    }

    private Map<String, List<String>> getViewParameterList(FacesContext context, String viewId, Map<String, List<String>> parametersFromArg) {
        UIViewRoot viewRoot = context.getViewRoot();
        String currentViewId = viewRoot.getViewId();
        Collection toViewParams = null;
        Collection currentViewParams = ViewMetadata.getViewParameters((UIViewRoot)viewRoot);
        if (currentViewId.equals(viewId)) {
            toViewParams = currentViewParams;
        } else {
            String calculatedViewId = this.getViewHandlerSupport(context).calculateViewId(context, viewId);
            ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(context, calculatedViewId);
            ViewMetadata viewMetadata = vdl.getViewMetadata(context, viewId);
            if (viewMetadata != null) {
                UIViewRoot viewFromMetaData = viewMetadata.createMetadataView(context);
                toViewParams = ViewMetadata.getViewParameters((UIViewRoot)viewFromMetaData);
            }
        }
        if (toViewParams == null || toViewParams.isEmpty()) {
            return parametersFromArg;
        }
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.putAll(parametersFromArg);
        for (UIViewParameter viewParameter : toViewParams) {
            if (parameters.containsKey(viewParameter.getName())) continue;
            String parameterValue = viewParameter.getStringValueFromModel(context);
            if (parameterValue == null) {
                if (currentViewId.equals(viewId)) {
                    parameterValue = viewParameter.getStringValue(context);
                } else if (viewParameter.getName() != null) {
                    for (UIViewParameter curParam : currentViewParams) {
                        if (!viewParameter.getName().equals(curParam.getName())) continue;
                        parameterValue = curParam.getStringValue(context);
                        break;
                    }
                }
            }
            if (parameterValue == null) continue;
            ArrayList<String> parameterValueList = new ArrayList<String>();
            parameterValueList.add(parameterValue);
            parameters.put(viewParameter.getName(), parameterValueList);
        }
        return parameters;
    }

    private void checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(param + " can not be null.");
        }
    }

    private void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    public void setViewHandlerSupport(ViewHandlerSupport viewHandlerSupport) {
        this._viewHandlerSupport = viewHandlerSupport;
    }

    protected ViewHandlerSupport getViewHandlerSupport() {
        return this.getViewHandlerSupport(FacesContext.getCurrentInstance());
    }

    protected ViewHandlerSupport getViewHandlerSupport(FacesContext context) {
        if (this._viewHandlerSupport == null) {
            this._viewHandlerSupport = new DefaultViewHandlerSupport(context);
        }
        return this._viewHandlerSupport;
    }

    public Stream<String> getViews(FacesContext facesContext, String path, int maxDepth, ViewVisitOption ... options) {
        Stream concatenatedStream = null;
        for (ViewDeclarationLanguage vdl : this._vdlFactory.getAllViewDeclarationLanguages()) {
            Stream stream = vdl.getViews(facesContext, path, maxDepth, options);
            if (concatenatedStream == null) {
                concatenatedStream = stream;
                continue;
            }
            concatenatedStream = Stream.concat(concatenatedStream, stream);
        }
        return concatenatedStream == null ? Stream.empty() : concatenatedStream;
    }
}

