/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.annotation.ManagedProperty;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.bean.ManagedPropertyInfo;
import org.apache.myfaces.shared.util.ClassUtils;

public class DynamicManagedPropertyProducer
implements Bean<Object>,
Serializable,
PassivationCapable {
    private static final long serialVersionUID = 1L;
    private BeanManager beanManager;
    private ManagedPropertyInfo typeInfo;
    private Set<Type> types;
    private Class<?> beanClass;

    public DynamicManagedPropertyProducer(BeanManager beanManager, ManagedPropertyInfo typeInfo) {
        this.beanManager = beanManager;
        this.typeInfo = typeInfo;
        this.types = new HashSet<Type>(Arrays.asList(typeInfo.getType(), Object.class));
        this.beanClass = ClassUtils.simpleClassForName(typeInfo.getType().getTypeName());
    }

    public String getId() {
        return this.typeInfo.getType() + "_" + this.typeInfo.getExpression();
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.singleton(new DefaultAnnotationLiteral(this.typeInfo.getExpression()));
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return true;
    }

    public Object create(CreationalContext<Object> cc) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().evaluateExpressionGet(facesContext, this.typeInfo.getExpression(), this.beanClass);
    }

    public void destroy(Object t, CreationalContext<Object> cc) {
    }

    public static class DefaultAnnotationLiteral
    extends AnnotationLiteral<ManagedProperty>
    implements ManagedProperty {
        private static final long serialVersionUID = 1L;
        private String value;

        public DefaultAnnotationLiteral(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

