/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.behavior;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.component.behavior.FacesBehavior;
import org.apache.myfaces.cdi.behavior.BehaviorInfo;
import org.apache.myfaces.cdi.behavior.DynamicBehaviorProducer;

public class FacesBehaviorExtension
implements Extension {
    private Set<BehaviorInfo> types = new HashSet<BehaviorInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesBehavior.class)) {
            AnnotatedType annotated = event.getAnnotatedBeanClass();
            Type type = annotated.getBaseType();
            FacesBehavior conv = (FacesBehavior)annotated.getAnnotation(FacesBehavior.class);
            if (conv.managed()) {
                boolean hasValue;
                boolean bl = hasValue = conv.value().length() > 0;
                if (hasValue) {
                    this.types.add(new BehaviorInfo(type, conv.value()));
                }
            }
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (BehaviorInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new DynamicBehaviorProducer(beanManager, typeInfo));
        }
    }
}

