/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.component;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import org.apache.myfaces.cdi.component.DynamicUIComponentProxyProducer;
import org.apache.myfaces.cdi.component.ResolveComponent;
import org.apache.myfaces.cdi.component.ResolveComponentInfo;

public class ComponentBindingExtension
implements Extension {
    private Set<ResolveComponentInfo> types = new HashSet<ResolveComponentInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        for (AnnotatedField field : event.getAnnotatedBeanClass().getFields()) {
            this.addAnnotatedTypeIfNecessary((Annotated)field);
        }
        for (AnnotatedConstructor constructor : event.getAnnotatedBeanClass().getConstructors()) {
            for (AnnotatedParameter parameter : constructor.getParameters()) {
                this.addAnnotatedTypeIfNecessary((Annotated)parameter);
            }
        }
    }

    private void addAnnotatedTypeIfNecessary(Annotated annotated) {
        if (annotated.isAnnotationPresent(ResolveComponent.class)) {
            Type type = annotated.getBaseType();
            this.types.add(new ResolveComponentInfo(type, ((ResolveComponent)annotated.getAnnotation(ResolveComponent.class)).value()));
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (ResolveComponentInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new DynamicUIComponentProxyProducer(beanManager, typeInfo));
        }
    }
}

