/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.converter;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.FacesException;
import javax.faces.convert.Converter;
import org.apache.myfaces.cdi.converter.ConverterInfo;
import org.apache.myfaces.cdi.converter.FacesConverterAnnotationLiteral;
import org.apache.myfaces.shared.util.ClassUtils;

@Typed
public class DynamicConverterProducer
implements Bean<Converter>,
Serializable,
PassivationCapable {
    private static final long serialVersionUID = 1L;
    private BeanManager beanManager;
    private ConverterInfo typeInfo;
    private Set<Type> types;
    private Class<?> beanClass;

    public DynamicConverterProducer(BeanManager beanManager, ConverterInfo typeInfo) {
        this.beanManager = beanManager;
        this.typeInfo = typeInfo;
        this.types = new HashSet<Type>(Arrays.asList(typeInfo.getType(), Object.class));
        this.beanClass = ClassUtils.simpleClassForName(typeInfo.getType().getTypeName());
    }

    public String getId() {
        String forClass = this.typeInfo.getForClass() == null ? "" : (this.typeInfo.getForClass() == Object.class ? "" : this.typeInfo.getForClass().getName());
        String converterId = this.typeInfo.getConverterId() == null ? "" : this.typeInfo.getConverterId();
        return "" + this.typeInfo.getType() + "_" + forClass + "_" + converterId;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.singleton(new FacesConverterAnnotationLiteral(this.typeInfo.getForClass() == null ? Object.class : this.typeInfo.getForClass(), this.typeInfo.getConverterId() == null ? "" : this.typeInfo.getConverterId(), true));
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return true;
    }

    public Converter create(CreationalContext<Converter> cc) {
        Class<?> converterClass = this.beanClass;
        Converter converter = null;
        try {
            converter = (Converter)converterClass.newInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(DynamicConverterProducer.class.getName()).log(Level.SEVERE, "Could not instantiate converter " + this.beanClass.getName().toString(), ex);
            throw new FacesException("Could not instantiate converter: " + this.beanClass.getName().toString(), (Throwable)ex);
        }
        return converter;
    }

    public void destroy(Converter t, CreationalContext<Converter> cc) {
    }
}

