/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.faces;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.faces.FacesScopedContextImpl;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;

public class FacesScopeBeanHolder {
    public static final String FACES_SCOPE_MAP = "oam.FACES_SCOPE_MAP";
    public static final String FACES_SCOPE_MAP_INFO = "oam.FACES_SCOPE_MAP_INFO";

    public void init() {
    }

    public static ContextualStorage getContextualStorage(BeanManager beanManager, FacesContext facesContext) {
        ContextualStorage contextualStorage = (ContextualStorage)facesContext.getAttributes().get(FACES_SCOPE_MAP);
        if (contextualStorage == null) {
            contextualStorage = new ContextualStorage(beanManager, false, false);
            facesContext.getAttributes().put(FACES_SCOPE_MAP, contextualStorage);
        }
        return contextualStorage;
    }

    public ContextualStorage getContextualStorageNoCreate(BeanManager beanManager, FacesContext facesContext) {
        return (ContextualStorage)facesContext.getAttributes().get(FACES_SCOPE_MAP);
    }

    public Map<Object, Object> getFacesScopeMap(BeanManager beanManager, FacesContext facesContext, boolean create) {
        HashMap map = null;
        if (create) {
            ContextualStorage contextualStorage = FacesScopeBeanHolder.getContextualStorage(beanManager, facesContext);
            ContextualInstanceInfo<Object> info = contextualStorage.getStorage().get(FACES_SCOPE_MAP_INFO);
            if (info == null) {
                info = new ContextualInstanceInfo();
                contextualStorage.getStorage().put(FACES_SCOPE_MAP_INFO, info);
            }
            if ((map = (HashMap)info.getContextualInstance()) == null) {
                map = new HashMap();
                info.setContextualInstance(map);
            }
        } else {
            ContextualInstanceInfo<?> info;
            ContextualStorage contextualStorage = this.getContextualStorageNoCreate(beanManager, facesContext);
            if (contextualStorage != null && (info = contextualStorage.getStorage().get(FACES_SCOPE_MAP_INFO)) != null) {
                map = (Map)info.getContextualInstance();
            }
        }
        return map;
    }

    public ContextualStorage forceNewStorage(FacesContext facesContext) {
        return (ContextualStorage)facesContext.getAttributes().remove(FACES_SCOPE_MAP);
    }

    public void destroyBeans(FacesContext facesContext) {
        ContextualStorage oldWindowContextStorages = this.forceNewStorage(facesContext);
        if (oldWindowContextStorages != null) {
            FacesScopedContextImpl.destroyAllActive(oldWindowContextStorages);
        }
    }
}

