/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.model;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.model.DataModel;
import org.apache.myfaces.cdi.model.DataModelInfo;
import org.apache.myfaces.cdi.model.FacesDataModelAnnotationLiteral;
import org.apache.myfaces.cdi.model.FacesDataModelClassBeanHolder;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.shared.util.ClassUtils;

@Typed
public class DynamicDataModelProducer
implements Bean<Map<Class<?>, Class<? extends DataModel>>>,
Serializable,
PassivationCapable {
    private static final long serialVersionUID = 1L;
    private BeanManager beanManager;
    private DataModelInfo typeInfo;
    private Set<Type> types;
    private Class<?> beanClass;

    public DynamicDataModelProducer(BeanManager beanManager, DataModelInfo typeInfo) {
        this.beanManager = beanManager;
        this.typeInfo = typeInfo;
        this.types = new HashSet<Type>(Arrays.asList(typeInfo.getType(), Object.class));
        this.beanClass = ClassUtils.simpleClassForName(typeInfo.getType().getTypeName());
    }

    public String getId() {
        return "" + this.typeInfo.getForClass();
    }

    public Class<?> getBeanClass() {
        return Map.class;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.singleton(new FacesDataModelAnnotationLiteral(this.typeInfo.getForClass()));
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return true;
    }

    public Map<Class<?>, Class<? extends DataModel>> create(CreationalContext<Map<Class<?>, Class<? extends DataModel>>> cc) {
        FacesDataModelClassBeanHolder holder = CDIUtils.lookup(this.beanManager, FacesDataModelClassBeanHolder.class);
        return holder.getClassInstanceToDataModelWrapperClassMap();
    }

    public void destroy(Map<Class<?>, Class<? extends DataModel>> t, CreationalContext<Map<Class<?>, Class<? extends DataModel>>> cc) {
    }
}

