/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.jsp;

import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.view.ViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.jsp.JspViewDeclarationLanguage;

public class JspViewDeclarationLanguageStrategy
implements ViewDeclarationLanguageStrategy {
    private ViewDeclarationLanguage _language;
    private LinkedList<String> _suffixes;
    public static final String JSP_SUFFIX_PARAM_NAME = "org.apache.myfaces.JSP_SUFFIX";
    public static final String JSP_SUFFIX_DEFAULT = ".jsp";

    public JspViewDeclarationLanguageStrategy() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this._language = new JspViewDeclarationLanguage(facesContext, this);
        this._suffixes = JspViewDeclarationLanguageStrategy.loadSuffixes(facesContext.getExternalContext());
    }

    @Override
    public ViewDeclarationLanguage getViewDeclarationLanguage() {
        return this._language;
    }

    @Override
    public boolean handles(String viewId) {
        for (String suffix : this._suffixes) {
            if (viewId == null || !viewId.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    static LinkedList<String> loadSuffixes(ExternalContext context) {
        LinkedList<String> result = new LinkedList<String>();
        String definedSuffixes = context.getInitParameter(JSP_SUFFIX_PARAM_NAME);
        if (definedSuffixes == null) {
            definedSuffixes = JSP_SUFFIX_DEFAULT;
        }
        StringTokenizer tokenizer = new StringTokenizer(definedSuffixes, " ");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    @Override
    public String getMinimalImplicitOutcome(String viewId) {
        for (String suffix : this._suffixes) {
            if (viewId == null || !viewId.endsWith(suffix)) continue;
            return viewId.substring(0, viewId.length() - suffix.length());
        }
        return viewId;
    }
}

