/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces.html;

import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributes;
import jakarta.faces.view.facelets.TagDecorator;
import java.util.Arrays;
import org.apache.myfaces.view.facelets.tag.TagAttributeImpl;
import org.apache.myfaces.view.facelets.tag.TagAttributesImpl;

public class DefaultTagDecorator
implements TagDecorator {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final String EMPTY_NAMESPACE = "";
    private static final String P_ELEMENTNAME = "p:elementName";
    private static final Object[][] LOCAL_NAME_ARR = new Object[256][];
    private static final Object[] A_NAMES = new Object[]{"a", new Object[]{new TagSelectorImpl("jsf:action", "h:commandLink"), new TagSelectorImpl("jsf:actionListener", "h:commandLink"), new TagSelectorImpl("jsf:value", "h:outputLink"), new TagSelectorImpl("jsf:outcome", "h:link")}};
    private static final Object[] B_NAMES = new Object[]{"body", new Object[]{new TagSelectorImpl(null, "h:body")}, "button", new Object[]{new TagSelectorImpl("jsf:outcome", "h:button"), new TagSelectorImpl(null, "h:commandButton")}};
    private static final Object[] F_NAMES = new Object[]{"form", new Object[]{new TagSelectorImpl(null, "h:form")}};
    private static final Object[] H_NAMES = new Object[]{"head", new Object[]{new TagSelectorImpl(null, "h:head")}};
    private static final Object[] I_NAMES = new Object[]{"img", new Object[]{new TagSelectorImpl(null, "h:graphicImage")}, "input", new Object[]{new TagSelectorImpl("type=\"button\"", "h:commandButton"), new TagSelectorImpl("type=\"checkbox\"", "h:selectBooleanCheckbox"), new TagSelectorImpl("type=\"color\"", "h:inputText"), new TagSelectorImpl("type=\"date\"", "h:inputText"), new TagSelectorImpl("type=\"datetime\"", "h:inputText"), new TagSelectorImpl("type=\"datetime-local\"", "h:inputText"), new TagSelectorImpl("type=\"email\"", "h:inputText"), new TagSelectorImpl("type=\"month\"", "h:inputText"), new TagSelectorImpl("type=\"number\"", "h:inputText"), new TagSelectorImpl("type=\"range\"", "h:inputText"), new TagSelectorImpl("type=\"search\"", "h:inputText"), new TagSelectorImpl("type=\"time\"", "h:inputText"), new TagSelectorImpl("type=\"url\"", "h:inputText"), new TagSelectorImpl("type=\"week\"", "h:inputText"), new TagSelectorImpl("type=\"file\"", "h:inputFile"), new TagSelectorImpl("type=\"hidden\"", "h:inputHidden"), new TagSelectorImpl("type=\"password\"", "h:inputSecret"), new TagSelectorImpl("type=\"reset\"", "h:commandButton"), new TagSelectorImpl("type=\"submit\"", "h:commandButton"), new TagSelectorImpl("type=\"*\"", "h:inputText")}};
    private static final Object[] L_NAMES = new Object[]{"label", new Object[]{new TagSelectorImpl(null, "h:outputLabel")}, "link", new Object[]{new TagSelectorImpl(null, "h:outputStylesheet")}};
    private static final Object[] S_NAMES = new Object[]{"script", new Object[]{new TagSelectorImpl(null, "h:outputScript")}, "select", new Object[]{new TagSelectorImpl("multiple=\"*\"", "h:selectManyListbox"), new TagSelectorImpl(null, "h:selectOneListbox")}};
    private static final Object[] T_NAMES = new Object[]{"textarea", new Object[]{new TagSelectorImpl(null, "h:inputTextarea")}};
    private static final TagDecoratorExecutor NO_MATCH_SELECTOR;

    public Tag decorate(Tag tag) {
        boolean jsfNamespaceFound = false;
        for (String namespace : tag.getAttributes().getNamespaces()) {
            if (!"jakarta.faces".equals(namespace) && !"http://xmlns.jcp.org/jsf".equals(namespace) && !"http://java.sun.com/jsf".equals(namespace)) continue;
            jsfNamespaceFound = true;
            break;
        }
        if (!jsfNamespaceFound) {
            return null;
        }
        if (EMPTY_NAMESPACE.equals(tag.getNamespace()) || XHTML_NAMESPACE.equals(tag.getNamespace())) {
            String localName = tag.getLocalName();
            boolean processed = false;
            if (this.isLocalNameDecorated(localName)) {
                Object[] array = LOCAL_NAME_ARR[localName.charAt(0)];
                int localNameIndex = -1;
                if (array != null) {
                    for (int i = array.length - 2; i >= 0; i -= 2) {
                        if (!localName.equalsIgnoreCase((String)array[i])) continue;
                        localNameIndex = i;
                        break;
                    }
                    if (localNameIndex >= 0) {
                        Object[] tagSelectorArray = (Object[])array[localNameIndex + 1];
                        for (int i = 0; i < tagSelectorArray.length; ++i) {
                            TagSelector tagSelector = (TagSelector)tagSelectorArray[i];
                            TagDecoratorExecutor executor = tagSelector.getExecutorIfApplies(tag);
                            if (executor == null) continue;
                            return executor.decorate(tag, this.convertTagAttributes(tag));
                        }
                    }
                }
            }
            if (!processed) {
                return NO_MATCH_SELECTOR.decorate(tag, this.convertTagAttributes(tag));
            }
            return null;
        }
        throw new FaceletException("Attributes under jakarta.faces can only be used for tags under http://www.w3.org/1999/xhtml or tags with no namespace defined");
    }

    private TagAttributes convertTagAttributes(Tag tag) {
        TagAttribute[] sourceTagAttributes = tag.getAttributes().getAll();
        String elementNameTagLocalName = tag.getLocalName();
        TagAttributeImpl elementNameTagAttribute = new TagAttributeImpl(tag.getLocation(), "jakarta.faces.passthrough", "elementName", P_ELEMENTNAME, elementNameTagLocalName);
        int duplicateCount = 0;
        TagAttribute[] convertedTagAttributes = new TagAttribute[sourceTagAttributes.length + 1 + duplicateCount];
        boolean elementNameTagAttributeSet = false;
        int j = 0;
        for (int i = 0; i < sourceTagAttributes.length; ++i) {
            Object qname;
            String convertedNamespace;
            TagAttribute tagAttribute = sourceTagAttributes[i];
            String namespace = tagAttribute.getNamespace();
            if ("jakarta.faces".equals(namespace) || "http://xmlns.jcp.org/jsf".equals(namespace) || "http://java.sun.com/jsf".equals(namespace)) {
                convertedNamespace = EMPTY_NAMESPACE;
                qname = tagAttribute.getLocalName();
                convertedTagAttributes[j] = new TagAttributeImpl(tagAttribute.getLocation(), convertedNamespace, tagAttribute.getLocalName(), (String)qname, tagAttribute.getValue());
            } else if (namespace == null) {
                convertedNamespace = "jakarta.faces.passthrough";
                qname = "p:" + tagAttribute.getLocalName();
                convertedTagAttributes[j] = new TagAttributeImpl(tagAttribute.getLocation(), convertedNamespace, tagAttribute.getLocalName(), (String)qname, tagAttribute.getValue());
            } else if (tagAttribute.getNamespace().length() == 0) {
                convertedNamespace = "jakarta.faces.passthrough";
                qname = "p:" + tagAttribute.getLocalName();
                convertedTagAttributes[j] = new TagAttributeImpl(tagAttribute.getLocation(), convertedNamespace, tagAttribute.getLocalName(), (String)qname, tagAttribute.getValue());
            } else {
                convertedTagAttributes[j] = tagAttribute;
            }
            if ("elementName".equals(convertedTagAttributes[j].getLocalName()) && ("jakarta.faces.passthrough".equals(convertedTagAttributes[j].getNamespace()) || "http://xmlns.jcp.org/jsf/passthrough".equals(convertedTagAttributes[j].getNamespace()) || "http://java.sun.com/jsf/passthrough".equals(convertedTagAttributes[j].getNamespace()))) {
                elementNameTagAttributeSet = true;
            }
            ++j;
        }
        if (elementNameTagAttributeSet) {
            return new TagAttributesImpl(Arrays.copyOf(convertedTagAttributes, convertedTagAttributes.length - 1));
        }
        convertedTagAttributes[convertedTagAttributes.length - 1] = elementNameTagAttribute;
        return new TagAttributesImpl(convertedTagAttributes);
    }

    private boolean isLocalNameDecorated(String elem) {
        Object[] array = LOCAL_NAME_ARR[elem.charAt(0)];
        if (array != null) {
            for (int i = array.length - 2; i >= 0; i -= 2) {
                if (!elem.equalsIgnoreCase((String)array[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static String resolveSelectorNamespace(String prefix) {
        if ("jsf".equals(prefix)) {
            return "jakarta.faces";
        }
        if ("h".equals(prefix)) {
            return "jakarta.faces.html";
        }
        if ("f".equals(prefix)) {
            return "jakarta.faces.core";
        }
        return EMPTY_NAMESPACE;
    }

    private static String resolveJcpSelectorNamespace(String prefix) {
        if ("jsf".equals(prefix)) {
            return "http://xmlns.jcp.org/jsf";
        }
        if ("h".equals(prefix)) {
            return "http://xmlns.jcp.org/jsf/html";
        }
        if ("f".equals(prefix)) {
            return "http://xmlns.jcp.org/jsf/core";
        }
        return EMPTY_NAMESPACE;
    }

    private static String resolveSunSelectorNamespace(String prefix) {
        if ("jsf".equals(prefix)) {
            return "http://java.sun.com/jsf";
        }
        if ("h".equals(prefix)) {
            return "http://java.sun.com/jsf/html";
        }
        if ("f".equals(prefix)) {
            return "http://java.sun.com/jsf/core";
        }
        return EMPTY_NAMESPACE;
    }

    static {
        DefaultTagDecorator.LOCAL_NAME_ARR[97] = A_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[65] = A_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[98] = B_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[66] = B_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[102] = F_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[70] = F_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[104] = H_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[72] = H_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[105] = I_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[73] = I_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[108] = L_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[76] = L_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[115] = S_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[83] = S_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[116] = T_NAMES;
        DefaultTagDecorator.LOCAL_NAME_ARR[84] = T_NAMES;
        NO_MATCH_SELECTOR = new TagSelectorImpl(null, "jsf:element");
    }

    private static class TagSelectorImpl
    extends TagSelector
    implements TagDecoratorExecutor {
        private String attributeQName;
        private String attributeLocalName;
        private String attributePrefix;
        private final String attributeNamespace;
        private final String attributeJcpNamespace;
        private final String attributeSunNamespace;
        private String matchValue;
        private String targetQName;
        private String targetNamespace;
        private String targetLocalName;

        public TagSelectorImpl(String selector, String targetQName) {
            if (selector != null) {
                int i = selector.indexOf(61);
                if (i >= 0) {
                    this.attributeQName = selector.substring(0, i);
                    String value = selector.substring(i + 1);
                    int s = value.indexOf(34);
                    int t = value.lastIndexOf(34);
                    this.matchValue = s >= 0 && t >= 0 && t > s ? value.substring(s + 1, t) : value;
                } else {
                    this.attributeQName = selector;
                    this.matchValue = null;
                }
                int j = this.attributeQName.indexOf(58);
                this.attributeLocalName = j >= 0 ? this.attributeQName.substring(j + 1) : this.attributeQName;
                this.attributePrefix = j >= 0 ? this.attributeQName.substring(0, j) : null;
                this.attributeNamespace = DefaultTagDecorator.resolveSelectorNamespace(this.attributePrefix);
                this.attributeJcpNamespace = DefaultTagDecorator.resolveJcpSelectorNamespace(this.attributePrefix);
                this.attributeSunNamespace = DefaultTagDecorator.resolveSunSelectorNamespace(this.attributePrefix);
            } else {
                this.attributeQName = null;
                this.matchValue = null;
                this.attributeLocalName = null;
                this.attributePrefix = null;
                this.attributeNamespace = DefaultTagDecorator.EMPTY_NAMESPACE;
                this.attributeJcpNamespace = null;
                this.attributeSunNamespace = null;
            }
            this.targetQName = targetQName;
            if (targetQName != null) {
                int j = targetQName.indexOf(58);
                if (j >= 0) {
                    if (j == 1 && targetQName.charAt(0) == 'h') {
                        this.targetNamespace = "jakarta.faces.html";
                        this.targetLocalName = targetQName.substring(j + 1);
                    } else if (j == 3 && targetQName.startsWith("jsf")) {
                        this.targetNamespace = "http://java.sun.com/jsf";
                        this.targetLocalName = targetQName.substring(j + 1);
                    }
                } else {
                    this.targetLocalName = targetQName;
                }
            }
        }

        @Override
        public TagDecoratorExecutor getExecutorIfApplies(Tag tag) {
            if (this.attributeQName != null) {
                if (this.matchValue != null) {
                    String attributeNS = this.attributeNamespace;
                    TagAttribute attr = tag.getAttributes().get(attributeNS, this.attributeLocalName);
                    if (attr == null && this.attributeJcpNamespace.length() > 0) {
                        attributeNS = this.attributeJcpNamespace;
                        attr = tag.getAttributes().get(attributeNS, this.attributeLocalName);
                    }
                    if (attr == null && this.attributeSunNamespace.length() > 0) {
                        attributeNS = this.attributeSunNamespace;
                        attr = tag.getAttributes().get(attributeNS, this.attributeLocalName);
                    }
                    if (attr != null) {
                        if (attributeNS.equals(attr.getNamespace())) {
                            if (this.matchValue.equals(attr.getValue())) {
                                return this;
                            }
                            if ("*".equals(this.matchValue) && attr.getValue() != null) {
                                return this;
                            }
                        } else if (DefaultTagDecorator.EMPTY_NAMESPACE.equals(attributeNS) && attr.getNamespace() == null) {
                            if (this.matchValue.equals(attr.getValue())) {
                                return this;
                            }
                            if ("*".equals(this.matchValue) && attr.getValue() != null) {
                                return this;
                            }
                        }
                    }
                } else {
                    String attributeNS = this.attributeNamespace;
                    TagAttribute attr = tag.getAttributes().get(attributeNS, this.attributeLocalName);
                    if (attr == null) {
                        attributeNS = this.attributeJcpNamespace;
                        attr = tag.getAttributes().get(attributeNS, this.attributeLocalName);
                    }
                    if (attr == null) {
                        attributeNS = this.attributeSunNamespace;
                        attr = tag.getAttributes().get(attributeNS, this.attributeLocalName);
                    }
                    if (attr != null) {
                        if (attributeNS.equals(attr.getNamespace())) {
                            return this;
                        }
                        if (DefaultTagDecorator.EMPTY_NAMESPACE.equals(attributeNS) && attr.getNamespace() == null) {
                            return this;
                        }
                    }
                }
                return null;
            }
            return this;
        }

        @Override
        public Tag decorate(Tag orig, TagAttributes attributes) {
            return new Tag(orig.getLocation(), this.targetNamespace, this.targetLocalName, this.targetQName, attributes);
        }
    }

    private static abstract class TagSelector {
        private TagSelector() {
        }

        public abstract TagDecoratorExecutor getExecutorIfApplies(Tag var1);
    }

    private static interface TagDecoratorExecutor {
        public Tag decorate(Tag var1, TagAttributes var2);
    }
}

