/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.logging;

import java.lang.reflect.Field;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.myfaces.extensions.cdi.core.api.logging.Logger;
import org.apache.myfaces.extensions.cdi.core.api.logging.LoggerDetails;
import org.apache.myfaces.extensions.cdi.core.impl.logging.DefaultLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class LoggerProducer {
    @Produces
    @Dependent
    public Logger getLogger(InjectionPoint injectionPoint) {
        Bean bean = injectionPoint.getBean();
        String name = null;
        if (bean != null) {
            name = bean.getBeanClass().getName();
        } else if (injectionPoint.getClass().getName().contains(".weld.")) {
            name = this.tryToExtractName(injectionPoint);
        }
        if (name == null) {
            throw new IllegalStateException("InjectionPoint#getBean returns null");
        }
        return new DefaultLogger(name);
    }

    private String tryToExtractName(InjectionPoint injectionPoint) {
        try {
            Object field1 = this.tryToGetFieldValue(injectionPoint, "field", Object.class);
            Field field2 = this.tryToGetFieldValue(field1, "field", Field.class);
            return field2.getDeclaringClass().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Produces
    @Dependent
    public Logger.Factory getLoggerFactory(InjectionPoint injectionPoint) {
        return new DefaultLogger(injectionPoint.getBean().getBeanClass().getName()).getFactory();
    }

    @Produces
    @Dependent
    @LoggerDetails
    public Logger getLoggerForDetails(InjectionPoint injectionPoint) {
        LoggerDetails loggerDetails = (LoggerDetails)injectionPoint.getAnnotated().getAnnotation(LoggerDetails.class);
        DefaultLogger logger = new DefaultLogger(loggerDetails.name(), loggerDetails.resourceBundleName(), loggerDetails.anonymous());
        if (!logger.isValid()) {
            java.util.logging.Logger.getLogger(LoggerProducer.class.getName()).warning("an injection point in " + injectionPoint.getBean().getBeanClass().getName() + " uses an empty qualifier of type " + LoggerDetails.class.getName() + " - please remove it!");
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T tryToGetFieldValue(Object object, String fieldName, Class<T> resultType) {
        for (Class<?> currentClass = object.getClass(); currentClass != null && !Object.class.getName().equals(currentClass.getName()); currentClass = currentClass.getSuperclass()) {
            for (Field currentField : currentClass.getDeclaredFields()) {
                if (!currentField.getName().equals(fieldName)) continue;
                boolean accessibleState = currentField.isAccessible();
                try {
                    currentField.setAccessible(true);
                    Object object2 = currentField.get(object);
                    return (T)object2;
                }
                catch (IllegalAccessException e) {
                    T t = null;
                    return t;
                }
                finally {
                    currentField.setAccessible(accessibleState);
                }
            }
        }
        return null;
    }
}

