/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class _SharedRendererUtils {
    private static final Log log = LogFactory.getLog((Class)_SharedRendererUtils.class);

    _SharedRendererUtils() {
    }

    static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if (String.class.equals(valueType)) {
            return null;
        }
        if (Object.class.equals(valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            _SharedRendererUtils.log(facesContext, "No Converter for type " + valueType.getName() + " found", (Exception)((Object)e));
            return null;
        }
    }

    static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue == null) {
            throw new NullPointerException("submittedValue");
        }
        ValueBinding vb = component.getValueBinding("value");
        Class valueType = null;
        Class arrayComponentType = null;
        if (vb != null && (valueType = vb.getType(facesContext)) != null && valueType.isArray()) {
            arrayComponentType = valueType.getComponentType();
        }
        if ((converter = component.getConverter()) == null) {
            if (valueType == null) {
                return submittedValue;
            }
            if (List.class.isAssignableFrom(valueType)) {
                int len = submittedValue.length;
                ArrayList<String> lst = new ArrayList<String>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(submittedValue[i]);
                }
                return lst;
            }
            if (arrayComponentType == null) {
                throw new IllegalArgumentException("ValueBinding for UISelectMany must be of type List or Array");
            }
            if (String.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            if (Object.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            try {
                converter = facesContext.getApplication().createConverter(arrayComponentType);
            }
            catch (FacesException e) {
                _SharedRendererUtils.log(facesContext, "No Converter for type " + arrayComponentType.getName() + " found", (Exception)((Object)e));
                return submittedValue;
            }
            if (converter == null) {
                _SharedRendererUtils.log(facesContext, "No Converter for type " + arrayComponentType.getName() + " found.", null);
                return submittedValue;
            }
        }
        if (vb != null && (valueType = vb.getType(facesContext)) != null && valueType.isArray() && submittedValue.length > 0) {
            arrayComponentType = converter.getAsObject(facesContext, (UIComponent)component, submittedValue[0]).getClass();
        }
        if (valueType == null) {
            int len = submittedValue.length;
            Object[] convertedValues = (Object[])Array.newInstance(arrayComponentType == null ? Object.class : arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                convertedValues[i] = converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]);
            }
            return convertedValues;
        }
        if (List.class.isAssignableFrom(valueType)) {
            int len = submittedValue.length;
            ArrayList<Object> lst = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                lst.add(converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return lst;
        }
        if (arrayComponentType == null) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany must be of type List or Array");
        }
        if (arrayComponentType.isPrimitive()) {
            int len = submittedValue.length;
            Object convertedValues = Array.newInstance(arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(convertedValues, i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return convertedValues;
        }
        int len = submittedValue.length;
        ArrayList<Object> convertedValues = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            convertedValues.add(i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
        }
        return convertedValues.toArray((Object[])Array.newInstance(arrayComponentType, len));
    }

    private static void log(FacesContext context, String msg, Exception e) {
        if (e != null) {
            log.error((Object)msg, (Throwable)e);
        } else {
            log.error((Object)msg);
        }
    }
}

