/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectManyMenu;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;

public class HtmlMenuRendererBase
extends HtmlRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectMany) {
            HtmlRendererUtils.renderMenu(facesContext, (UISelectMany)component, this.isDisabled(facesContext, component));
        } else if (component instanceof UISelectOne) {
            HtmlRendererUtils.renderMenu(facesContext, (UISelectOne)component, this.isDisabled(facesContext, component));
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        boolean readonly;
        boolean disabled;
        if (uiComponent instanceof HtmlSelectManyMenu) {
            disabled = ((HtmlSelectManyMenu)uiComponent).isDisabled();
            readonly = ((HtmlSelectManyMenu)uiComponent).isReadonly();
        } else if (uiComponent instanceof HtmlSelectOneMenu) {
            disabled = ((HtmlSelectOneMenu)uiComponent).isDisabled();
            readonly = ((HtmlSelectOneMenu)uiComponent).isReadonly();
        } else {
            disabled = RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
            readonly = RendererUtils.getBooleanAttribute(uiComponent, "readonly", false);
        }
        if (!disabled && readonly) {
            disabled = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isReadonlyAsDisabledForSelect();
        }
        return disabled;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, uiComponent);
        } else if (uiComponent instanceof UISelectOne) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)uiComponent, submittedValue);
        }
        if (uiComponent instanceof UISelectOne) {
            return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)((UISelectOne)uiComponent), submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
    }
}

