/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.context.flash;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseId;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.shared.context.flash.FlashScopeDisabledException;
import org.apache.myfaces.shared.context.flash.SubKeyMap;
import org.apache.myfaces.shared.util.ExternalContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashImpl
extends Flash {
    private static final Logger logger = Logger.getLogger(FlashImpl.class.getName());
    private static final String FLASH_SCOPE_DISABLED_PARAM = "org.apache.myfaces.FLASH_SCOPE_DISABLED";
    private static final String FLASH_PREFIX = "oam.Flash";
    static final String FLASH_INSTANCE = "oam.Flash.INSTANCE";
    static final String FLASH_REDIRECT = "oam.Flash.REDIRECT";
    static final String FLASH_PREVIOUS_REQUEST_REDIRECT = "oam.Flash.REDIRECT.PREVIOUSREQUEST";
    static final String FLASH_KEEP_MESSAGES = "oam.Flash.KEEP_MESSAGES";
    static final String FLASH_KEEP_MESSAGES_LIST = "KEEPMESSAGESLIST";
    static final String FLASH_SESSION_MAP_SUBKEY_PREFIX = "oam.Flash.SCOPE";
    static final String FLASH_RENDER_MAP = "oam.Flash.RENDERMAP";
    static final String FLASH_RENDER_MAP_TOKEN = "oam.Flash.RENDERMAP.TOKEN";
    static final String FLASH_EXECUTE_MAP = "oam.Flash.EXECUTEMAP";
    static final String FLASH_EXECUTE_MAP_TOKEN = "oam.Flash.EXECUTEMAP.TOKEN";
    static final char SEPARATOR_CHAR = '.';
    private final AtomicLong _count = new AtomicLong(FlashImpl._getSeed());
    private boolean _flashScopeDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Flash getCurrentInstance(ExternalContext context) {
        Map applicationMap = context.getApplicationMap();
        Flash flash = (Flash)applicationMap.get(FLASH_INSTANCE);
        if (flash == null) {
            Map map = applicationMap;
            synchronized (map) {
                flash = (Flash)applicationMap.get(FLASH_INSTANCE);
                if (flash == null) {
                    flash = new FlashImpl(context);
                    applicationMap.put(FLASH_INSTANCE, flash);
                }
            }
        }
        return flash;
    }

    private static long _getSeed() {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rng = new SecureRandom();
        }
        byte[] randomBytes = new byte[6];
        rng.nextBytes(randomBytes);
        return new BigInteger(randomBytes).longValue();
    }

    public FlashImpl(ExternalContext externalContext) {
        this._flashScopeDisabled = "true".equalsIgnoreCase(externalContext.getInitParameter(FLASH_SCOPE_DISABLED_PARAM));
    }

    public void doPrePhaseActions(FacesContext facesContext) {
        PhaseId currentPhaseId;
        if (!this._flashScopeDisabled && PhaseId.RESTORE_VIEW.equals(currentPhaseId = facesContext.getCurrentPhaseId())) {
            this._restoreRedirectValue(facesContext);
            this._manageFlashMapTokens(facesContext);
            this._restoreMessages(facesContext);
        }
    }

    public void doPostPhaseActions(FacesContext facesContext) {
        if (!this._flashScopeDisabled && this._isLastPhaseInRequest(facesContext)) {
            if (this._isRedirectTrueOnThisRequest(facesContext)) {
                Map<String, Object> renderMap = this._getRenderFlashMap(facesContext);
                for (Map.Entry<String, Object> entry : this._getExecuteFlashMap(facesContext).entrySet()) {
                    if (renderMap.containsKey(entry.getKey())) continue;
                    renderMap.put(entry.getKey(), entry.getValue());
                }
            }
            this._clearExecuteFlashMap(facesContext);
            this._saveMessages(facesContext);
        }
    }

    public boolean isRedirect() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean thisRedirect = this._isRedirectTrueOnThisRequest(facesContext);
        boolean prevRedirect = this._isRedirectTrueOnPreviousRequest(facesContext);
        boolean executePhase = !PhaseId.RENDER_RESPONSE.equals(facesContext.getCurrentPhaseId());
        return thisRedirect || executePhase && prevRedirect;
    }

    public void setRedirect(boolean redirect) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean alreadySet = (Boolean)requestMap.get(FLASH_REDIRECT);
        Boolean bl = alreadySet = alreadySet == null ? Boolean.FALSE : Boolean.TRUE;
        if (!alreadySet.booleanValue() && redirect) {
            requestMap.put(FLASH_REDIRECT, Boolean.TRUE);
            this._saveRedirectValue(facesContext);
        } else if (alreadySet.booleanValue()) {
            logger.warning("Multiple call to setRedirect() ignored.");
        } else {
            logger.warning("Ignored call to setRedirect(false), because this should only be set to true by the NavigationHandler. No one else should change it.");
        }
    }

    public void keep(String key) {
        Map<String, Object> executeMap;
        this._checkFlashScopeDisabled();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = requestMap.get(key);
        if (value == null && (executeMap = this._getExecuteFlashMap(facesContext)) != null) {
            value = executeMap.get(key);
            requestMap.put(key, value);
        }
        this._getRenderFlashMap(facesContext).put(key, value);
    }

    public void putNow(String key, Object value) {
        this._checkFlashScopeDisabled();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(key, value);
    }

    public boolean isKeepMessages() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean keepMessages = (Boolean)requestMap.get(FLASH_KEEP_MESSAGES);
        return keepMessages == null ? Boolean.FALSE : keepMessages;
    }

    public void setKeepMessages(boolean keepMessages) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        requestMap.put(FLASH_KEEP_MESSAGES, keepMessages);
    }

    public void clear() {
        this._checkFlashScopeDisabled();
        this._getFlashMapForWriting().clear();
    }

    public boolean containsKey(Object key) {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().containsKey(key);
    }

    public boolean containsValue(Object value) {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().entrySet();
    }

    public Object get(Object key) {
        this._checkFlashScopeDisabled();
        if (key == null) {
            return null;
        }
        if ("keepMessages".equals(key)) {
            return this.isKeepMessages();
        }
        if ("redirect".equals(key)) {
            return this.isRedirect();
        }
        return this._getFlashMapForReading().get(key);
    }

    public boolean isEmpty() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().isEmpty();
    }

    public Set<String> keySet() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().keySet();
    }

    public Object put(String key, Object value) {
        this._checkFlashScopeDisabled();
        if (key == null) {
            return null;
        }
        if ("keepMessages".equals(key)) {
            Boolean booleanValue = this._convertToBoolean(value);
            this.setKeepMessages(booleanValue);
            return booleanValue;
        }
        if ("redirect".equals(key)) {
            Boolean booleanValue = this._convertToBoolean(value);
            this.setRedirect(booleanValue);
            return booleanValue;
        }
        return this._getFlashMapForWriting().put(key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        this._checkFlashScopeDisabled();
        this._getFlashMapForWriting().putAll(m);
    }

    public Object remove(Object key) {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForWriting().remove(key);
    }

    public int size() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().size();
    }

    public Collection<Object> values() {
        this._checkFlashScopeDisabled();
        return this._getFlashMapForReading().values();
    }

    private boolean _isLastPhaseInRequest(FacesContext facesContext) {
        PhaseId currentPhaseId = facesContext.getCurrentPhaseId();
        boolean lastPhaseNormalRequest = PhaseId.RENDER_RESPONSE.equals(currentPhaseId);
        boolean lastPhaseIfRedirect = PhaseId.INVOKE_APPLICATION.equals(currentPhaseId) && this._isRedirectTrueOnThisRequest(facesContext);
        return lastPhaseNormalRequest || lastPhaseIfRedirect;
    }

    private boolean _isRedirectTrueOnThisRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean redirect = (Boolean)requestMap.get(FLASH_REDIRECT);
        return Boolean.TRUE.equals(redirect);
    }

    private boolean _isRedirectTrueOnPreviousRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Boolean redirect = (Boolean)requestMap.get(FLASH_PREVIOUS_REQUEST_REDIRECT);
        return Boolean.TRUE.equals(redirect);
    }

    private void _saveRedirectValue(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = this._createFlashCookie(FLASH_REDIRECT, "true", externalContext);
            httpResponse.addCookie(cookie);
        } else {
            externalContext.getSessionMap().put(FLASH_REDIRECT, true);
        }
    }

    private void _restoreRedirectValue(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_REDIRECT);
            if (cookie != null) {
                externalContext.getRequestMap().put(FLASH_PREVIOUS_REQUEST_REDIRECT, Boolean.TRUE);
                cookie.setMaxAge(0);
                cookie.setPath(this._getCookiePath(externalContext));
                httpResponse.addCookie(cookie);
            }
        } else {
            Map sessionMap = externalContext.getSessionMap();
            Boolean redirect = (Boolean)sessionMap.remove(FLASH_REDIRECT);
            externalContext.getRequestMap().put(FLASH_PREVIOUS_REQUEST_REDIRECT, redirect);
        }
    }

    private void _saveMessages(FacesContext facesContext) {
        if (this.isKeepMessages()) {
            ArrayList<MessageEntry> messageList = null;
            Iterator iterClientIds = facesContext.getClientIdsWithMessages();
            while (iterClientIds.hasNext()) {
                String clientId = (String)iterClientIds.next();
                Iterator iterMessages = facesContext.getMessages(clientId);
                while (iterMessages.hasNext()) {
                    FacesMessage message = (FacesMessage)iterMessages.next();
                    if (messageList == null) {
                        messageList = new ArrayList<MessageEntry>();
                    }
                    messageList.add(new MessageEntry(clientId, message));
                }
            }
            this._getRenderFlashMap(facesContext).put(FLASH_KEEP_MESSAGES_LIST, messageList);
        } else {
            this._getRenderFlashMap(facesContext).remove(FLASH_KEEP_MESSAGES_LIST);
        }
    }

    private void _restoreMessages(FacesContext facesContext) {
        List messageList = (List)this._getExecuteFlashMap(facesContext).get(FLASH_KEEP_MESSAGES_LIST);
        if (messageList != null) {
            for (MessageEntry entry : messageList) {
                facesContext.addMessage(entry.clientId, entry.message);
            }
            this._getExecuteFlashMap(facesContext).remove(FLASH_KEEP_MESSAGES_LIST);
        }
    }

    private void _saveRenderFlashMapTokenForNextRequest(ExternalContext externalContext) {
        String tokenValue = (String)externalContext.getRequestMap().get(FLASH_RENDER_MAP_TOKEN);
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = this._createFlashCookie(FLASH_RENDER_MAP_TOKEN, tokenValue, externalContext);
            httpResponse.addCookie(cookie);
        } else {
            Map sessionMap = externalContext.getSessionMap();
            sessionMap.put(FLASH_RENDER_MAP_TOKEN, tokenValue);
        }
    }

    private String _getRenderFlashMapTokenFromPreviousRequest(ExternalContext externalContext) {
        String tokenValue = null;
        HttpServletResponse httpResponse = ExternalContextUtils.getHttpServletResponse(externalContext);
        if (httpResponse != null) {
            Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_RENDER_MAP_TOKEN);
            if (cookie != null) {
                tokenValue = cookie.getValue();
            }
        } else {
            Map sessionMap = externalContext.getSessionMap();
            tokenValue = (String)sessionMap.get(FLASH_RENDER_MAP_TOKEN);
        }
        return tokenValue;
    }

    private void _manageFlashMapTokens(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String previousRenderToken = this._getRenderFlashMapTokenFromPreviousRequest(externalContext);
        if (previousRenderToken != null) {
            requestMap.put(FLASH_EXECUTE_MAP_TOKEN, previousRenderToken);
        } else {
            if (facesContext.isPostback()) {
                logger.warning("Identifier for execute FlashMap was lost on the postback, thus FlashScope information is gone.");
            }
            String newExecuteToken = this._getNextToken();
            requestMap.put(FLASH_EXECUTE_MAP_TOKEN, newExecuteToken);
        }
        String newRenderToken = this._getNextToken();
        requestMap.put(FLASH_RENDER_MAP_TOKEN, newRenderToken);
        this._saveRenderFlashMapTokenForNextRequest(externalContext);
    }

    private String _getNextToken() {
        long nextToken = this._count.incrementAndGet();
        return Long.toString(nextToken, 36);
    }

    private Map<String, Object> _createSubKeyMap(FacesContext context, String prefix) {
        ExternalContext external = context.getExternalContext();
        Map sessionMap = external.getSessionMap();
        return new SubKeyMap<Object>(sessionMap, prefix);
    }

    private Map<String, Object> _getRenderFlashMap(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Map<String, Object> map = (Map<String, Object>)requestMap.get(FLASH_RENDER_MAP);
        if (map == null) {
            String token = (String)requestMap.get(FLASH_RENDER_MAP_TOKEN);
            String fullToken = "oam.Flash.SCOPE." + token;
            map = this._createSubKeyMap(context, fullToken);
            requestMap.put(FLASH_RENDER_MAP, map);
        }
        return map;
    }

    private Map<String, Object> _getExecuteFlashMap(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Map<String, Object> map = (Map<String, Object>)requestMap.get(FLASH_EXECUTE_MAP);
        if (map == null) {
            String token = (String)requestMap.get(FLASH_EXECUTE_MAP_TOKEN);
            String fullToken = "oam.Flash.SCOPE." + token;
            map = this._createSubKeyMap(context, fullToken);
            requestMap.put(FLASH_EXECUTE_MAP, map);
        }
        return map;
    }

    private Map<String, Object> _getActiveFlashMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (PhaseId.RENDER_RESPONSE.equals(facesContext.getCurrentPhaseId()) || !facesContext.isPostback()) {
            return this._getRenderFlashMap(facesContext);
        }
        return this._getExecuteFlashMap(facesContext);
    }

    private Map<String, Object> _getFlashMapForReading() {
        return this._getExecuteFlashMap(FacesContext.getCurrentInstance());
    }

    private Map<String, Object> _getFlashMapForWriting() {
        return this._getActiveFlashMap();
    }

    private void _clearExecuteFlashMap(FacesContext facesContext) {
        Map<String, Object> map = this._getExecuteFlashMap(facesContext);
        map.clear();
    }

    private Cookie _createFlashCookie(String name, String value, ExternalContext externalContext) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(-1);
        cookie.setPath(this._getCookiePath(externalContext));
        cookie.setSecure(this._isCurrentRequestSecure(externalContext));
        return cookie;
    }

    private String _getCookiePath(ExternalContext externalContext) {
        String contextPath = externalContext.getRequestContextPath();
        if (contextPath == null || "".equals(contextPath)) {
            contextPath = "/";
        }
        return contextPath;
    }

    private boolean _isCurrentRequestSecure(ExternalContext externalContext) {
        boolean secure = false;
        Object requestObject = externalContext.getRequest();
        if (requestObject instanceof ServletRequest) {
            secure = ((ServletRequest)requestObject).isSecure();
        }
        return secure;
    }

    private Boolean _convertToBoolean(Object value) {
        Boolean booleanValue = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
        return booleanValue;
    }

    private void _checkFlashScopeDisabled() {
        if (this._flashScopeDisabled) {
            throw new FlashScopeDisabledException("Flash scope was disabled by context param org.apache.myfaces.FLASH_SCOPE_DISABLED but erroneously accessed");
        }
    }

    private static class MessageEntry
    implements Serializable {
        private static final long serialVersionUID = -690264660230199234L;
        private final String clientId;
        private final FacesMessage message;

        public MessageEntry(String clientId, FacesMessage message) {
            this.clientId = clientId;
            this.message = message;
        }
    }
}

