/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.shared.util._ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlButtonRendererBase
extends HtmlRenderer {
    private static final String IMAGE_BUTTON_SUFFIX_X = ".x";
    private static final String IMAGE_BUTTON_SUFFIX_Y = ".y";
    public static final String ACTION_FOR_LIST = "org.apache.myfaces.ActionForList";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UICommand.class);
        if (!HtmlButtonRendererBase.isReset(uiComponent) && HtmlButtonRendererBase.isSubmitted(facesContext, uiComponent)) {
            uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
            RendererUtils.initPartialValidationAndModelUpdate(uiComponent, facesContext);
        }
        if (uiComponent instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(uiComponent)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        }
    }

    private static boolean isReset(UIComponent uiComponent) {
        return "reset".equals((String)uiComponent.getAttributes().get("type"));
    }

    private static boolean isButton(UIComponent uiComponent) {
        return "button".equals((String)uiComponent.getAttributes().get("type"));
    }

    private static boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        String clientId = uiComponent.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        FormInfo formInfo = _ComponentUtils.findNestingForm(uiComponent, facesContext);
        String hiddenLink = null;
        if (formInfo != null) {
            hiddenLink = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo));
        }
        return paramMap.containsKey(clientId) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_X) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_Y) || hiddenLink != null && hiddenLink.equals(clientId) || HtmlRendererUtils.isPartialOrBehaviorSubmit(facesContext, clientId);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        CharSequence onClick;
        String commandOnclick;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UICommand.class);
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        FormInfo formInfo = this.findNestingForm(uiComponent, facesContext);
        boolean reset = HtmlButtonRendererBase.isReset(uiComponent);
        boolean button = HtmlButtonRendererBase.isButton(uiComponent);
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, this.getChildren(uiComponent), false, false);
        boolean javascriptAllowed = JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext());
        if (formInfo != null && javascriptAllowed && (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll() || validParams != null && !validParams.isEmpty())) {
            HtmlRendererUtils.renderFormSubmitScript(facesContext);
        }
        if ((commandOnclick = (String)uiComponent.getAttributes().get("onclick")) != null && validParams != null && !validParams.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "id");
        ExternalContext externalContext = facesContext.getExternalContext();
        String image = RendererUtils.getIconSrc(facesContext, uiComponent, "image");
        if (image != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            writer.writeURIAttribute("src", (Object)image, "image");
        } else {
            String type = this.getType(uiComponent);
            if (type == null || !reset && !button) {
                type = "submit";
            }
            writer.writeAttribute("type", (Object)type, "type");
            Object value = this.getValue(uiComponent);
            if (value != null) {
                writer.writeAttribute("value", value, "value");
            }
        }
        if (javascriptAllowed && (HtmlRendererUtils.hasClientBehavior("click", behaviors, facesContext) || HtmlRendererUtils.hasClientBehavior("action", behaviors, facesContext))) {
            if (!reset && !button) {
                onClick = this.buildBehaviorizedOnClick(uiComponent, behaviors, facesContext, writer, formInfo, validParams);
                if (((String)onClick).length() != 0) {
                    writer.writeAttribute("onclick", (Object)((String)onClick).toString(), null);
                }
            } else {
                Collection<ClientBehaviorContext.Parameter> paramList = HtmlRendererUtils.getClientBehaviorContextParameters(HtmlRendererUtils.mapAttachedParamsToStringValues(facesContext, uiComponent));
                String onClick2 = HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, "click", paramList, "action", paramList, behaviors, commandOnclick, null);
                if (onClick2.length() != 0) {
                    writer.writeAttribute("onclick", (Object)onClick2.toString(), null);
                }
            }
            Map attributes = uiComponent.getAttributes();
            HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, "dblclick", null, behaviors, (String)attributes.get("ondblclick"), "");
        } else if (javascriptAllowed) {
            if (!reset && !button) {
                onClick = this.buildOnClick(uiComponent, facesContext, writer, validParams);
                if (((StringBuffer)onClick).length() != 0) {
                    writer.writeAttribute("onclick", (Object)((StringBuffer)onClick).toString(), null);
                }
            } else {
                HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, "onclick", "onclick");
            }
        }
        if (javascriptAllowed) {
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderButtonPassthroughPropertiesWithoutDisabledAndEvents(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            }
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlers(facesContext, writer, uiComponent, behaviors);
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(uiComponent);
            CommonPropertyUtils.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, uiComponent);
            CommonPropertyUtils.renderCommonFieldEventProperties(writer, commonPropertiesMarked, uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
        }
        if (this.isReadonly(facesContext, uiComponent)) {
            writer.writeAttribute("readonly", (Object)Boolean.TRUE, "readonly");
        }
        writer.endElement("input");
        if (formInfo != null) {
            HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(formInfo.getForm(), facesContext, writer);
        }
    }

    private boolean hasSubmittingBehavior(Map<String, List<ClientBehavior>> clientBehaviors, String eventName) {
        List<ClientBehavior> eventBehaviors = clientBehaviors.get(eventName);
        if (eventBehaviors != null && !eventBehaviors.isEmpty()) {
            for (ClientBehavior behavior : eventBehaviors) {
                if (!behavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) continue;
                return true;
            }
        }
        return false;
    }

    protected String buildBehaviorizedOnClick(UIComponent uiComponent, Map<String, List<ClientBehavior>> behaviors, FacesContext facesContext, ResponseWriter writer, FormInfo nestedFormInfo, List<UIParameter> validParams) throws IOException {
        StringBuilder userOnClick = new StringBuilder();
        String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
        if (commandOnClick != null) {
            userOnClick.append(commandOnClick);
            userOnClick.append(';');
        }
        StringBuffer rendererOnClick = new StringBuffer();
        if (nestedFormInfo != null) {
            String formName = nestedFormInfo.getFormName();
            if (JavascriptUtils.isRenderClearJavascriptOnButton(facesContext.getExternalContext())) {
                HtmlRendererUtils.appendClearHiddenCommandFormParamsFunctionCall(rendererOnClick, formName);
            }
            if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
                HtmlRendererUtils.appendAutoScrollAssignment(rendererOnClick, formName);
            }
        }
        Collection<ClientBehaviorContext.Parameter> paramList = HtmlRendererUtils.getClientBehaviorContextParameters(HtmlRendererUtils.mapAttachedParamsToStringValues(facesContext, uiComponent));
        return HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, "click", paramList, "action", paramList, behaviors, userOnClick.toString(), rendererOnClick.toString());
    }

    protected String buildServerOnclick(FacesContext facesContext, UIComponent component, String clientId, FormInfo formInfo, List<UIParameter> validParams) throws IOException {
        UIComponent nestingForm = formInfo.getForm();
        String formName = formInfo.getFormName();
        StringBuffer onClick = new StringBuffer();
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            onClick.append("submitForm('");
            onClick.append(formInfo.getForm().getClientId(facesContext));
            onClick.append("',1,{source:'");
            onClick.append(component.getClientId(facesContext));
            onClick.append("'});return false;");
        } else {
            StringBuffer params = this.addChildParameters(facesContext, component, nestingForm, validParams);
            String target = this.getTarget(component);
            if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRenderFormSubmitScriptInline()) {
                onClick.append("return ").append("oamSubmitForm").append("('").append(formName).append("','").append(component.getClientId(facesContext)).append("'");
            } else {
                onClick.append("return ").append("myfaces.oam.submitForm").append("('").append(formName).append("','").append(component.getClientId(facesContext)).append("'");
            }
            if (params.length() > 2 || target != null) {
                onClick.append(",").append(target == null ? "null" : "'" + target + "'").append(",").append(params);
            }
            onClick.append(");");
        }
        return onClick.toString();
    }

    private StringBuffer addChildParameters(FacesContext context, UIComponent component, UIComponent nestingForm, List<UIParameter> validParams) {
        StringBuffer params = new StringBuffer();
        params.append("[");
        for (UIParameter param : validParams) {
            String name = param.getName();
            if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isRenderHiddenFieldsForLinkParams()) {
                this.addHiddenCommandParameter(context, nestingForm, name);
            }
            Object value = param.getValue();
            String strParamValue = "";
            if (value != null) {
                strParamValue = value.toString();
                StringBuffer buff = null;
                for (int i = 0; i < strParamValue.length(); ++i) {
                    char c = strParamValue.charAt(i);
                    if (c == '\'' || c == '\\') {
                        if (buff == null) {
                            buff = new StringBuffer();
                            buff.append(strParamValue.substring(0, i));
                        }
                        buff.append('\\');
                        buff.append(c);
                        continue;
                    }
                    if (buff == null) continue;
                    buff.append(c);
                }
                if (buff != null) {
                    strParamValue = buff.toString();
                }
            }
            if (params.length() > 1) {
                params.append(",");
            }
            params.append("['");
            params.append(name);
            params.append("','");
            params.append(strParamValue);
            params.append("']");
        }
        params.append("]");
        return params;
    }

    private String getTarget(UIComponent component) {
        String target = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getTarget() : (String)component.getAttributes().get("target");
        return target;
    }

    protected StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext, ResponseWriter writer, List<UIParameter> validParams) throws IOException {
        FormInfo nestedFormInfo;
        StringBuffer onClick = new StringBuffer();
        String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
        if (commandOnClick != null) {
            onClick.append("var cf = function(){");
            onClick.append(commandOnClick);
            onClick.append('}');
            onClick.append(';');
            onClick.append("var oamSF = function(){");
        }
        if ((nestedFormInfo = this.findNestingForm(uiComponent, facesContext)) != null) {
            String formName = nestedFormInfo.getFormName();
            if (validParams != null && !validParams.isEmpty()) {
                StringBuffer params = this.addChildParameters(facesContext, uiComponent, nestedFormInfo.getForm(), validParams);
                String target = this.getTarget(uiComponent);
                if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRenderFormSubmitScriptInline()) {
                    onClick.append("return ").append("oamSubmitForm").append("('").append(formName).append("','").append(uiComponent.getClientId(facesContext)).append("'");
                } else {
                    onClick.append("return ").append("myfaces.oam.submitForm").append("('").append(formName).append("','").append(uiComponent.getClientId(facesContext)).append("'");
                }
                if (params.length() > 2 || target != null) {
                    onClick.append(",").append(target == null ? "null" : "'" + target + "'").append(",").append(params);
                }
                onClick.append(");");
                if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRenderHiddenFieldsForLinkParams()) {
                    String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(nestedFormInfo);
                    this.addHiddenCommandParameter(facesContext, nestedFormInfo.getForm(), hiddenFieldName);
                }
            } else {
                if (JavascriptUtils.isRenderClearJavascriptOnButton(facesContext.getExternalContext()) || MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRenderHiddenFieldsForLinkParams()) {
                    HtmlRendererUtils.appendClearHiddenCommandFormParamsFunctionCall(onClick, formName);
                }
                if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
                    HtmlRendererUtils.appendAutoScrollAssignment(onClick, formName);
                }
            }
        }
        if (commandOnClick != null) {
            onClick.append('}');
            onClick.append(';');
            onClick.append("return (cf.apply(this, [])==false)? false : oamSF.apply(this, []); ");
        }
        return onClick;
    }

    protected void addHiddenCommandParameter(FacesContext facesContext, UIComponent nestingForm, String hiddenFieldName) {
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldName);
        }
    }

    protected FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        return RendererUtils.findNestingForm(uiComponent, facesContext);
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    protected boolean isReadonly(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).isReadonly();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "readonly", false);
    }

    private String getImage(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).getImage();
        }
        return (String)uiComponent.getAttributes().get("image");
    }

    private String getType(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).getType();
        }
        return (String)uiComponent.getAttributes().get("type");
    }

    private Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof ValueHolder) {
            return ((ValueHolder)uiComponent).getValue();
        }
        return uiComponent.getAttributes().get("value");
    }
}

