/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlImageRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlImageRendererBase.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIGraphic.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("img", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext()) && !behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        String url = RendererUtils.getIconSrc(facesContext, uiComponent, "url");
        if (url != null) {
            writer.writeURIAttribute("src", (Object)url, "value");
        } else if (facesContext.isProjectStage(ProjectStage.Development) && log.isLoggable(Level.WARNING)) {
            log.warning("Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute url, value, name or attribute resolves to null. Path to component " + RendererUtils.getPathToComponent(uiComponent));
        }
        if (uiComponent.getAttributes().get("alt") == null && !facesContext.isProjectStage(ProjectStage.Development) && log.isLoggable(Level.WARNING)) {
            log.warning("Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute alt or attribute resolves to null. Path to component " + RendererUtils.getPathToComponent(uiComponent));
        }
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
                CommonPropertyUtils.renderCommonPassthroughPropertiesWithoutEvents(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
            CommonPropertyUtils.renderCommonPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        }
        writer.endElement("img");
    }
}

