/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlOutcomeTargetButton;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlOutcomeTargetButtonRendererBase
extends HtmlRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeBegin(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "id");
        String image = this.getImage(uiComponent);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (image != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, image);
            writer.writeURIAttribute("src", (Object)externalContext.encodeResourceURL(src), "image");
        } else {
            writer.writeAttribute("type", (Object)"button", "type");
            String value = RendererUtils.getStringValue(facesContext, uiComponent);
            if (value != null) {
                writer.writeAttribute("value", (Object)value, "value");
            }
        }
        String outcomeTargetHref = HtmlRendererUtils.getOutcomeTargetHref(facesContext, (UIOutcomeTarget)uiComponent);
        if (HtmlRendererUtils.isDisabled(uiComponent) || outcomeTargetHref == null) {
            HtmlRendererUtils.renderHTMLAttribute(writer, "disabled", "disabled", true);
        } else {
            String href = facesContext.getExternalContext().encodeResourceURL(outcomeTargetHref);
            String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
            String navigationJavaScript = "window.location.href = '" + href + "'";
            if (behaviors != null && !behaviors.isEmpty()) {
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, "click", null, behaviors, "onclick", commandOnClick, navigationJavaScript);
            } else {
                StringBuffer onClick = new StringBuffer();
                if (commandOnClick != null) {
                    onClick.append(commandOnClick);
                    onClick.append(';');
                }
                onClick.append(navigationJavaScript);
                writer.writeAttribute("onclick", (Object)onClick.toString(), null);
            }
        }
        if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(uiComponent);
            if (JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
                if (behaviors != null && !behaviors.isEmpty() && uiComponent instanceof ClientBehaviorHolder) {
                    HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, uiComponent, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
                } else {
                    CommonPropertyUtils.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, uiComponent);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, uiComponent);
                }
            } else {
                CommonPropertyUtils.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, uiComponent);
                CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, uiComponent);
            }
            CommonPropertyUtils.renderCommonFieldPassthroughPropertiesWithoutDisabledAndEvents(writer, commonPropertiesMarked, uiComponent);
            if ((commonPropertiesMarked & 0x400L) != 0L) {
                CommonPropertyUtils.renderHTMLStringAttribute(writer, uiComponent, "alt", "alt");
            }
        } else {
            if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
                HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE);
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, "alt", "alt");
        }
        writer.flush();
    }

    private String getImage(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlOutcomeTargetButton) {
            return ((HtmlOutcomeTargetButton)uiComponent).getImage();
        }
        return (String)uiComponent.getAttributes().get("image");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
    }
}

