/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.view;

import java.beans.BeanInfo;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.Resource;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.shared.application.DefaultViewHandlerSupport;
import org.apache.myfaces.shared.application.ViewHandlerSupport;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.view.ResponseSwitch;
import org.apache.myfaces.shared.view.ViewDeclarationLanguageBase;
import org.apache.myfaces.shared.view.ViewResponseWrapper;

public abstract class JspViewDeclarationLanguageBase
extends ViewDeclarationLanguageBase {
    private static final Logger log = Logger.getLogger(JspViewDeclarationLanguageBase.class.getName());
    private static final String FORM_STATE_MARKER = "<!--@@JSF_FORM_STATE_MARKER@@-->";
    private static final String AFTER_VIEW_TAG_CONTENT_PARAM = JspViewDeclarationLanguageBase.class + ".AFTER_VIEW_TAG_CONTENT";
    private static final int FORM_STATE_MARKER_LEN = "<!--@@JSF_FORM_STATE_MARKER@@-->".length();
    private ViewHandlerSupport _cachedViewHandlerSupport;

    public void buildView(FacesContext context, UIViewRoot view) throws IOException {
        this.setViewBuilt(context, view);
        if (context.getPartialViewContext().isPartialRequest()) {
            Object origResponse = context.getExternalContext().getResponse();
            ResponseSwitch responseSwitch = ExternalContextUtils.getResponseSwitch(origResponse);
            if (responseSwitch == null && (responseSwitch = ExternalContextUtils.createResponseSwitch(origResponse)) != null) {
                context.getExternalContext().setResponse((Object)responseSwitch);
            }
            if (responseSwitch != null) {
                responseSwitch.setEnabled(false);
            }
        }
    }

    public BeanInfo getComponentMetadata(FacesContext context, Resource componentResource) {
        throw new UnsupportedOperationException();
    }

    public Resource getScriptComponentResource(FacesContext context, Resource componentResource) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot view) throws IOException {
        Object response;
        ResponseSwitch responseSwitch;
        this.checkNull(context, "context");
        this.checkNull(view, "view");
        if (!view.isRendered()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("View is not rendered");
            }
            return;
        }
        if (!this.isViewBuilt(context, view)) {
            this.buildView(context, view);
        }
        ExternalContext externalContext = context.getExternalContext();
        String viewId = context.getViewRoot().getViewId();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Rendering JSP view: " + viewId);
        }
        if (null != externalContext.getSession(false)) {
            externalContext.getSessionMap().put("javax.faces.request.charset", externalContext.getResponseCharacterEncoding());
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, view.getRenderKitId());
        ResponseWriter responseWriter = context.getResponseWriter();
        if (responseWriter == null) {
            responseWriter = renderKit.createResponseWriter(externalContext.getResponseOutputWriter(), null, externalContext.getRequestCharacterEncoding());
            context.setResponseWriter(responseWriter);
        }
        if ((responseSwitch = ExternalContextUtils.getResponseSwitch(response = context.getExternalContext().getResponse())) != null) {
            responseSwitch.setEnabled(true);
        }
        ResponseWriter oldResponseWriter = responseWriter;
        StringWriter stateAwareWriter = null;
        StateManager stateManager = context.getApplication().getStateManager();
        boolean viewStateAlreadyEncoded = this.isViewStateAlreadyEncoded(context);
        if (!viewStateAlreadyEncoded) {
            stateAwareWriter = new StringWriter();
            responseWriter = oldResponseWriter.cloneWithWriter((Writer)stateAwareWriter);
            context.setResponseWriter(responseWriter);
        }
        try {
            if (!this.actuallyRenderView(context, view)) {
                return;
            }
        }
        finally {
            if (oldResponseWriter != null) {
                context.setResponseWriter(oldResponseWriter);
            }
        }
        if (!viewStateAlreadyEncoded) {
            this.flushBufferToWriter(stateAwareWriter.getBuffer(), externalContext.getResponseOutputWriter());
        } else {
            stateManager.saveView(context);
        }
        if (responseSwitch != null) {
            responseSwitch.setEnabled(false);
        }
        ViewResponseWrapper afterViewTagResponse = (ViewResponseWrapper)externalContext.getRequestMap().get(AFTER_VIEW_TAG_CONTENT_PARAM);
        externalContext.getRequestMap().remove(AFTER_VIEW_TAG_CONTENT_PARAM);
        if (afterViewTagResponse != null) {
            afterViewTagResponse.flushToWriter(externalContext.getResponseOutputWriter(), externalContext.getResponseCharacterEncoding());
        }
        context.getResponseWriter().flush();
    }

    public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
        this.checkNull(context, "context");
        return null;
    }

    protected boolean isViewStateAlreadyEncoded(FacesContext context) {
        if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isMyfacesImplAvailable()) {
            StateManager stateManager = context.getApplication().getStateManager();
            return !context.getApplication().getStateManager().isSavingStateInClient(context);
        }
        return false;
    }

    protected void setAfterViewTagResponseWrapper(ExternalContext ec, ViewResponseWrapper wrapper) {
        ec.getRequestMap().put(AFTER_VIEW_TAG_CONTENT_PARAM, wrapper);
    }

    protected void flushBufferToWriter(StringBuffer buff, Writer writer) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StateManager stateManager = facesContext.getApplication().getStateManager();
        StringWriter stateWriter = new StringWriter();
        ResponseWriter realWriter = facesContext.getResponseWriter();
        facesContext.setResponseWriter(realWriter.cloneWithWriter((Writer)stateWriter));
        Object serializedView = stateManager.saveView(facesContext);
        stateManager.writeState(facesContext, serializedView);
        facesContext.setResponseWriter(realWriter);
        String state = stateWriter.getBuffer().toString();
        ExternalContext extContext = facesContext.getExternalContext();
        if (JavascriptUtils.isJavascriptAllowed(extContext) && MyfacesConfig.getCurrentInstance(extContext).isViewStateJavascript()) {
            this.writePartialBuffer(buff, 0, buff.length(), writer);
            writer.write(state);
        } else {
            int lastFormMarkerPos = 0;
            int formMarkerPos = 0;
            while ((formMarkerPos = buff.indexOf(FORM_STATE_MARKER, formMarkerPos)) > -1) {
                this.writePartialBuffer(buff, lastFormMarkerPos, formMarkerPos, writer);
                writer.write(state);
                lastFormMarkerPos = formMarkerPos += FORM_STATE_MARKER_LEN;
            }
            if (lastFormMarkerPos < buff.length()) {
                this.writePartialBuffer(buff, lastFormMarkerPos, buff.length(), writer);
            }
        }
    }

    protected void writePartialBuffer(StringBuffer contentBuffer, int beginIndex, int endIndex, Writer writer) throws IOException {
        int bufferSize = 2048;
        char[] bufToWrite = new char[bufferSize];
        for (int index = beginIndex; index < endIndex; index += bufferSize) {
            int maxSize = Math.min(bufferSize, endIndex - index);
            contentBuffer.getChars(index, index + maxSize, bufToWrite, 0);
            writer.write(bufToWrite, 0, maxSize);
        }
    }

    protected boolean actuallyRenderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startDocument();
        viewToRender.encodeAll(facesContext);
        responseWriter.endDocument();
        responseWriter.flush();
        return true;
    }

    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        return null;
    }

    protected String calculateViewId(FacesContext context, String viewId) {
        if (this._cachedViewHandlerSupport == null) {
            this._cachedViewHandlerSupport = new DefaultViewHandlerSupport();
        }
        return this._cachedViewHandlerSupport.calculateViewId(context, viewId);
    }

    protected boolean isViewBuilt(FacesContext facesContext, UIViewRoot view) {
        return Boolean.TRUE.equals(facesContext.getAttributes().get(view));
    }

    protected void setViewBuilt(FacesContext facesContext, UIViewRoot view) {
        facesContext.getAttributes().put(view, Boolean.TRUE);
    }
}

