/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.calendar;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.calendar.AbstractHtmlInputCalendar;
import org.apache.myfaces.custom.calendar.DateBusinessConverter;
import org.apache.myfaces.custom.calendar.DefaultDateBusinessConverter;
import org.apache.myfaces.custom.calendar.FunctionCallProvider;
import org.apache.myfaces.custom.calendar.HtmlInputCalendar;
import org.apache.myfaces.custom.inputTextHelp.HtmlInputTextHelp;
import org.apache.myfaces.custom.prototype.PrototypeResourceLoader;
import org.apache.myfaces.dateformat.DateFormatSymbols;
import org.apache.myfaces.dateformat.SimpleDateFormatter;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;

public class HtmlCalendarRenderer
extends HtmlRenderer {
    private final Log log = LogFactory.getLog((Class)HtmlCalendarRenderer.class);
    private static final String JAVASCRIPT_ENCODED = "org.apache.myfaces.calendar.JAVASCRIPT_ENCODED";
    private static final String RESOURCE_NONE = "none";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Date value;
        String textValue;
        RendererUtils.checkParamValidity(facesContext, component, HtmlInputCalendar.class);
        HtmlInputCalendar inputCalendar = (HtmlInputCalendar)component;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        this.log.debug((Object)("current locale:" + currentLocale.toString()));
        Converter converter = inputCalendar.getConverter();
        Object submittedValue = inputCalendar.getSubmittedValue();
        if (submittedValue != null) {
            textValue = (String)submittedValue;
            if (textValue == null || textValue.trim().length() == 0 || textValue.equals(HtmlCalendarRenderer.getHelperString((UIComponent)inputCalendar))) {
                value = null;
            } else {
                try {
                    String formatStr = CalendarDateTimeConverter.createJSPopupFormat(facesContext, inputCalendar.getPopupDateFormat());
                    Calendar timeKeeper = Calendar.getInstance(currentLocale);
                    int firstDayOfWeek = timeKeeper.getFirstDayOfWeek() - 1;
                    DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
                    SimpleDateFormatter dateFormat = new SimpleDateFormatter(formatStr, symbols, firstDayOfWeek);
                    value = dateFormat.parse(textValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    value = null;
                }
            }
        } else if (converter == null) {
            CalendarDateTimeConverter defaultConverter = new CalendarDateTimeConverter();
            value = this.getDateBusinessConverter(inputCalendar).getDateValue(facesContext, component, inputCalendar.getValue());
            textValue = defaultConverter.getAsString(facesContext, (UIComponent)inputCalendar, value);
        } else {
            value = (Date)inputCalendar.getValue();
            textValue = converter.getAsString(facesContext, (UIComponent)inputCalendar, (Object)value);
        }
        Calendar timeKeeper = Calendar.getInstance(currentLocale);
        timeKeeper.setTime(value != null ? value : new Date());
        java.text.DateFormatSymbols symbols = new java.text.DateFormatSymbols(currentLocale);
        if (inputCalendar.isRenderAsPopup()) {
            this.renderPopup(facesContext, inputCalendar, textValue, timeKeeper, symbols);
        } else {
            this.renderInline(facesContext, inputCalendar, timeKeeper, symbols);
        }
        component.getChildren().removeAll(component.getChildren());
    }

    private void renderPopup(FacesContext facesContext, HtmlInputCalendar inputCalendar, String value, Calendar timeKeeper, java.text.DateFormatSymbols symbols) throws IOException {
        if (inputCalendar.isAddResources()) {
            HtmlCalendarRenderer.addScriptAndCSSResources(facesContext, (UIComponent)inputCalendar);
        }
        HtmlInputCalendar uiInput = inputCalendar;
        Converter converter = uiInput.getConverter();
        String dateFormat = null;
        if (converter != null && converter instanceof DateTimeConverter) {
            dateFormat = ((DateTimeConverter)converter).getPattern();
        }
        if (dateFormat == null) {
            dateFormat = CalendarDateTimeConverter.createJSPopupFormat(facesContext, inputCalendar.getPopupDateFormat());
        }
        Application application = facesContext.getApplication();
        HtmlInputTextHelp inputText = this.getOrCreateInputTextChild(inputCalendar, application);
        RendererUtils.copyHtmlInputTextAttributes(inputCalendar, inputText);
        inputText.setConverter(null);
        inputText.setTransient(true);
        inputText.setHelpText(inputCalendar.getHelpText());
        inputText.setSelectText(true);
        inputText.setValue(value);
        inputText.setDisabled(inputCalendar.isDisabled());
        inputText.setReadonly(inputCalendar.isReadonly());
        inputText.setEnabledOnUserRole(inputCalendar.getEnabledOnUserRole());
        inputText.setVisibleOnUserRole(inputCalendar.getVisibleOnUserRole());
        inputCalendar.setId(inputCalendar.getId() + "tempId");
        inputCalendar.getChildren().add(inputText);
        RendererUtils.renderChild(facesContext, (UIComponent)inputText);
        inputCalendar.getChildren().remove(inputText);
        inputCalendar.setId(inputText.getId());
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", (UIComponent)inputCalendar);
        writer.writeAttribute("id", (Object)(inputCalendar.getClientId(facesContext) + "Span"), "id");
        writer.endElement("span");
        if (!HtmlCalendarRenderer.isDisabled(facesContext, (UIComponent)inputCalendar) && !inputCalendar.isReadonly()) {
            writer.startElement("script", (UIComponent)inputCalendar);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            String calendarVar = JavascriptUtils.getValidJavascriptName(inputCalendar.getClientId(facesContext) + "CalendarVar", false);
            writer.writeText((Object)(calendarVar + "=new org_apache_myfaces_PopupCalendar();\n"), null);
            writer.writeText((Object)(HtmlCalendarRenderer.getLocalizedLanguageScript(facesContext, symbols, timeKeeper.getFirstDayOfWeek(), (UIComponent)inputCalendar, calendarVar) + "\n"), null);
            StringBuffer script = new StringBuffer();
            HtmlCalendarRenderer.setStringVariable(script, calendarVar + ".initData.selectMode", inputCalendar.getPopupSelectMode());
            writer.writeText((Object)script.toString(), null);
            writer.writeText((Object)(calendarVar + ".init(document.getElementById('" + inputCalendar.getClientId(facesContext) + "Span" + "'));\n"), null);
            writer.endElement("script");
            if (!inputCalendar.isDisplayValueOnly()) {
                HtmlCalendarRenderer.getScriptBtn(writer, facesContext, (UIComponent)inputCalendar, dateFormat, inputCalendar.getPopupButtonString(), new FunctionCallProvider(){

                    public String getFunctionCall(FacesContext facesContext, UIComponent uiComponent, String dateFormat) {
                        String clientId = uiComponent.getClientId(facesContext);
                        String clientVar = JavascriptUtils.getValidJavascriptName(clientId + "CalendarVar", true);
                        return clientVar + "._popUpCalendar(this,document.getElementById('" + clientId + "'),'" + dateFormat + "')";
                    }
                });
            }
        }
    }

    private void renderInline(FacesContext facesContext, HtmlInputCalendar inputCalendar, Calendar timeKeeper, java.text.DateFormatSymbols symbols) throws IOException {
        String[] weekdays = HtmlCalendarRenderer.mapShortWeekdays(symbols);
        String[] months = HtmlCalendarRenderer.mapMonths(symbols);
        int lastDayInMonth = timeKeeper.getActualMaximum(5);
        int currentDay = timeKeeper.get(5);
        if (currentDay > lastDayInMonth) {
            currentDay = lastDayInMonth;
        }
        timeKeeper.set(5, 1);
        int weekDayOfFirstDayOfMonth = this.mapCalendarDayToCommonDay(timeKeeper.get(7));
        int weekStartsAtDayIndex = this.mapCalendarDayToCommonDay(timeKeeper.getFirstDayOfWeek());
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", (UIComponent)inputCalendar);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)inputCalendar, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)inputCalendar, HTML.EVENT_HANDLER_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)inputCalendar, HTML.COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE);
        writer.flush();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)inputCalendar);
        if (inputCalendar.getMonthYearRowClass() != null) {
            writer.writeAttribute("class", (Object)inputCalendar.getMonthYearRowClass(), null);
        }
        this.writeMonthYearHeader(facesContext, writer, (UIInput)inputCalendar, timeKeeper, currentDay, weekdays, months);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)inputCalendar);
        if (inputCalendar.getWeekRowClass() != null) {
            writer.writeAttribute("class", (Object)inputCalendar.getWeekRowClass(), null);
        }
        this.writeWeekDayNameHeader(weekStartsAtDayIndex, weekdays, facesContext, writer, (UIInput)inputCalendar);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        this.writeDays(facesContext, writer, inputCalendar, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, weekdays);
        writer.endElement("table");
    }

    private HtmlInputTextHelp getOrCreateInputTextChild(HtmlInputCalendar inputCalendar, Application application) {
        HtmlInputTextHelp inputText = null;
        List li = inputCalendar.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent uiComponent = (UIComponent)li.get(i);
            if (!(uiComponent instanceof HtmlInputTextHelp)) continue;
            inputText = (HtmlInputTextHelp)uiComponent;
            break;
        }
        if (inputText == null) {
            inputText = (HtmlInputTextHelp)application.createComponent("org.apache.myfaces.HtmlInputTextHelp");
        }
        return inputText;
    }

    public static void addScriptAndCSSResources(FacesContext facesContext, UIComponent component) {
        if (facesContext.getExternalContext().getRequestMap().containsKey(JAVASCRIPT_ENCODED)) {
            return;
        }
        AddResource addresource = AddResourceFactory.getInstance(facesContext);
        String styleLocation = HtmlRendererUtils.getStyleLocation(component);
        if (styleLocation == null) {
            addresource.addStyleSheet(facesContext, AddResource.HEADER_BEGIN, HtmlCalendarRenderer.class, "WH/theme.css");
            addresource.addStyleSheet(facesContext, AddResource.HEADER_BEGIN, HtmlCalendarRenderer.class, "DB/theme.css");
        } else if (!RESOURCE_NONE.equals(styleLocation)) {
            addresource.addStyleSheet(facesContext, AddResource.HEADER_BEGIN, styleLocation + "/theme.css");
        }
        String javascriptLocation = HtmlRendererUtils.getJavascriptLocation(component);
        if (javascriptLocation == null) {
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, PrototypeResourceLoader.class, "prototype.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, HtmlCalendarRenderer.class, "date.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, HtmlCalendarRenderer.class, "popcalendar.js");
        } else if (!RESOURCE_NONE.equals(javascriptLocation)) {
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, javascriptLocation + "/prototype.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, javascriptLocation + "/date.js");
            addresource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, javascriptLocation + "/popcalendar.js");
        }
        facesContext.getExternalContext().getRequestMap().put(JAVASCRIPT_ENCODED, Boolean.TRUE);
    }

    public static String getLocalizedLanguageScript(FacesContext facesContext, java.text.DateFormatSymbols symbols, int firstDayOfWeek, UIComponent uiComponent, String popupCalendarVariable) {
        String[] weekDays;
        int realFirstDayOfWeek = firstDayOfWeek - 1;
        if (realFirstDayOfWeek == 0) {
            weekDays = HtmlCalendarRenderer.mapShortWeekdaysStartingWithSunday(symbols);
        } else if (realFirstDayOfWeek == 1) {
            weekDays = HtmlCalendarRenderer.mapShortWeekdays(symbols);
        } else if (realFirstDayOfWeek == 6) {
            weekDays = HtmlCalendarRenderer.mapShortWeekdaysStartingWithSaturday(symbols);
        } else {
            throw new IllegalStateException("Week may only start with saturday, sunday or monday.");
        }
        StringBuffer script = new StringBuffer();
        AddResource ar = AddResourceFactory.getInstance(facesContext);
        if (uiComponent instanceof HtmlInputCalendar) {
            HtmlInputCalendar calendar = (HtmlInputCalendar)uiComponent;
            String popupTheme = calendar.getPopupTheme();
            if (popupTheme == null) {
                popupTheme = "DB";
            }
            HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.themePrefix", "jscalendar-" + popupTheme);
            String imageLocation = HtmlRendererUtils.getImageLocation(uiComponent);
            if (imageLocation == null) {
                String uri = ar.getResourceUri(facesContext, HtmlCalendarRenderer.class, popupTheme + "/");
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.imgDir", JavascriptUtils.encodeString(uri));
            } else {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.imgDir", JavascriptUtils.encodeString(AddResourceFactory.getInstance(facesContext).getResourceUri(facesContext, imageLocation + "/")));
            }
        } else {
            String imageLocation = HtmlRendererUtils.getImageLocation(uiComponent);
            if (imageLocation == null) {
                String uri = ar.getResourceUri(facesContext, HtmlCalendarRenderer.class, "images/");
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.imgDir", JavascriptUtils.encodeString(uri));
            } else {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.imgDir", JavascriptUtils.encodeString(AddResourceFactory.getInstance(facesContext).getResourceUri(facesContext, imageLocation + "/")));
            }
        }
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".initData.monthName", HtmlCalendarRenderer.mapMonths(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".initData.dayName", weekDays);
        HtmlCalendarRenderer.setIntegerVariable(script, popupCalendarVariable + ".initData.startAt", realFirstDayOfWeek);
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.weekdays", HtmlCalendarRenderer.mapWeekdaysStartingWithSunday(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.shortWeekdays", HtmlCalendarRenderer.mapShortWeekdaysStartingWithSunday(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.shortMonths", HtmlCalendarRenderer.mapShortMonths(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.months", HtmlCalendarRenderer.mapMonths(symbols));
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.eras", symbols.getEras());
        HtmlCalendarRenderer.defineStringArray(script, popupCalendarVariable + ".dateFormatSymbols.ampms", symbols.getAmPmStrings());
        if (uiComponent instanceof HtmlInputCalendar) {
            HtmlInputCalendar inputCalendar = (HtmlInputCalendar)uiComponent;
            if (inputCalendar.getPopupGotoString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.gotoString", inputCalendar.getPopupGotoString());
            }
            if (inputCalendar.getPopupTodayString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.todayString", inputCalendar.getPopupTodayString());
            }
            if (inputCalendar.getPopupTodayDateFormat() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.todayDateFormat", inputCalendar.getPopupTodayDateFormat());
            } else if (inputCalendar.getPopupDateFormat() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.todayDateFormat", inputCalendar.getPopupDateFormat());
            }
            if (inputCalendar.getPopupWeekString() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.weekString", inputCalendar.getPopupWeekString());
            }
            if (inputCalendar.getPopupScrollLeftMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.scrollLeftMessage", inputCalendar.getPopupScrollLeftMessage());
            }
            if (inputCalendar.getPopupScrollRightMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.scrollRightMessage", inputCalendar.getPopupScrollRightMessage());
            }
            if (inputCalendar.getPopupSelectMonthMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.selectMonthMessage", inputCalendar.getPopupSelectMonthMessage());
            }
            if (inputCalendar.getPopupSelectYearMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.selectYearMessage", inputCalendar.getPopupSelectYearMessage());
            }
            if (inputCalendar.getPopupSelectDateMessage() != null) {
                HtmlCalendarRenderer.setStringVariable(script, popupCalendarVariable + ".initData.selectDateMessage", inputCalendar.getPopupSelectDateMessage());
            }
            HtmlCalendarRenderer.setBooleanVariable(script, popupCalendarVariable + ".initData.popupLeft", inputCalendar.isPopupLeft());
        }
        return script.toString();
    }

    private static void setBooleanVariable(StringBuffer script, String name, boolean value) {
        script.append(name);
        script.append(" = ");
        script.append(value);
        script.append(";\n");
    }

    private static void setIntegerVariable(StringBuffer script, String name, int value) {
        script.append(name);
        script.append(" = ");
        script.append(value);
        script.append(";\n");
    }

    private static void setStringVariable(StringBuffer script, String name, String value) {
        script.append(name);
        script.append(" = \"");
        script.append(StringEscapeUtils.escapeJavaScript((String)value));
        script.append("\";\n");
    }

    private static void defineStringArray(StringBuffer script, String arrayName, String[] array) {
        script.append(arrayName);
        script.append(" = new Array(");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                script.append(",");
            }
            script.append("\"");
            script.append(StringEscapeUtils.escapeJavaScript((String)array[i]));
            script.append("\"");
        }
        script.append(");\n");
    }

    public static void getScriptBtn(ResponseWriter writer, FacesContext facesContext, UIComponent uiComponent, String dateFormat, String popupButtonString, FunctionCallProvider prov) throws IOException {
        boolean renderButtonAsImage = false;
        String popupButtonStyle = null;
        String popupButtonStyleClass = null;
        if (uiComponent instanceof HtmlInputCalendar) {
            HtmlInputCalendar calendar = (HtmlInputCalendar)uiComponent;
            renderButtonAsImage = calendar.isRenderPopupButtonAsImage();
            popupButtonStyle = calendar.getPopupButtonStyle();
            popupButtonStyleClass = calendar.getPopupButtonStyleClass();
        }
        if (!renderButtonAsImage) {
            writer.startElement("input", uiComponent);
            writer.writeAttribute("type", (Object)"button", null);
            writer.writeAttribute("onclick", (Object)prov.getFunctionCall(facesContext, uiComponent, dateFormat), null);
            if (popupButtonString == null) {
                popupButtonString = "...";
            }
            writer.writeAttribute("value", (Object)StringEscapeUtils.escapeJavaScript((String)popupButtonString), null);
            if (popupButtonStyle != null) {
                writer.writeAttribute("style", (Object)popupButtonStyle, null);
            }
            if (popupButtonStyleClass != null) {
                writer.writeAttribute("class", (Object)popupButtonStyleClass, null);
            }
            writer.endElement("input");
        } else {
            writer.startElement("img", uiComponent);
            AddResource addResource = AddResourceFactory.getInstance(facesContext);
            String imgUrl = (String)uiComponent.getAttributes().get("popupButtonImageUrl");
            if (imgUrl != null) {
                writer.writeAttribute("src", (Object)addResource.getResourceUri(facesContext, imgUrl), null);
            } else {
                writer.writeAttribute("src", (Object)addResource.getResourceUri(facesContext, HtmlCalendarRenderer.class, "images/calendar.gif"), null);
            }
            if (popupButtonStyle != null) {
                writer.writeAttribute("style", (Object)popupButtonStyle, null);
            } else {
                writer.writeAttribute("style", (Object)"vertical-align:bottom;", null);
            }
            if (popupButtonStyleClass != null) {
                writer.writeAttribute("class", (Object)popupButtonStyleClass, null);
            }
            writer.writeAttribute("onclick", (Object)prov.getFunctionCall(facesContext, uiComponent, dateFormat), null);
            writer.endElement("img");
        }
    }

    private void writeMonthYearHeader(FacesContext facesContext, ResponseWriter writer, UIInput inputComponent, Calendar timeKeeper, int currentDay, String[] weekdays, String[] months) throws IOException {
        Calendar cal = this.shiftMonth(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(facesContext, writer, inputComponent, "<", cal.getTime(), null);
        writer.startElement("td", (UIComponent)inputComponent);
        writer.writeAttribute("colspan", (Object)new Integer(weekdays.length - 2), null);
        writer.writeText((Object)(months[timeKeeper.get(2)] + " " + timeKeeper.get(1)), null);
        writer.endElement("td");
        cal = this.shiftMonth(facesContext, timeKeeper, currentDay, 1);
        this.writeCell(facesContext, writer, inputComponent, ">", cal.getTime(), null);
    }

    private Calendar shiftMonth(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(5, 1);
        cal.set(2, cal.get(2) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar copyCalendar(FacesContext facesContext, Calendar timeKeeper) {
        Calendar cal = Calendar.getInstance(facesContext.getViewRoot().getLocale());
        cal.setTime(timeKeeper.getTime());
        return cal;
    }

    private void writeWeekDayNameHeader(int weekStartsAtDayIndex, String[] weekdays, FacesContext facesContext, ResponseWriter writer, UIInput inputComponent) throws IOException {
        int i;
        for (i = weekStartsAtDayIndex; i < weekdays.length; ++i) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i], null, null);
        }
        for (i = 0; i < weekStartsAtDayIndex; ++i) {
            this.writeCell(facesContext, writer, inputComponent, weekdays[i], null, null);
        }
    }

    private void writeDays(FacesContext facesContext, ResponseWriter writer, HtmlInputCalendar inputComponent, Calendar timeKeeper, int currentDay, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth, int lastDayInMonth, String[] weekdays) throws IOException {
        int i;
        int space;
        int n = space = weekStartsAtDayIndex < weekDayOfFirstDayOfMonth ? weekDayOfFirstDayOfMonth - weekStartsAtDayIndex : weekdays.length - weekStartsAtDayIndex + weekDayOfFirstDayOfMonth;
        if (space == weekdays.length) {
            space = 0;
        }
        int columnIndexCounter = 0;
        for (i = 0; i < space; ++i) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", (UIComponent)inputComponent);
            }
            this.writeCell(facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass());
            ++columnIndexCounter;
        }
        for (i = 0; i < lastDayInMonth; ++i) {
            if (columnIndexCounter == 0) {
                writer.startElement("tr", (UIComponent)inputComponent);
            }
            Calendar cal = this.copyCalendar(facesContext, timeKeeper);
            cal.set(5, i + 1);
            String cellStyle = inputComponent.getDayCellClass();
            if (currentDay - 1 == i) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            this.writeCell(facesContext, writer, (UIInput)inputComponent, String.valueOf(i + 1), cal.getTime(), cellStyle);
            if (++columnIndexCounter != weekdays.length) continue;
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            columnIndexCounter = 0;
        }
        if (columnIndexCounter != 0) {
            for (i = columnIndexCounter; i < weekdays.length; ++i) {
                this.writeCell(facesContext, writer, (UIInput)inputComponent, "", null, inputComponent.getDayCellClass());
            }
            writer.endElement("tr");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        }
    }

    private void writeCell(FacesContext facesContext, ResponseWriter writer, UIInput component, String content, Date valueForLink, String styleClass) throws IOException {
        writer.startElement("td", (UIComponent)component);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (valueForLink == null) {
            writer.writeText((Object)content, "value");
        } else {
            this.writeLink(content, component, facesContext, valueForLink);
        }
        writer.endElement("td");
    }

    private void writeLink(String content, UIInput component, FacesContext facesContext, Date valueForLink) throws IOException {
        Converter converter = this.getConverter(component);
        Application application = facesContext.getApplication();
        HtmlOutputText text = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
        text.setValue((Object)content);
        text.setId(component.getId() + "_" + valueForLink.getTime() + "_text");
        text.setTransient(true);
        HtmlInputCalendar calendar = (HtmlInputCalendar)component;
        if (HtmlCalendarRenderer.isDisabled(facesContext, (UIComponent)component) || calendar.isReadonly()) {
            component.getChildren().add(text);
            RendererUtils.renderChild(facesContext, (UIComponent)text);
            return;
        }
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(component.getId() + "_" + valueForLink.getTime() + "_link");
        link.setTransient(true);
        link.setImmediate(component.isImmediate());
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_param");
        parameter.setTransient(true);
        parameter.setName(component.getClientId(facesContext));
        parameter.setValue((Object)converter.getAsString(facesContext, (UIComponent)component, (Object)valueForLink));
        RendererUtils.addOrReplaceChild(component, (UIComponent)link);
        link.getChildren().add(parameter);
        link.getChildren().add(text);
        RendererUtils.renderChild(facesContext, (UIComponent)link);
    }

    private Converter getConverter(UIInput component) {
        Converter converter = component.getConverter();
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
        }
        return converter;
    }

    private DateBusinessConverter getDateBusinessConverter(AbstractHtmlInputCalendar component) {
        DateBusinessConverter dateBusinessConverter = component.getDateBusinessConverter();
        if (dateBusinessConverter == null) {
            dateBusinessConverter = new DefaultDateBusinessConverter();
        }
        return dateBusinessConverter;
    }

    private int mapCalendarDayToCommonDay(int day) {
        switch (day) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private static String[] mapShortWeekdays(java.text.DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    private static String[] mapShortWeekdaysStartingWithSunday(java.text.DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }

    private static String[] mapShortWeekdaysStartingWithSaturday(java.text.DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[7];
        weekdays[1] = localeWeekdays[1];
        weekdays[2] = localeWeekdays[2];
        weekdays[3] = localeWeekdays[3];
        weekdays[4] = localeWeekdays[4];
        weekdays[5] = localeWeekdays[5];
        weekdays[6] = localeWeekdays[6];
        return weekdays;
    }

    private static String[] mapWeekdaysStartingWithSunday(java.text.DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }

    public static String[] mapMonths(java.text.DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public static String[] mapShortMonths(java.text.DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getShortMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        RendererUtils.checkParamValidity(facesContext, component, HtmlInputCalendar.class);
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            String value = (String)paramMap.get(clientId);
            ((EditableValueHolder)component).setSubmittedValue((Object)value);
        } else {
            this.log.warn((Object)("There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission. Component : " + RendererUtils.getPathToComponent(component)));
        }
    }

    protected static boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        if (uiComponent instanceof HtmlInputCalendar) {
            return ((HtmlInputCalendar)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, HtmlInputCalendar.class);
        AbstractHtmlInputCalendar uiInput = (AbstractHtmlInputCalendar)uiComponent;
        Converter converter = uiInput.getConverter();
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String expected");
        }
        if (submittedValue != null && submittedValue.equals(HtmlCalendarRenderer.getHelperString(uiComponent))) {
            return null;
        }
        if (converter == null) {
            converter = new CalendarDateTimeConverter();
            Date date = (Date)converter.getAsObject(facesContext, uiComponent, (String)submittedValue);
            return this.getDateBusinessConverter(uiInput).getBusinessValue(facesContext, uiComponent, date);
        }
        return converter.getAsObject(facesContext, uiComponent, (String)submittedValue);
    }

    private static String getHelperString(UIComponent uiComponent) {
        return uiComponent instanceof HtmlInputCalendar ? ((HtmlInputCalendar)uiComponent).getHelpText() : null;
    }

    public static class CalendarDateTimeConverter
    implements DateConverter {
        private static final String CONVERSION_MESSAGE_ID = "org.apache.myfaces.calendar.CONVERSION";

        public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String s) {
            if (s == null || s.trim().length() == 0 || s.equals(HtmlCalendarRenderer.getHelperString(uiComponent))) {
                return null;
            }
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                Calendar timeKeeper;
                int firstDayOfWeek;
                Locale locale;
                DateFormatSymbols symbols;
                HtmlInputCalendar calendar = (HtmlInputCalendar)uiComponent;
                String popupDateFormat = calendar.getPopupDateFormat();
                String formatStr = CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat);
                SimpleDateFormatter dateFormat = new SimpleDateFormatter(formatStr, symbols = new DateFormatSymbols(locale = facesContext.getViewRoot().getLocale()), firstDayOfWeek = (timeKeeper = Calendar.getInstance(locale)).getFirstDayOfWeek() - 1);
                Date date = dateFormat.parse(s);
                if (date != null) {
                    return date;
                }
                FacesMessage msg = MessageUtils.getMessage("org.apache.myfaces.tomahawk.Messages", FacesMessage.SEVERITY_ERROR, CONVERSION_MESSAGE_ID, new Object[]{uiComponent.getId(), s}, facesContext);
                throw new ConverterException(msg);
            }
            SimpleDateFormat dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            dateFormat.setLenient(false);
            try {
                Date date = dateFormat.parse(s);
                return date;
            }
            catch (ParseException e) {
                FacesMessage msg = MessageUtils.getMessage("org.apache.myfaces.tomahawk.Messages", FacesMessage.SEVERITY_ERROR, CONVERSION_MESSAGE_ID, new Object[]{uiComponent.getId(), s}, facesContext);
                throw new ConverterException(msg, (Throwable)e);
            }
        }

        public Date getAsDate(FacesContext facesContext, UIComponent uiComponent) {
            return RendererUtils.getDateValue(uiComponent);
        }

        public static String createJSPopupFormat(FacesContext facesContext, String popupDateFormat) {
            if (popupDateFormat == null) {
                SimpleDateFormat defaultDateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
                popupDateFormat = defaultDateFormat.toPattern();
            }
            return popupDateFormat;
        }

        public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object o) {
            Date date = (Date)o;
            if (date == null) {
                return HtmlCalendarRenderer.getHelperString(uiComponent);
            }
            if (uiComponent instanceof HtmlInputCalendar && ((HtmlInputCalendar)uiComponent).isRenderAsPopup()) {
                HtmlInputCalendar calendar = (HtmlInputCalendar)uiComponent;
                String popupDateFormat = calendar.getPopupDateFormat();
                String formatStr = CalendarDateTimeConverter.createJSPopupFormat(facesContext, popupDateFormat);
                Locale locale = facesContext.getViewRoot().getLocale();
                Calendar timeKeeper = Calendar.getInstance(locale);
                int firstDayOfWeek = timeKeeper.getFirstDayOfWeek() - 1;
                DateFormatSymbols symbols = new DateFormatSymbols(locale);
                SimpleDateFormatter dateFormat = new SimpleDateFormatter(formatStr, symbols, firstDayOfWeek);
                return dateFormat.format(date);
            }
            SimpleDateFormat dateFormat = CalendarDateTimeConverter.createStandardDateFormat(facesContext);
            dateFormat.setLenient(false);
            return dateFormat.format(date);
        }

        private static SimpleDateFormat createStandardDateFormat(FacesContext facesContext) {
            DateFormat dateFormat = DateFormat.getDateInstance(3, facesContext.getViewRoot().getLocale());
            if (dateFormat instanceof SimpleDateFormat) {
                return (SimpleDateFormat)dateFormat;
            }
            return new SimpleDateFormat("dd.MM.yyyy", facesContext.getViewRoot().getLocale());
        }
    }

    public static interface DateConverter
    extends Converter {
        public Date getAsDate(FacesContext var1, UIComponent var2);
    }
}

