/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.Serializable;
import java.util.Iterator;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.model.ScheduleModel;
import org.apache.myfaces.custom.schedule.model.SimpleScheduleModel;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;

public class UISchedule
extends UIComponentBase
implements ValueHolder,
Serializable,
ActionSource {
    private static final long serialVersionUID = 3440822180568539483L;
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.Schedule";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Schedule";
    private MethodBinding actionBinding;
    private MethodBinding actionListenerBinding;
    private Converter converter;
    private Boolean immediate;
    private Boolean readonly;
    private ScheduleActionListener scheduleListener;
    private ScheduleEntry submittedEntry;
    private Object value;
    private Integer visibleEndHour;
    private Integer visibleStartHour;
    private Integer workingEndHour;
    private Integer workingStartHour;
    static /* synthetic */ Class class$javax$faces$event$ActionListener;

    public UISchedule() {
        this.setRendererType("org.apache.myfaces.Schedule");
        this.scheduleListener = new ScheduleActionListener();
        this.addActionListener(this.scheduleListener);
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext context = this.getFacesContext();
        MethodBinding actionListenerBinding = this.getActionListener();
        if (actionListenerBinding != null) {
            actionListenerBinding.invoke(context, new Object[]{event});
        }
    }

    public ScheduleEntry findEntry(String id) {
        if (id == null) {
            return null;
        }
        Iterator dayIterator = this.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            Iterator iter = day.iterator();
            while (iter.hasNext()) {
                ScheduleEntry entry = (ScheduleEntry)iter.next();
                if (!id.equals(entry.getId())) continue;
                return entry;
            }
        }
        return null;
    }

    public MethodBinding getAction() {
        return this.actionBinding;
    }

    public MethodBinding getActionListener() {
        return this.actionListenerBinding;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(class$javax$faces$event$ActionListener == null ? (class$javax$faces$event$ActionListener = UISchedule.class$("javax.faces.event.ActionListener")) : class$javax$faces$event$ActionListener);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Object getLocalValue() {
        return this.value;
    }

    public ScheduleModel getModel() {
        if (this.getValue() instanceof ScheduleModel) {
            return (ScheduleModel)this.getValue();
        }
        return new SimpleScheduleModel();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public ScheduleEntry getSubmittedEntry() {
        return this.submittedEntry;
    }

    public Object getValue() {
        return ScheduleUtil.getObjectProperty((UIComponent)this, this.value, "value", this.value);
    }

    public int getVisibleEndHour() {
        return ScheduleUtil.getIntegerProperty((UIComponent)this, this.visibleEndHour, "visibleEndHour", 22);
    }

    public int getVisibleStartHour() {
        return ScheduleUtil.getIntegerProperty((UIComponent)this, this.visibleStartHour, "visibleStartHour", 8);
    }

    public int getWorkingEndHour() {
        return ScheduleUtil.getIntegerProperty((UIComponent)this, this.workingEndHour, "workingEndHour", 17);
    }

    public int getWorkingStartHour() {
        return ScheduleUtil.getIntegerProperty((UIComponent)this, this.workingStartHour, "workingStartHour", 9);
    }

    public boolean isImmediate() {
        return ScheduleUtil.getBooleanProperty((UIComponent)this, this.immediate, "immediate", false);
    }

    public boolean isReadonly() {
        return ScheduleUtil.getBooleanProperty((UIComponent)this, this.readonly, "readonly", false);
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void restoreState(FacesContext context, Object state) {
        Boolean readonlyState;
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.visibleStartHour = (Integer)values[1];
        this.visibleEndHour = (Integer)values[2];
        this.workingStartHour = (Integer)values[3];
        this.workingEndHour = (Integer)values[4];
        Boolean immediateState = (Boolean)values[5];
        if (immediateState != null) {
            this.setImmediate(immediateState);
        }
        if ((readonlyState = (Boolean)values[6]) != null) {
            this.setReadonly(readonlyState);
        }
        this.value = values[7];
        this.actionListenerBinding = (MethodBinding)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[8]);
        this.actionBinding = (MethodBinding)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[9]);
        this.addActionListener(this.scheduleListener);
    }

    public Object saveState(FacesContext context) {
        this.removeActionListener(this.scheduleListener);
        Object[] values = new Object[]{super.saveState(context), this.visibleStartHour, this.visibleEndHour, this.workingStartHour, this.workingEndHour, this.immediate, this.readonly, this.value, UISchedule.saveAttachedState((FacesContext)context, (Object)this.actionListenerBinding), UISchedule.saveAttachedState((FacesContext)context, (Object)this.actionBinding)};
        return values;
    }

    public void setAction(MethodBinding action) {
        this.actionBinding = action;
    }

    public void setActionListener(MethodBinding listener) {
        this.actionListenerBinding = listener;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public void setModel(ScheduleModel model) {
        this.setValue(model);
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setSubmittedEntry(ScheduleEntry submittedEntry) {
        this.submittedEntry = submittedEntry;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setVisibleEndHour(int visibleEndHour) {
        this.visibleEndHour = new Integer(visibleEndHour);
    }

    public void setVisibleStartHour(int visibleStartHour) {
        this.visibleStartHour = new Integer(visibleStartHour);
    }

    public void setWorkingEndHour(int workingEndHour) {
        this.workingEndHour = new Integer(workingEndHour);
    }

    public void setWorkingStartHour(int workingStartHour) {
        this.workingStartHour = new Integer(workingStartHour);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ScheduleActionListener
    implements ActionListener {
        private ScheduleActionListener() {
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            UISchedule schedule = (UISchedule)event.getComponent();
            ScheduleEntry entry = schedule.getSubmittedEntry();
            schedule.getModel().setSelectedEntry(entry);
            schedule.setSubmittedEntry(null);
            if (schedule.getAction() != null) {
                UISchedule.this.getFacesContext().getApplication().getActionListener().processAction(event);
            }
        }
    }
}

