/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.BaseSortableModel;
import org.apache.myfaces.component.html.ext.SortCriterion;

public final class SortableModel
extends BaseSortableModel {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$component$html$ext$SortableModel == null ? (class$org$apache$myfaces$component$html$ext$SortableModel = SortableModel.class$("org.apache.myfaces.component.html.ext.SortableModel")) : class$org$apache$myfaces$component$html$ext$SortableModel));
    private SortCriterion _sortCriterion = null;
    static /* synthetic */ Class class$org$apache$myfaces$component$html$ext$SortableModel;

    public SortableModel(Object model) {
        super(model);
    }

    public SortableModel() {
    }

    public void setWrappedData(Object data) {
        super.setWrappedData(data);
        this.setSortCriteria(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSortable(String property) {
        int oldIndex = this._model.getRowIndex();
        try {
            this._model.setRowIndex(0);
            if (!this._model.isRowAvailable()) {
                boolean bl = false;
                return bl;
            }
            Object propertyValue = PropertyUtils.getProperty((Object)this._model.getRowData(), (String)property);
            boolean bl = propertyValue instanceof Comparable || propertyValue == null;
            return bl;
        }
        finally {
            this._model.setRowIndex(oldIndex);
        }
    }

    public List getSortCriteria() {
        return this._sortCriterion == null ? Collections.EMPTY_LIST : Collections.singletonList(this._sortCriterion);
    }

    public void setSortCriteria(List criteria) {
        if (criteria == null || criteria.isEmpty()) {
            this._sortCriterion = null;
            this.setComparator(null);
        } else {
            SortCriterion sc = (SortCriterion)criteria.get(0);
            if (this._sortCriterion == null || !this._sortCriterion.equals(sc)) {
                this._sortCriterion = sc;
                Comparator comp = new Comp(this._sortCriterion.getProperty());
                if (!this._sortCriterion.isAscending()) {
                    comp = new Inverter(comp);
                }
                this.setComparator(comp);
            }
        }
    }

    public String toString() {
        return "SortableModel[" + this._model + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Inverter
    implements Comparator {
        private final Comparator _comp;

        public Inverter(Comparator comp) {
            this._comp = comp;
        }

        public int compare(Object o1, Object o2) {
            return this._comp.compare(o2, o1);
        }
    }

    private final class Comp
    implements Comparator {
        private final String _prop;
        private Collator _collator;
        private Map _collationKeys;

        public Comp(String property) {
            this._prop = property;
            this._collator = Collator.getInstance(FacesContext.getCurrentInstance().getViewRoot().getLocale());
            this._collationKeys = new HashMap();
        }

        public int compare(Object o1, Object o2) {
            Object value1 = null;
            Object value2 = null;
            try {
                value1 = PropertyUtils.getProperty((Object)o1, (String)this._prop);
                value2 = PropertyUtils.getProperty((Object)o2, (String)this._prop);
            }
            catch (Exception exc) {
                log.error((Object)exc);
            }
            if (value1 == null) {
                return value2 == null ? 0 : -1;
            }
            if (value2 == null) {
                return 1;
            }
            if (value1 instanceof String) {
                CollationKey collationKey1 = this.getCollationKey((String)value1);
                CollationKey collationKey2 = this.getCollationKey((String)value2);
                return collationKey1.compareTo(collationKey2);
            }
            if (value1 instanceof Comparable) {
                return ((Comparable)value1).compareTo(value2);
            }
            return value1.toString().compareTo(value2.toString());
        }

        private CollationKey getCollationKey(String propertyValue) {
            CollationKey key = (CollationKey)this._collationKeys.get(propertyValue);
            if (key == null) {
                key = this._collator.getCollationKey(propertyValue);
                this._collationKeys.put(propertyValue, key);
            }
            return key;
        }
    }
}

