/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import javax.faces.component.ActionSource;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.custom.schedule.ScheduleMouseEvent;
import org.apache.myfaces.custom.schedule.UIScheduleBase;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;

public class UISchedule
extends UIScheduleBase
implements Serializable,
ActionSource {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.UISchedule";
    private static final long serialVersionUID = -8333458172939036755L;
    private MethodBinding _action;
    private MethodBinding _actionListener;
    private ScheduleActionListener _scheduleListener = new ScheduleActionListener();
    private ScheduleEntry _submittedEntry;
    private Date _lastClickedDateAndTime = null;
    private MethodBinding _mouseListener = null;
    static /* synthetic */ Class class$javax$faces$event$ActionListener;

    public UISchedule() {
        this.addActionListener(this._scheduleListener);
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        FacesContext context = this.getFacesContext();
        if (event instanceof ScheduleMouseEvent) {
            ScheduleMouseEvent mouseEvent = (ScheduleMouseEvent)event;
            MethodBinding mouseListener = this.getMouseListener();
            if (mouseListener != null) {
                mouseListener.invoke(context, new Object[]{mouseEvent});
            }
        }
        super.broadcast(event);
        MethodBinding actionListener = this.getActionListener();
        if (actionListener != null) {
            actionListener.invoke(context, new Object[]{event});
        }
    }

    protected ScheduleEntry findEntry(String id) {
        if (id == null) {
            return null;
        }
        Iterator dayIterator = this.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            Iterator iter = day.iterator();
            while (iter.hasNext()) {
                ScheduleEntry entry = (ScheduleEntry)iter.next();
                if (!id.equals(entry.getId())) continue;
                return entry;
            }
        }
        return null;
    }

    public MethodBinding getAction() {
        return this._action;
    }

    public MethodBinding getActionListener() {
        return this._actionListener;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(class$javax$faces$event$ActionListener == null ? (class$javax$faces$event$ActionListener = UISchedule.class$("javax.faces.event.ActionListener")) : class$javax$faces$event$ActionListener);
    }

    public Date getLastClickedDateAndTime() {
        return this._lastClickedDateAndTime;
    }

    public MethodBinding getMouseListener() {
        return this._mouseListener;
    }

    public ScheduleEntry getSubmittedEntry() {
        return this._submittedEntry;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent || event instanceof ScheduleMouseEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    protected void resetMouseEvents() {
        this._lastClickedDateAndTime = null;
    }

    public void restoreState(FacesContext context, Object state) {
        this.removeActionListener(this._scheduleListener);
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._lastClickedDateAndTime = (Date)values[1];
        this._actionListener = (MethodBinding)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this._action = (MethodBinding)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this._mouseListener = (MethodBinding)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[4]);
        this.addActionListener(this._scheduleListener);
    }

    public Object saveState(FacesContext context) {
        this.removeActionListener(this._scheduleListener);
        Object[] values = new Object[]{super.saveState(context), this._lastClickedDateAndTime, UISchedule.saveAttachedState((FacesContext)context, (Object)this._actionListener), UISchedule.saveAttachedState((FacesContext)context, (Object)this._action), UISchedule.saveAttachedState((FacesContext)context, (Object)this._mouseListener)};
        return values;
    }

    public void setAction(MethodBinding action) {
        this._action = action;
    }

    public void setActionListener(MethodBinding actionListener) {
        this._actionListener = actionListener;
    }

    protected void setLastClickedDateAndTime(Date lastClickedDateAndTime) {
        this._lastClickedDateAndTime = lastClickedDateAndTime;
    }

    public void setMouseListener(MethodBinding listener) {
        this._mouseListener = listener;
    }

    protected void setSubmittedEntry(ScheduleEntry submittedEntry) {
        this._submittedEntry = submittedEntry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ScheduleActionListener
    implements ActionListener {
        private ScheduleActionListener() {
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            UISchedule schedule = (UISchedule)event.getComponent();
            ScheduleEntry entry = schedule.getSubmittedEntry();
            schedule.getModel().setSelectedEntry(entry);
            schedule.setSubmittedEntry(null);
            if (schedule.getAction() != null) {
                UISchedule.this.getFacesContext().getApplication().getActionListener().processAction(event);
            }
        }
    }
}

