/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.faces.context.ExternalContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tomahawk.util.RequestType;

public final class ExternalContextUtils {
    private static final Log _LOG;
    private static final Class _PORTLET_ACTION_REQUEST_CLASS;
    private static final Class _PORTLET_RENDER_REQUEST_CLASS;
    private static final Class _PORTLET_RESOURCE_REQUEST_CLASS;
    private static final Class _PORTLET_CONTEXT_CLASS;
    private static final Class _PORTLET_CONFIG_CLASS;
    static /* synthetic */ Class class$org$apache$myfaces$tomahawk$util$ExternalContextUtils;

    private ExternalContextUtils() {
    }

    public static final int getContentLength(ExternalContext externalContext) {
        RequestType type = ExternalContextUtils.getRequestType(externalContext);
        if (type.isRequestFromClient()) {
            try {
                Object request = externalContext.getRequest();
                Method contentLenMethod = request.getClass().getMethod("getContentLength", new Class[0]);
                return (Integer)contentLenMethod.invoke(request, new Object[0]);
            }
            catch (Exception e) {
                _LOG.error((Object)"Unsupported request type.", (Throwable)e);
            }
        }
        return -1;
    }

    public static final InputStream getRequestInputStream(ExternalContext externalContext) throws IOException {
        RequestType type = ExternalContextUtils.getRequestType(externalContext);
        if (type.isRequestFromClient()) {
            try {
                Object request = externalContext.getRequest();
                Method method = request.getClass().getMethod(type.isPortlet() ? "getPortletInputStream" : "getInputStream", new Class[0]);
                return (InputStream)method.invoke(request, new Object[0]);
            }
            catch (Exception e) {
                _LOG.error((Object)"Unable to get the request input stream because of an error", (Throwable)e);
            }
        }
        return null;
    }

    public static final RequestType getRequestType(ExternalContext externalContext) {
        if (_PORTLET_CONTEXT_CLASS != null && _PORTLET_CONTEXT_CLASS.isInstance(externalContext.getContext())) {
            Object request = externalContext.getRequest();
            if (_PORTLET_RENDER_REQUEST_CLASS.isInstance(request)) {
                return RequestType.RENDER;
            }
            if (_PORTLET_RESOURCE_REQUEST_CLASS != null) {
                if (_PORTLET_ACTION_REQUEST_CLASS.isInstance(request)) {
                    return RequestType.ACTION;
                }
                if (_PORTLET_RESOURCE_REQUEST_CLASS.isInstance(request)) {
                    return RequestType.RESOURCE;
                }
                return RequestType.EVENT;
            }
            return RequestType.ACTION;
        }
        return RequestType.SERVLET;
    }

    public static final RequestType getRequestType(Object config, Object request) {
        if (_PORTLET_CONFIG_CLASS != null && _PORTLET_CONFIG_CLASS.isInstance(config)) {
            if (_PORTLET_RENDER_REQUEST_CLASS.isInstance(request)) {
                return RequestType.RENDER;
            }
            if (_PORTLET_RESOURCE_REQUEST_CLASS != null) {
                if (_PORTLET_ACTION_REQUEST_CLASS.isInstance(request)) {
                    return RequestType.ACTION;
                }
                if (_PORTLET_RESOURCE_REQUEST_CLASS.isInstance(request)) {
                    return RequestType.RESOURCE;
                }
                return RequestType.EVENT;
            }
            return RequestType.ACTION;
        }
        return RequestType.SERVLET;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class<?> resourceRequest;
        Class<?> renderRequest;
        Class<?> actionRequest;
        Class<?> config;
        Class<?> context;
        _LOG = LogFactory.getLog((Class)(class$org$apache$myfaces$tomahawk$util$ExternalContextUtils == null ? (class$org$apache$myfaces$tomahawk$util$ExternalContextUtils = ExternalContextUtils.class$("org.apache.myfaces.tomahawk.util.ExternalContextUtils")) : class$org$apache$myfaces$tomahawk$util$ExternalContextUtils));
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            context = loader.loadClass("javax.portlet.PortletContext");
            config = loader.loadClass("javax.portlet.PortletConfig");
            actionRequest = loader.loadClass("javax.portlet.ActionRequest");
            renderRequest = loader.loadClass("javax.portlet.RenderRequest");
            try {
                resourceRequest = loader.loadClass("javax.portlet.ResourceRequest");
            }
            catch (ClassNotFoundException e) {
                resourceRequest = null;
            }
        }
        catch (ClassNotFoundException e) {
            context = null;
            config = null;
            actionRequest = null;
            renderRequest = null;
            resourceRequest = null;
        }
        _PORTLET_CONTEXT_CLASS = context;
        _PORTLET_CONFIG_CLASS = config;
        _PORTLET_ACTION_REQUEST_CLASS = actionRequest;
        _PORTLET_RENDER_REQUEST_CLASS = renderRequest;
        _PORTLET_RESOURCE_REQUEST_CLASS = resourceRequest;
    }
}

