/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.custom.fileupload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;


/**
 * @author Sylvain Vieujot (latest modification by $Author: lu4242 $)
 * @version $Revision: 697281 $ $Date: 2008-09-19 18:33:41 -0500 (Fri, 19 Sep 2008) $
 */
public class UploadedFileDefaultFileImpl extends UploadedFileDefaultImplBase
{
  private static final long serialVersionUID = -6401426361519246443L;
  private transient DiskFileItem fileItem = null;
  private StorageStrategy storageStrategy;

    public UploadedFileDefaultFileImpl(final FileItem fileItem) throws IOException
    {
        super(fileItem.getName(), fileItem.getContentType());
        this.fileItem = (DiskFileItem) fileItem;
        storageStrategy = new DiskStorageStrategy() {

        public File getTempFile() {
          return UploadedFileDefaultFileImpl.this.fileItem.getStoreLocation();
        }

        public void deleteFileContents() {
          UploadedFileDefaultFileImpl.this.fileItem.delete();
        }
        
      };
    }


    /**
     * Answer the uploaded file contents.
     *
     * @return file contents
     */
    public byte[] getBytes() throws IOException
    {
        byte[] bytes = new byte[(int)getSize()];
        if (fileItem != null) fileItem.getInputStream().read(bytes);
        return bytes;
    }


    /**
     * Answer the uploaded file contents input stream
     *
     * @return InputStream
     * @throws IOException
     */
    public InputStream getInputStream() throws IOException
    {
        return fileItem != null
               ? fileItem.getInputStream()
               : new ByteArrayInputStream(new byte[0]);
    }


    /**
     * Answer the size of this file.
     * @return long
     */
    public long getSize()
    {
        return fileItem != null ? fileItem.getSize() : 0;
    }


    public StorageStrategy getStorageStrategy() {
      return storageStrategy;
    }
}
