/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.DefaultResourceProvider;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;
import org.apache.myfaces.renderkit.html.util.ResourceProvider;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class MyFacesResourceLoader
implements ResourceLoader {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader == null ? (class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader = MyFacesResourceLoader.class$("org.apache.myfaces.renderkit.html.util.MyFacesResourceLoader")) : class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader));
    static final String ORG_APACHE_MYFACES_CUSTOM = "org.apache.myfaces.custom";
    private static long lastModified = 0L;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$AddResource;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$ResourceProvider;

    private static long getLastModified() {
        if (lastModified == 0L) {
            String format = "yyyy-MM-dd HH:mm:ss Z";
            String bundleName = (class$org$apache$myfaces$renderkit$html$util$AddResource == null ? (class$org$apache$myfaces$renderkit$html$util$AddResource = MyFacesResourceLoader.class$("org.apache.myfaces.renderkit.html.util.AddResource")) : class$org$apache$myfaces$renderkit$html$util$AddResource).getName();
            ResourceBundle resources = ResourceBundle.getBundle(bundleName);
            String sLastModified = resources.getString("lastModified");
            try {
                lastModified = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(sLastModified).getTime();
            }
            catch (ParseException e) {
                lastModified = new Date().getTime();
                log.warn((Object)("Unparsable lastModified : " + sLastModified));
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response, String resourceUri) throws IOException {
        ResourceProvider resourceProvider;
        Class componentClass;
        String[] uriParts = resourceUri.split("/", 2);
        String component = uriParts[0];
        if (component == null || component.trim().length() == 0) {
            response.sendError(400, "Invalid request");
            log.error((Object)"Could not find parameter for component to load a resource.");
            return;
        }
        String className = "org.apache.myfaces.custom." + component;
        try {
            componentClass = this.loadComponentClass(className);
        }
        catch (ClassNotFoundException e) {
            response.sendError(400, e.getMessage());
            log.error((Object)("Could not find the class for component " + className + " to load a resource."));
            return;
        }
        String resource = uriParts[1];
        if (resource == null || resource.trim().length() == 0) {
            response.sendError(400, "No resource defined");
            log.error((Object)("No resource defined component class " + className));
            return;
        }
        InputStream is = null;
        if ((class$org$apache$myfaces$renderkit$html$util$ResourceProvider == null ? (class$org$apache$myfaces$renderkit$html$util$ResourceProvider = MyFacesResourceLoader.class$("org.apache.myfaces.renderkit.html.util.ResourceProvider")) : class$org$apache$myfaces$renderkit$html$util$ResourceProvider).isAssignableFrom(componentClass)) {
            try {
                resourceProvider = (ResourceProvider)componentClass.newInstance();
            }
            catch (InstantiationException e) {
                response.sendError(503, "Unable to instantiate resource provider for resource " + resource + " for component " + component);
                log.error((Object)("Unable to instantiate resource provider for resource " + resource + " for component " + component), (Throwable)e);
                return;
            }
            catch (IllegalAccessException e) {
                response.sendError(503, "Unable to instantiate resource provider for resource " + resource + " for component " + component);
                log.error((Object)("Unable to instantiate resource provider for resource " + resource + " for component " + component), (Throwable)e);
                return;
            }
        } else {
            resourceProvider = new DefaultResourceProvider(componentClass);
        }
        if (!resourceProvider.exists(context, resource)) {
            response.sendError(404, "Unable to find resource " + resource + " for component " + component + ". Check that this file is available " + "in the classpath in sub-directory " + "/resource of the package-directory.");
            log.error((Object)("Unable to find resource " + resource + " for component " + component + ". Check that this file is available " + "in the classpath in sub-directory " + "/resource of the package-directory."));
        } else {
            long browserDate;
            long lastModified = resourceProvider.getLastModified(context, resource);
            if (lastModified < 1L) {
                lastModified = MyFacesResourceLoader.getLastModified();
            }
            if ((browserDate = request.getDateHeader("If-Modified-Since")) > -1L && (lastModified = lastModified / 1000L * 1000L) == (browserDate = browserDate / 1000L * 1000L)) {
                response.setStatus(304);
                return;
            }
            int contentLength = resourceProvider.getContentLength(context, resource);
            String contentEncoding = resourceProvider.getEncoding(context, resource);
            is = resourceProvider.getInputStream(context, resource);
            this.defineContentHeaders(request, response, resource, contentLength, contentEncoding);
            this.defineCaching(request, response, resource, lastModified);
            this.writeResource(request, response, is);
        }
    }

    protected void writeResource(HttpServletRequest request, HttpServletResponse response, InputStream in) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int size = in.read(buffer);
            while (size != -1) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
            out.flush();
        }
        catch (IOException e) {
            log.debug((Object)"Unable to send resource data to client", (Throwable)e);
            throw new ResourceLoader.ClosedSocketException();
        }
    }

    protected void defineCaching(HttpServletRequest request, HttpServletResponse response, String resource, long lastModified) {
        response.setDateHeader("Last-Modified", lastModified);
        Calendar expires = Calendar.getInstance();
        expires.add(6, 7);
        response.setDateHeader("Expires", expires.getTimeInMillis());
        response.setHeader("Cache-Control", "max-age=43200");
        response.setHeader("Pragma", "");
    }

    protected void defineContentHeaders(HttpServletRequest request, HttpServletResponse response, String resource, int contentLength, String contentEncoding) {
        String charset = "";
        if (contentEncoding != null) {
            charset = "; charset=" + contentEncoding;
        }
        if (contentLength > -1) {
            response.setContentLength(contentLength);
        }
        if (resource.endsWith(".js")) {
            response.setContentType("text/javascript" + charset);
        } else if (resource.endsWith(".css")) {
            response.setContentType("text/css" + charset);
        } else if (resource.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (resource.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (resource.endsWith(".jpg") || resource.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else if (resource.endsWith(".xml") || resource.endsWith(".xsl")) {
            response.setContentType("text/xml");
        }
    }

    protected Class loadComponentClass(String componentClass) throws ClassNotFoundException {
        return ClassUtils.classForName(componentClass);
    }

    protected void validateCustomComponent(Class myfacesCustomComponent) {
        if (!myfacesCustomComponent.getName().startsWith("org.apache.myfaces.custom.")) {
            throw new IllegalArgumentException("expected a myfaces custom component class in package org.apache.myfaces.custom");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

