/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.collapsiblepanel;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.apache.myfaces.component.EventAware;
import org.apache.myfaces.component.StyleAware;
import org.apache.myfaces.component.UniversalProperties;
import org.apache.myfaces.component.UserRoleAware;

public abstract class AbstractHtmlCollapsiblePanel
extends UIInput
implements StyleAware,
UniversalProperties,
EventAware,
UserRoleAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlCollapsiblePanel";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.CollapsiblePanel";
    private static final String HEADER_FACET_NAME = "header";
    private static final String CLOSED_CONTENT_FACET_NAME = "closedContent";
    private boolean _currentlyCollapsed;

    public void setCurrentlyCollapsed(boolean collapsed) {
        this._currentlyCollapsed = collapsed;
    }

    public boolean isCurrentlyCollapsed() {
        return this._currentlyCollapsed;
    }

    public void setHeader(UIComponent header) {
        this.getFacets().put(HEADER_FACET_NAME, header);
    }

    public UIComponent getHeader() {
        return (UIComponent)this.getFacets().get(HEADER_FACET_NAME);
    }

    public void setClosedContent(UIComponent closedContent) {
        this.getFacets().put(CLOSED_CONTENT_FACET_NAME, closedContent);
    }

    public UIComponent getClosedContent() {
        return (UIComponent)this.getFacets().get(CLOSED_CONTENT_FACET_NAME);
    }

    public void processDecodes(FacesContext context) {
        UIComponent child;
        Iterator it;
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.initialiseVars(context);
        if (!this.isRendered()) {
            return;
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        UIComponent headerComponent = this.getFacet(HEADER_FACET_NAME);
        if (headerComponent != null) {
            it = headerComponent.getChildren().iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                child.processDecodes(context);
            }
        }
        if (this.isCurrentlyCollapsed()) {
            UIComponent component = this.getFacet(CLOSED_CONTENT_FACET_NAME);
            if (component != null) {
                component.processDecodes(context);
            }
        } else {
            it = this.getChildren().iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                child.processDecodes(context);
            }
        }
        this.removeVars(context);
    }

    public String getClientId(FacesContext context) {
        return super.getClientId(context);
    }

    public void processUpdates(FacesContext context) {
        this.initialiseVars(context);
        super.processUpdates(context);
        this.removeVars(context);
    }

    private void initialiseVars(FacesContext context) {
        if (this.getVar() != null) {
            context.getExternalContext().getRequestMap().put(this.getVar(), this.isCollapsed());
        }
        if (this.getTitleVar() != null) {
            context.getExternalContext().getRequestMap().put(this.getTitleVar(), this.getTitle());
        }
    }

    private void removeVars(FacesContext context) {
        if (this.getVar() != null) {
            context.getExternalContext().getRequestMap().remove(this.getVar());
        }
        if (this.getTitleVar() != null) {
            context.getExternalContext().getRequestMap().remove(this.getTitleVar());
        }
    }

    public void processValidators(FacesContext context) {
        this.initialiseVars(context);
        super.processValidators(context);
        this.removeVars(context);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        this.initialiseVars(context);
        super.encodeChildren(context);
        this.removeVars(context);
    }

    public void updateModel(FacesContext context) {
        super.updateModel(context);
    }

    public boolean isCollapsed() {
        return AbstractHtmlCollapsiblePanel.isCollapsed(this.getValue());
    }

    public static boolean isCollapsed(Object collapsedValue) {
        Object value = collapsedValue;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return true;
    }

    public abstract String getVar();

    public abstract String getTitleVar();

    public MethodBinding getValidator() {
        return super.getValidator();
    }

    public MethodBinding getValueChangeListener() {
        return super.getValueChangeListener();
    }

    public boolean isImmediate() {
        return super.isImmediate();
    }

    public boolean isRequired() {
        return super.isRequired();
    }
}

