/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navmenu.htmlnavmenu;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.html.ext.AbstractHtmlCommandLink;
import org.apache.myfaces.custom.navmenu.NavigationMenuUtils;
import org.apache.myfaces.custom.navmenu.UINavigationMenuItem;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlCommandNavigationItem;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlPanelNavigationMenu;
import org.apache.myfaces.shared_tomahawk.el.SimpleActionMethodBinding;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

class HtmlNavigationMenuRendererUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlNavigationMenuRendererUtils == null ? (class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlNavigationMenuRendererUtils = HtmlNavigationMenuRendererUtils.class$("org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlNavigationMenuRendererUtils")) : class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlNavigationMenuRendererUtils));
    private static final Class[] ACTION_LISTENER_ARGS = new Class[]{class$javax$faces$event$ActionEvent == null ? (class$javax$faces$event$ActionEvent = HtmlNavigationMenuRendererUtils.class$("javax.faces.event.ActionEvent")) : class$javax$faces$event$ActionEvent};
    static /* synthetic */ Class class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlNavigationMenuRendererUtils;
    static /* synthetic */ Class class$javax$faces$event$ActionEvent;

    private HtmlNavigationMenuRendererUtils() {
    }

    public static void renderChildrenListLayout(FacesContext facesContext, ResponseWriter writer, HtmlPanelNavigationMenu panelNav, List children, int level) throws IOException {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            boolean renderAsOutputLink;
            UIComponent child = (UIComponent)it.next();
            if (!child.isRendered()) continue;
            if (child instanceof UINavigationMenuItem) {
                HtmlNavigationMenuRendererUtils.renderChildrenListLayout(facesContext, writer, panelNav, child.getChildren(), level);
            }
            if (!(child instanceof HtmlCommandNavigationItem)) continue;
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            HtmlCommandNavigationItem navItem = (HtmlCommandNavigationItem)child;
            String externalLink = navItem.getExternalLink();
            String style = HtmlNavigationMenuRendererUtils.getNavigationItemStyle(panelNav, navItem);
            String styleClass = HtmlNavigationMenuRendererUtils.getNavigationItemClass(panelNav, navItem);
            writer.startElement("li", (UIComponent)panelNav);
            HtmlNavigationMenuRendererUtils.writeStyleAttributes(writer, style, styleClass);
            Object value = navItem.getValue();
            boolean bl = renderAsOutputLink = externalLink != null && value != null;
            if (!renderAsOutputLink) {
                if (externalLink == null) {
                    navItem.setValue(null);
                    navItem.encodeBegin(facesContext);
                }
                HtmlNavigationMenuRendererUtils.renderChildren(facesContext, navItem, panelNav);
                if (externalLink == null) {
                    navItem.encodeEnd(facesContext);
                    navItem.setValue(value);
                }
            } else {
                HtmlNavigationMenuRendererUtils.renderChildren(facesContext, navItem, panelNav);
            }
            if (HtmlNavigationMenuRendererUtils.hasCommandNavigationItemChildren(navItem)) {
                writer.startElement("ul", (UIComponent)panelNav);
                if (panelNav.isRenderAll()) {
                    HtmlNavigationMenuRendererUtils.writeStyleAttributes(writer, navItem.getStyle(), navItem.getStyleClass());
                }
                HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)panelNav, HTML.UL_PASSTHROUGH_ATTRIBUTES);
                HtmlNavigationMenuRendererUtils.renderChildrenListLayout(facesContext, writer, panelNav, child.getChildren(), level + 1);
                writer.endElement("ul");
            }
            writer.endElement("li");
        }
    }

    private static boolean hasCommandNavigationItemChildren(HtmlCommandNavigationItem item) {
        List children = item.getChildren();
        int sizei = children.size();
        for (int i = 0; i < sizei; ++i) {
            if (!(children.get(i) instanceof HtmlCommandNavigationItem)) continue;
            return true;
        }
        return false;
    }

    public static void renderChildrenTableLayout(FacesContext facesContext, ResponseWriter writer, HtmlPanelNavigationMenu panelNav, List children, int level) throws IOException {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            String styleClass;
            String style;
            UIComponent child = (UIComponent)it.next();
            if (!child.isRendered()) continue;
            if (child instanceof HtmlCommandNavigationItem) {
                HtmlRendererUtils.writePrettyLineSeparator(facesContext);
                style = HtmlNavigationMenuRendererUtils.getNavigationItemStyle(panelNav, (HtmlCommandNavigationItem)child);
                styleClass = HtmlNavigationMenuRendererUtils.getNavigationItemClass(panelNav, (HtmlCommandNavigationItem)child);
                writer.startElement("tr", (UIComponent)panelNav);
                writer.startElement("td", (UIComponent)panelNav);
                HtmlNavigationMenuRendererUtils.writeStyleAttributes(writer, style, styleClass);
                if (style != null || styleClass != null) {
                    writer.startElement("span", (UIComponent)panelNav);
                    HtmlNavigationMenuRendererUtils.writeStyleAttributes(writer, style, styleClass);
                }
                HtmlNavigationMenuRendererUtils.indent(writer, level);
                child.encodeBegin(facesContext);
                child.encodeEnd(facesContext);
                if (style != null || styleClass != null) {
                    writer.endElement("span");
                }
                writer.endElement("td");
                writer.endElement("tr");
                if (child.getChildCount() <= 0) continue;
                HtmlNavigationMenuRendererUtils.renderChildrenTableLayout(facesContext, writer, panelNav, child.getChildren(), level + 1);
                continue;
            }
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            style = panelNav.getSeparatorStyle();
            styleClass = panelNav.getSeparatorClass();
            writer.startElement("tr", (UIComponent)panelNav);
            writer.startElement("td", (UIComponent)panelNav);
            HtmlNavigationMenuRendererUtils.writeStyleAttributes(writer, style, styleClass);
            if (style != null || styleClass != null) {
                writer.startElement("span", (UIComponent)panelNav);
                HtmlNavigationMenuRendererUtils.writeStyleAttributes(writer, style, styleClass);
            }
            HtmlNavigationMenuRendererUtils.indent(writer, level);
            RendererUtils.renderChild(facesContext, child);
            if (style != null || styleClass != null) {
                writer.endElement("span");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    public static void indent(ResponseWriter writer, int level) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("&#160;&#160;&#160;&#160;");
        }
        writer.write(buf.toString());
    }

    public static String getNavigationItemStyle(HtmlPanelNavigationMenu navPanel, HtmlCommandNavigationItem navItem) {
        if (navItem.isActive()) {
            return navPanel.getActiveItemStyle();
        }
        if (navItem.isOpen()) {
            return navPanel.getOpenItemStyle();
        }
        return navPanel.getItemStyle();
    }

    public static String getNavigationItemClass(HtmlPanelNavigationMenu navPanel, HtmlCommandNavigationItem navItem) {
        if (navItem.getStyleClass() != null) {
            return navItem.getStyleClass();
        }
        if (navItem.isActive()) {
            return navPanel.getActiveItemClass();
        }
        if (navItem.isOpen()) {
            return navPanel.getOpenItemClass();
        }
        return navPanel.getItemClass();
    }

    public static void writeStyleAttributes(ResponseWriter writer, String style, String styleClass) throws IOException {
        HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
        HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
    }

    public static UIComponent getPanel(UIComponent link) {
        UIComponent navPanel;
        for (navPanel = link.getParent(); navPanel != null && !(navPanel instanceof HtmlPanelNavigationMenu); navPanel = navPanel.getParent()) {
        }
        if (navPanel == null) {
            throw new IllegalStateException("HtmlCommandNavigationItem not nested in HtmlPanelNavigation!?");
        }
        return navPanel;
    }

    public static boolean isListLayout(HtmlPanelNavigationMenu panelNav) {
        return !"Table".equalsIgnoreCase(panelNav.getLayout());
    }

    public static void renderChildren(FacesContext facesContext, HtmlCommandNavigationItem component, HtmlPanelNavigationMenu parentPanelNav) throws IOException {
        if (component.getChildCount() > 0) {
            ResponseWriter writer;
            if (component.getExternalLink() != null) {
                writer = facesContext.getResponseWriter();
                writer.startElement("a", null);
                writer.writeAttribute("href", (Object)component.getExternalLink(), null);
                if (component.getTarget() != null) {
                    writer.writeAttribute("target", (Object)component.getTarget(), null);
                }
                String style = HtmlNavigationMenuRendererUtils.getNavigationItemStyle(parentPanelNav, component);
                String styleClass = HtmlNavigationMenuRendererUtils.getNavigationItemClass(parentPanelNav, component);
                HtmlNavigationMenuRendererUtils.writeStyleAttributes(writer, style, styleClass);
            }
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (child instanceof HtmlCommandNavigationItem) continue;
                RendererUtils.renderChild(facesContext, child);
            }
            if (component.getExternalLink() != null) {
                writer = facesContext.getResponseWriter();
                writer.endElement("a");
            }
        }
    }

    public static void debugTree(Log log, FacesContext facesContext, List children, int level) {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            UIOutput uiOutput;
            int i;
            StringBuffer buf;
            UserRoleAware item;
            UIComponent child = (UIComponent)it.next();
            if (child instanceof UINavigationMenuItem) {
                item = (UINavigationMenuItem)child;
                buf = new StringBuffer();
                for (i = 0; i < level * 4; ++i) {
                    buf.append(' ');
                }
                log.debug((Object)(buf.toString() + "--> " + item.getItemLabel() + " id:" + item.getClientId(facesContext)));
                HtmlNavigationMenuRendererUtils.debugTree(log, facesContext, child.getChildren(), level + 1);
                continue;
            }
            if (!(child instanceof HtmlCommandNavigationItem)) continue;
            item = (HtmlCommandNavigationItem)child;
            buf = new StringBuffer();
            for (i = 0; i < level * 4; ++i) {
                buf.append(' ');
            }
            String value = item.getChildren().size() > 0 && item.getChildren().get(0) instanceof UIOutput ? ((uiOutput = (UIOutput)item.getChildren().get(0)).getValue() != null ? uiOutput.getValue().toString() : "?") : (item.getValue() != null ? item.getValue().toString() : "");
            log.debug((Object)(buf.toString() + value + " id:" + ((AbstractHtmlCommandLink)item).getClientId(facesContext)));
            HtmlNavigationMenuRendererUtils.debugTree(log, facesContext, child.getChildren(), level + 1);
        }
    }

    public static HtmlCommandNavigationItem findPreviousItem(UIViewRoot previousViewRoot, String clientId) {
        UIComponent previousComp;
        HtmlCommandNavigationItem previousItem = null;
        if (previousViewRoot != null && (previousComp = previousViewRoot.findComponent(clientId)) instanceof HtmlCommandNavigationItem) {
            previousItem = (HtmlCommandNavigationItem)previousComp;
        }
        return previousItem;
    }

    public static MethodBinding getMethodBinding(FacesContext facesContext, String value, boolean actionListener) {
        SimpleActionMethodBinding mb;
        if (NavigationMenuUtils.isValueReference(value)) {
            mb = facesContext.getApplication().createMethodBinding(value, (Class[])(actionListener ? ACTION_LISTENER_ARGS : null));
        } else if (actionListener) {
            log.error((Object)("Invalid actionListener value " + value + " (has to be ValueReference!)"));
            mb = null;
        } else {
            mb = new SimpleActionMethodBinding(value);
        }
        return mb;
    }

    public static void setAttributeValue(FacesContext facesContext, UIComponent comp, String attribute, String value) {
        if (value == null) {
            return;
        }
        if (NavigationMenuUtils.isValueReference(value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            comp.setValueBinding(attribute, vb);
        } else {
            comp.getAttributes().put(attribute, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

