/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.schedule.AbstractScheduleRenderer;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.UIScheduleBase;
import org.apache.myfaces.custom.schedule.model.Interval;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public class ScheduleDetailedDayRenderer
extends AbstractScheduleRenderer
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$schedule$ScheduleDetailedDayRenderer == null ? (class$org$apache$myfaces$custom$schedule$ScheduleDetailedDayRenderer = ScheduleDetailedDayRenderer.class$("org.apache.myfaces.custom.schedule.ScheduleDetailedDayRenderer")) : class$org$apache$myfaces$custom$schedule$ScheduleDetailedDayRenderer));
    private static final long serialVersionUID = -5103791076091317355L;
    private final int defaultRowHeightInPixels = 22;
    static /* synthetic */ Class class$org$apache$myfaces$custom$schedule$ScheduleDetailedDayRenderer;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        int rowHeight = this.getRowHeight(schedule);
        int numberOfRows = (this.getRenderedEndHour(schedule) - this.getRenderedStartHour(schedule)) * 2 + 1;
        int gridHeight = numberOfRows * rowHeight + 3 + 10;
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)("schedule-detailed-" + schedule.getTheme()), null);
        writer.writeAttribute("style", (Object)("height: " + String.valueOf(gridHeight) + "px; overflow: hidden;"), null);
        this.writeBackgroundStart(context, schedule, writer);
        this.writeForegroundStart(context, schedule, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            String dayBodyId = clientId + "_body_" + ScheduleUtil.getDateId(day.getDate(), schedule.getModel().getTimeZone());
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "column"), null);
            writer.writeAttribute("style", (Object)"height: 100%;", null);
            writer.startElement("div", (UIComponent)schedule);
            writer.writeAttribute("id", (Object)dayBodyId, null);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "column"), null);
            writer.writeAttribute("style", (Object)"position: relative; top: 0px; left: 0px; width: 100%; height: 100%; z-index: 0;", null);
            if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
                writer.writeAttribute("onmouseup", (Object)("fireScheduleTimeClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
            }
            this.writeEntries(context, schedule, day, writer);
            writer.endElement("div");
            writer.endElement("td");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        this.writeForegroundEnd(writer);
        this.writeBackgroundEnd(writer);
        writer.endElement("div");
    }

    protected String getCellClass(HtmlSchedule schedule, ScheduleDay day, boolean even, int hour) {
        String cellClass = "free";
        if (!day.isWorkingDay()) {
            return this.getStyleClass((UIComponent)schedule, cellClass);
        }
        if (hour >= schedule.getWorkingStartHour() && hour < schedule.getWorkingEndHour()) {
            cellClass = even ? "even" : "uneven";
        }
        return this.getStyleClass((UIComponent)schedule, cellClass);
    }

    protected boolean isSelected(HtmlSchedule schedule, EntryWrapper entry) {
        ScheduleEntry selectedEntry = schedule.getModel().getSelectedEntry();
        if (selectedEntry == null) {
            return false;
        }
        boolean returnboolean = selectedEntry.getId().equals(entry.entry.getId());
        return returnboolean;
    }

    protected void maximizeEntries(EntryWrapper[] entries, int numberOfColumns) {
        for (int i = 0; i < entries.length; ++i) {
            EntryWrapper entry = entries[i];
            while (entry.column + entry.colspan < numberOfColumns && entry.canFitInColumn(entry.column + entry.colspan)) {
                entry.colspan++;
            }
        }
    }

    protected void scanEntries(EntryWrapper[] entries, int index) {
        if (entries.length <= 0) {
            return;
        }
        EntryWrapper entry = entries[index];
        entry.column = 0;
        for (int i = 0; i < index; ++i) {
            if (!entry.overlaps(entries[i])) continue;
            entry.overlappingEntries.add(entries[i]);
            entries[i].overlappingEntries.add(entry);
        }
        while (!entry.canFitInColumn(entry.column)) {
            entry.column++;
        }
        if (++index < entries.length) {
            this.scanEntries(entries, index);
        }
    }

    protected void writeGutter(FacesContext context, HtmlSchedule schedule, ResponseWriter writer, boolean useIntervalLabels) throws IOException {
        int rowHeight = this.getRowHeight(schedule);
        int headerHeight = rowHeight + 9;
        int startHour = this.getRenderedStartHour(schedule);
        int endHour = this.getRenderedEndHour(schedule);
        DateFormat hourFormater = ScheduleDetailedDayRenderer.getDateFormat(context, schedule, "12".equals(schedule.getHourNotation()) ? "h" : "HH");
        DateFormat minuteFormater = ScheduleDetailedDayRenderer.getDateFormat(context, schedule, "12".equals(schedule.getHourNotation()) ? "':'mma" : "mm");
        DateFormat shortMinuteFormater = ScheduleDetailedDayRenderer.getDateFormat(context, schedule, "12".equals(schedule.getHourNotation()) ? "a" : "mm");
        ScheduleDay day = (ScheduleDay)schedule.getModel().iterator().next();
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "background"), null);
        writer.writeAttribute("style", (Object)"height: 100%", null);
        writer.startElement("tbody", (UIComponent)schedule);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "gutter"), null);
        writer.writeAttribute("style", (Object)("height: " + headerHeight + "px; border-style: none; border-width: 0px; overflow: hidden; padding: 0px"), null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 1px; width: 56px", null);
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        Iterator intervalIt = day.getIntervals(startHour, endHour).iterator();
        boolean renderGutter = true;
        while (intervalIt.hasNext()) {
            Interval interval = (Interval)intervalIt.next();
            int intervalHeight = this.calcRowHeight(rowHeight, interval.getDuration()) - 1;
            if (intervalHeight <= 0) continue;
            if (!renderGutter) {
                renderGutter = true;
                continue;
            }
            writer.startElement("tr", (UIComponent)schedule);
            int gutterHeight = intervalHeight;
            if (day.getIntervals() == null && interval.getStartMinutes(this.getTimeZone(schedule)) == 0) {
                gutterHeight = gutterHeight * 2 + 1;
                renderGutter = false;
            }
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "gutter"), null);
            writer.writeAttribute("style", (Object)("height: " + gutterHeight + "px; border-style: none; border-width: 0px; overflow: hidden; padding: 0px"), null);
            if (interval.getDuration() >= 1800000L) {
                if (!useIntervalLabels || interval.getLabel() == null) {
                    writer.startElement("span", (UIComponent)schedule);
                    writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, renderGutter ? "minutes" : "hours"), null);
                    writer.writeAttribute("style", (Object)"vertical-align: top; height: 100%; padding: 0px;", null);
                    writer.writeText((Object)hourFormater.format(interval.getStartTime()), null);
                    writer.endElement("span");
                }
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "minutes"), null);
                writer.writeAttribute("style", (Object)"vertical-align: top; height: 100%; padding: 0px;", null);
                if (useIntervalLabels && interval.getLabel() != null) {
                    writer.writeText((Object)interval.getLabel(), null);
                } else {
                    writer.writeText((Object)(renderGutter ? minuteFormater : shortMinuteFormater).format(interval.getStartTime()), null);
                }
                writer.endElement("span");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void writeBackgroundStart(FacesContext context, HtmlSchedule schedule, ResponseWriter writer) throws IOException {
        boolean repeatedIntervals = schedule.getModel().containsRepeatedIntervals();
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
        writer.startElement("tbody", (UIComponent)schedule);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"width: 56px; vertical-align: top;", null);
        this.writeGutter(context, schedule, writer, repeatedIntervals);
        writer.endElement("td");
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"width: 99%; vertical-align: top;", null);
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        int rowHeight = this.getRowHeight(schedule);
        int headerHeight = rowHeight + 9;
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "background"), null);
        writer.writeAttribute("style", (Object)"position: relative; width: 100%; height: 100%; z-index: 0;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "background"), null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
        writer.startElement("tbody", (UIComponent)schedule);
        writer.startElement("tr", (UIComponent)schedule);
        float columnWidth = schedule.getModel().size() == 0 ? 100.0f : (float)(100 / schedule.getModel().size());
        int startHour = this.getRenderedStartHour(schedule);
        int endHour = this.getRenderedEndHour(schedule);
        ScheduleDay day = null;
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("style", (Object)("width: " + String.valueOf(columnWidth) + "%"), null);
            day = (ScheduleDay)dayIterator.next();
            writer.startElement("table", (UIComponent)schedule);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"1", null);
            writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
            writer.startElement("tbody", (UIComponent)schedule);
            writer.startElement("tr", (UIComponent)schedule);
            String dayHeaderId = clientId + "_header_" + ScheduleUtil.getDateId(day.getDate(), schedule.getModel().getTimeZone());
            writer.startElement("th", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "header"), null);
            writer.writeAttribute("style", (Object)("height: " + headerHeight + "px; vertical-align: top; border-style: none; border-width: 0px; overflow: hidden;"), null);
            boolean isToday = ScheduleUtil.isSameDay(day.getDate(), new Date(), schedule.getModel().getTimeZone());
            writer.startElement("a", (UIComponent)schedule);
            writer.writeAttribute("id", (Object)dayHeaderId, null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)(this.getStyleClass((UIComponent)schedule, "date") + (isToday ? " today" : "")), null);
            writer.writeAttribute("style", (Object)"display: block; height: 50%; width: 100%; overflow: hidden; white-space: nowrap;", null);
            if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
                writer.writeAttribute("onclick", (Object)("fireScheduleDateClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
            }
            writer.writeText((Object)this.getDateString(context, schedule, day.getDate()), null);
            writer.endElement("a");
            if (day.getSpecialDayName() != null && day.getSpecialDayName().length() > 0) {
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "holiday"), null);
                writer.writeAttribute("style", (Object)"height: 50%; width: 100%; overflow: hidden; white-space: nowrap;", null);
                writer.writeText((Object)day.getSpecialDayName(), null);
                writer.endElement("span");
            }
            writer.endElement("th");
            writer.endElement("tr");
            Iterator intervalIt = day.getIntervals(startHour, endHour).iterator();
            boolean even = false;
            while (intervalIt.hasNext()) {
                Interval interval = (Interval)intervalIt.next();
                int intervalHeight = this.calcRowHeight(rowHeight, interval.getDuration()) - 1;
                if (intervalHeight <= 0) continue;
                writer.startElement("tr", (UIComponent)schedule);
                writer.startElement("td", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getCellClass(schedule, day, even, interval.getStartHours(this.getTimeZone(schedule))), null);
                writer.writeAttribute("style", (Object)("overflow: hidden; height: " + intervalHeight + "px;"), null);
                if (!repeatedIntervals && interval.getLabel() != null) {
                    writer.write(interval.getLabel());
                }
                writer.endElement("td");
                writer.endElement("tr");
                even = !even;
            }
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void writeBackgroundEnd(ResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    private int calcRowHeight(int halfHourHeight, long duration) {
        return duration == 1800000L ? halfHourHeight : (int)((float)halfHourHeight / 1800000.0f * (float)duration);
    }

    protected int getRenderedStartHour(HtmlSchedule schedule) {
        int startHour = schedule.getVisibleStartHour();
        if (!this.expandToFitEntries((UIComponent)schedule)) {
            return startHour;
        }
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            int dayStart = day.getFirstEventHour();
            if (dayStart >= startHour) continue;
            startHour = dayStart;
        }
        return startHour;
    }

    protected int getRenderedEndHour(HtmlSchedule schedule) {
        int endHour = schedule.getVisibleEndHour();
        if (!this.expandToFitEntries((UIComponent)schedule)) {
            return endHour;
        }
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            int dayEnd = day.getLastEventHour();
            if (dayEnd <= endHour) continue;
            endHour = dayEnd;
        }
        return endHour;
    }

    protected void writeEntries(FacesContext context, HtmlSchedule schedule, ScheduleDay day, ResponseWriter writer) throws IOException {
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        TreeSet<EntryWrapper> entrySet = new TreeSet<EntryWrapper>();
        Iterator entryIterator = day.iterator();
        while (entryIterator.hasNext()) {
            entrySet.add(new EntryWrapper((ScheduleEntry)entryIterator.next(), day));
        }
        EntryWrapper[] entries = entrySet.toArray(new EntryWrapper[entrySet.size()]);
        this.scanEntries(entries, 0);
        int maxColumn = 0;
        Iterator entryIterator2 = entrySet.iterator();
        while (entryIterator2.hasNext()) {
            EntryWrapper wrapper = (EntryWrapper)entryIterator2.next();
            maxColumn = Math.max(wrapper.column, maxColumn);
        }
        int numberOfColumns = maxColumn + 1;
        this.maximizeEntries(entries, numberOfColumns);
        float columnWidth = 100 / numberOfColumns;
        Iterator entryIterator3 = entrySet.iterator();
        while (entryIterator3.hasNext()) {
            EntryWrapper wrapper = (EntryWrapper)entryIterator3.next();
            boolean selected = this.isSelected(schedule, wrapper);
            StringBuffer entryStyle = new StringBuffer();
            entryStyle.append(wrapper.getBounds(schedule, columnWidth));
            String entryBorderColor = this.getEntryRenderer(schedule).getColor(context, schedule, wrapper.entry, selected);
            if (entryBorderColor != null) {
                entryStyle.append(" border-color: ");
                entryStyle.append(entryBorderColor);
                entryStyle.append(";");
            }
            if (selected) {
                writer.startElement("div", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "entry-selected"), null);
                writer.writeAttribute("style", (Object)entryStyle.toString(), null);
                if (schedule.isTooltip()) {
                    this.getEntryRenderer(schedule).renderToolTip(context, writer, schedule, wrapper.entry, selected);
                }
                this.getEntryRenderer(schedule).renderContent(context, writer, schedule, day, wrapper.entry, false, selected);
                writer.endElement("div");
                continue;
            }
            writer.startElement(schedule.isReadonly() ? "div" : "a", (UIComponent)schedule);
            if (schedule.isTooltip()) {
                this.getEntryRenderer(schedule).renderToolTip(context, writer, schedule, wrapper.entry, selected);
            }
            if (!schedule.isReadonly()) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)("fireEntrySelected('" + formId + "', '" + clientId + "', '" + wrapper.entry.getId() + "');"), null);
            }
            writer.writeAttribute("class", (Object)this.getEntryRenderer(schedule).getEntryClass(schedule, wrapper.entry), null);
            writer.writeAttribute("style", (Object)entryStyle.toString(), null);
            this.getEntryRenderer(schedule).renderContent(context, writer, schedule, day, wrapper.entry, false, selected);
            writer.endElement(schedule.isReadonly() ? "div" : "a");
        }
    }

    protected void writeForegroundEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void writeForegroundStart(FacesContext context, HtmlSchedule schedule, ResponseWriter writer) throws IOException {
        int rowHeight = this.getRowHeight(schedule) - 1;
        int headerHeight = rowHeight + 10;
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "foreground"), null);
        writer.writeAttribute("style", (Object)("position: absolute; left: 0px; top: " + headerHeight + "px; width: 100%; height: 100%;    z-index: 2;"), null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "foreground"), null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
        float columnWidth = schedule.getModel().size() == 0 ? 100.0f : (float)(100 / schedule.getModel().size());
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            dayIterator.next();
            writer.startElement("col", (UIComponent)schedule);
            writer.writeAttribute("style", (Object)("width: " + String.valueOf(columnWidth) + "%;"), null);
            writer.endElement("col");
        }
        writer.startElement("tr", (UIComponent)schedule);
    }

    protected int getDefaultRowHeight() {
        return 22;
    }

    protected Date determineLastClickedDate(HtmlSchedule schedule, String dateId, String yPos) {
        String day = dateId.substring(dateId.lastIndexOf("_") + 1);
        Date date = ScheduleUtil.getDateFromId(day, schedule.getModel().getTimeZone());
        Calendar cal = this.getCalendarInstance(schedule, date != null ? date : new Date());
        cal.set(11, this.getRenderedStartHour(schedule));
        try {
            int y = Integer.parseInt(yPos);
            int halfHourHeight = this.getRowHeight(schedule);
            int minutes = y * 30 / halfHourHeight;
            cal.add(12, minutes);
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)"y position is not a number");
        }
        log.debug((Object)("last clicked datetime: " + cal.getTime()));
        return cal.getTime();
    }

    protected boolean renderZeroLengthEntries(UIComponent component) {
        if (component instanceof UIScheduleBase) {
            UIScheduleBase schedule = (UIScheduleBase)component;
            return schedule.isRenderZeroLengthEntries();
        }
        return false;
    }

    protected boolean expandToFitEntries(UIComponent component) {
        if (component instanceof HtmlSchedule) {
            HtmlSchedule schedule = (HtmlSchedule)component;
            return schedule.isExpandToFitEntries();
        }
        return false;
    }

    protected int getRowHeight(UIScheduleBase schedule) {
        if (schedule != null) {
            int height = schedule.getDetailedRowHeight();
            return height <= 0 ? this.getDefaultRowHeight() : height;
        }
        return this.getDefaultRowHeight();
    }

    private TimeZone getTimeZone(UIScheduleBase schedule) {
        return schedule != null && schedule.getModel().getTimeZone() != null ? schedule.getModel().getTimeZone() : TimeZone.getDefault();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EntryWrapper
    implements Comparable {
        private static final int HALF_HOUR = 1800000;
        private final ScheduleDay day;
        private final ScheduleEntry entry;
        private final TreeSet overlappingEntries;
        private int colspan;
        private int column;

        EntryWrapper(ScheduleEntry entry, ScheduleDay day) {
            this.entry = entry;
            this.day = day;
            this.column = 0;
            this.colspan = 1;
            this.overlappingEntries = new TreeSet();
        }

        public int compareTo(Object o) {
            return AbstractScheduleRenderer.comparator.compare(this.entry, o);
        }

        public boolean equals(Object o) {
            if (o instanceof EntryWrapper) {
                EntryWrapper other = (EntryWrapper)o;
                boolean returnboolean = this.entry.getStartTime().equals(other.entry.getStartTime()) && this.entry.getEndTime().equals(other.entry.getEndTime()) && this.entry.getId().equals(other.entry.getId()) && this.day.equals(other.day);
                return returnboolean;
            }
            return false;
        }

        public int hashCode() {
            int returnint = this.entry.getStartTime().hashCode() ^ this.entry.getEndTime().hashCode() ^ this.entry.getId().hashCode();
            return returnint;
        }

        String getBounds(HtmlSchedule schedule, float columnWidth) {
            boolean entryVisible;
            int rowHeight = ScheduleDetailedDayRenderer.this.getRowHeight(schedule);
            float width = columnWidth * (float)this.colspan - 0.5f;
            float left = (float)this.column * columnWidth;
            Calendar cal = ScheduleDetailedDayRenderer.this.getCalendarInstance(schedule, this.day.getDate());
            int curyear = cal.get(1);
            int curmonth = cal.get(2);
            int curday = cal.get(5);
            cal.setTime(this.entry.getStartTime());
            cal.set(curyear, curmonth, curday);
            long startMillis = cal.getTimeInMillis();
            cal.set(11, ScheduleDetailedDayRenderer.this.getRenderedStartHour(schedule));
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleStartMillis = cal.getTimeInMillis();
            startMillis = this.day.equalsDate(this.entry.getStartTime()) ? Math.max(startMillis, visibleStartMillis) : visibleStartMillis;
            cal.setTime(this.entry.getEndTime());
            cal.set(curyear, curmonth, curday);
            long endMillis = cal.getTimeInMillis();
            cal.set(11, ScheduleDetailedDayRenderer.this.getRenderedEndHour(schedule));
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleEndMillis = cal.getTimeInMillis();
            endMillis = this.day.equalsDate(this.entry.getEndTime()) ? Math.min(endMillis, visibleEndMillis) : visibleEndMillis;
            int top = (int)((startMillis - visibleStartMillis) * (long)rowHeight / 1800000L);
            int height = (int)((endMillis - startMillis) * (long)rowHeight / 1800000L);
            StringBuffer buffer = new StringBuffer();
            boolean bl = entryVisible = height > 0 || ScheduleDetailedDayRenderer.this.renderZeroLengthEntries((UIComponent)schedule);
            if (!entryVisible) {
                buffer.append("visibility: hidden; ");
            }
            buffer.append("position: absolute; height: ");
            if (height > 2) {
                buffer.append(height - 2 + "px");
            } else if (height > 0) {
                buffer.append(height + "px");
            } else if (entryVisible) {
                buffer.append("auto");
            } else {
                buffer.append("0px");
            }
            buffer.append("; top: ");
            buffer.append(top);
            buffer.append("px; left: ");
            buffer.append(left);
            buffer.append("%; width: ");
            buffer.append(width);
            buffer.append("%; padding: 0px; overflow: hidden; border-width: 1.0px; border-style:solid;");
            return buffer.toString();
        }

        boolean canFitInColumn(int column) {
            Iterator overlapIterator = this.overlappingEntries.iterator();
            while (overlapIterator.hasNext()) {
                EntryWrapper overlap = (EntryWrapper)overlapIterator.next();
                if (overlap.column != column) continue;
                return false;
            }
            return true;
        }

        Date minimumEndTime() {
            Date start = this.entry.getStartTime();
            Date end = this.entry.getEndTime();
            return end != null ? (end.after(start) ? end : new Date(start.getTime() + 1800000L)) : null;
        }

        boolean overlaps(EntryWrapper other) {
            Date start = this.entry.getStartTime();
            Date end = this.minimumEndTime();
            if (start == null || end == null) {
                return false;
            }
            boolean returnboolean = start.before(other.minimumEndTime()) && end.after(other.entry.getStartTime());
            return returnboolean;
        }
    }
}

