/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tabbedpane;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTab;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane;
import org.apache.myfaces.custom.tabbedpane.TabChangeEvent;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

public class HtmlTabbedPaneRenderer
extends HtmlRenderer {
    private static final String HEADER_ROW_CLASS = "myFaces_pannelTabbedPane_HeaderRow";
    private static final String ACTIVE_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_activeHeaderCell";
    private static final String INACTIVE_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_inactiveHeaderCell";
    private static final String DISABLED_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_disabledHeaderCell";
    private static final String EMPTY_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_emptyHeaderCell";
    private static final String SUB_HEADER_ROW_CLASS = "myFaces_pannelTabbedPane_subHeaderRow";
    private static final String SUB_HEADER_CELL_CLASS = "myFaces_panelTabbedPane_subHeaderCell";
    private static final String SUB_HEADER_CELL_CLASS_ACTIVE = "myFaces_panelTabbedPane_subHeaderCell_active";
    private static final String SUB_HEADER_CELL_CLASS_INACTIVE = "myFaces_panelTabbedPane_subHeaderCell_inactive";
    private static final String SUB_HEADER_CELL_CLASS_FIRST = "myFaces_panelTabbedPane_subHeaderCell_first";
    private static final String SUB_HEADER_CELL_CLASS_LAST = "myFaces_panelTabbedPane_subHeaderCell_last";
    private static final String CONTENT_ROW_CLASS = "myFaces_panelTabbedPane_contentRow";
    private static final String TAB_PANE_CLASS = "myFaces_panelTabbedPane_pane";
    private static final String DEFAULT_BG_COLOR = "white";
    private static final String AUTO_FORM_SUFFIX = ".autoform";
    private static final String TAB_DIV_SUFFIX = ".content";
    static /* synthetic */ Class class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane;
    static /* synthetic */ Class class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer;

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane")) : class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane);
        HtmlPanelTabbedPane tabbedPane = (HtmlPanelTabbedPane)uiComponent;
        if (tabbedPane.getBgcolor() == null) {
            tabbedPane.setBgcolor(DEFAULT_BG_COLOR);
        }
        AddResource addResource = AddResourceFactory.getInstance(facesContext);
        addResource.addStyleSheet(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlTabbedPaneRenderer")) : class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer, "defaultStyles.css");
        if (tabbedPane.isClientSide()) {
            addResource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlTabbedPaneRenderer")) : class$org$apache$myfaces$custom$tabbedpane$HtmlTabbedPaneRenderer, "dynamicTabs.js");
            addResource.addInlineStyleAtPosition(facesContext, AddResource.HEADER_BEGIN, '#' + this.getTableStylableId(tabbedPane, facesContext) + " ." + ACTIVE_HEADER_CELL_CLASS + " input,\n" + '#' + this.getTableStylableId(tabbedPane, facesContext) + " ." + TAB_PANE_CLASS + ",\n" + '#' + this.getTableStylableId(tabbedPane, facesContext) + " ." + SUB_HEADER_CELL_CLASS + "{\n" + "background-color:" + tabbedPane.getBgcolor() + ";\n" + "}\n");
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        int selectedIndex = tabbedPane.getSelectedIndex();
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)tabbedPane, facesContext);
        if (parentFormInfo == null) {
            this.writeFormStart(writer, facesContext, (UIComponent)tabbedPane);
        }
        List children = tabbedPane.getChildren();
        if (tabbedPane.isClientSide()) {
            ArrayList<String> headerIDs = new ArrayList<String>();
            ArrayList<String> tabIDs = new ArrayList<String>();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.getUIComponent((UIComponent)children.get(i));
                if (!(child instanceof HtmlPanelTab) || !child.isRendered()) continue;
                HtmlPanelTab tab = (HtmlPanelTab)child;
                tabIDs.add(child.getClientId(facesContext) + TAB_DIV_SUFFIX);
                if (this.isDisabled(facesContext, tab)) continue;
                headerIDs.add(this.getHeaderCellID(tab, facesContext));
            }
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("script", (UIComponent)tabbedPane);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write(10);
            writer.write(this.getHeaderCellsIDsVar(tabbedPane, facesContext) + "= new Array(");
            Iterator ids = headerIDs.iterator();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                writer.write('\"' + JavascriptUtils.encodeString(id) + '\"');
                if (!ids.hasNext()) continue;
                writer.write(44);
            }
            writer.write(");\n");
            writer.write(this.getTabsIDsVar(tabbedPane, facesContext) + "= new Array(");
            ids = tabIDs.iterator();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                writer.write('\"' + JavascriptUtils.encodeString(id) + '\"');
                if (!ids.hasNext()) continue;
                writer.write(44);
            }
            writer.write(");\n");
            writer.endElement("script");
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            String submitFieldIDAndName = this.getTabIndexSubmitFieldIDAndName(tabbedPane, facesContext);
            writer.startElement("input", (UIComponent)tabbedPane);
            writer.writeAttribute("id", (Object)submitFieldIDAndName, null);
            writer.writeAttribute("name", (Object)submitFieldIDAndName, null);
            writer.writeAttribute("style", (Object)"display:none", null);
            writer.endElement("input");
        }
        this.writeTableStart(writer, facesContext, tabbedPane);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)tabbedPane);
        writer.writeAttribute("class", (Object)HEADER_ROW_CLASS, null);
        int tabIdx = 0;
        int visibleTabCount = 0;
        int visibleTabSelectedIdx = -1;
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab)) continue;
            if (child.isRendered()) {
                this.writeHeaderCell(writer, facesContext, tabbedPane, (HtmlPanelTab)child, tabIdx, visibleTabCount, tabIdx == selectedIndex, this.isDisabled(facesContext, (HtmlPanelTab)child));
                if (tabIdx == selectedIndex) {
                    visibleTabSelectedIdx = visibleTabCount;
                }
                ++visibleTabCount;
            }
            ++tabIdx;
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", (UIComponent)tabbedPane);
        writer.writeAttribute("class", (Object)EMPTY_HEADER_CELL_CLASS, null);
        writer.write("&#160;");
        writer.endElement("td");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)tabbedPane);
        writer.writeAttribute("class", (Object)SUB_HEADER_ROW_CLASS, null);
        this.writeSubHeaderCells(writer, facesContext, tabbedPane, visibleTabCount, visibleTabSelectedIdx);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)tabbedPane);
        writer.writeAttribute("class", (Object)CONTENT_ROW_CLASS, null);
        writer.startElement("td", (UIComponent)tabbedPane);
        writer.writeAttribute("colspan", (Object)Integer.toString(visibleTabCount + 1), null);
        String tabContentStyleClass = tabbedPane.getTabContentStyleClass();
        writer.writeAttribute("class", (Object)(TAB_PANE_CLASS + (tabContentStyleClass == null ? "" : " " + tabContentStyleClass)), null);
        this.writeTabsContents(writer, facesContext, tabbedPane, selectedIndex);
        writer.endElement("td");
        writer.endElement("tr");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.endElement("table");
        if (parentFormInfo == null) {
            this.writeFormEnd(writer, facesContext);
        }
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String clientSideIndex;
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane == null ? (class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane = HtmlTabbedPaneRenderer.class$("org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane")) : class$org$apache$myfaces$custom$tabbedpane$HtmlPanelTabbedPane);
        HtmlPanelTabbedPane tabbedPane = (HtmlPanelTabbedPane)uiComponent;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        int tabIdx = 0;
        List children = tabbedPane.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab)) continue;
            String paramName = tabbedPane.getClientId(facesContext) + "." + tabIdx;
            String paramValue = (String)paramMap.get(paramName);
            if (paramValue != null && paramValue.length() > 0) {
                tabbedPane.queueEvent(new TabChangeEvent((UIComponent)tabbedPane, tabbedPane.getSelectedIndex(), tabIdx));
                return;
            }
            ++tabIdx;
        }
        if (tabbedPane.isClientSide() && (clientSideIndex = (String)paramMap.get(this.getTabIndexSubmitFieldIDAndName(tabbedPane, facesContext))) != null && clientSideIndex.length() > 0) {
            tabbedPane.setSelectedIndex(Integer.parseInt(clientSideIndex));
            return;
        }
    }

    protected void writeFormStart(ResponseWriter writer, FacesContext facesContext, UIComponent tabbedPane) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String actionURL = viewHandler.getActionURL(facesContext, viewId);
        writer.startElement("form", tabbedPane);
        writer.writeAttribute("name", (Object)(tabbedPane.getClientId(facesContext) + AUTO_FORM_SUFFIX), null);
        writer.writeAttribute("style", (Object)"display:inline", null);
        writer.writeAttribute("method", (Object)"post", null);
        writer.writeURIAttribute("action", (Object)facesContext.getExternalContext().encodeActionURL(actionURL), null);
        writer.flush();
    }

    protected String getHeaderCellsIDsVar(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return JavascriptUtils.getValidJavascriptName("panelTabbedPane_" + tabbedPane.getClientId(facesContext) + "_HeadersIDs", false);
    }

    protected String getTabsIDsVar(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return JavascriptUtils.getValidJavascriptName("panelTabbedPane_" + tabbedPane.getClientId(facesContext) + "_IDs", false);
    }

    protected String getDefaultActiveHeaderStyleClass(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return JavascriptUtils.getValidJavascriptName("panelTabbedPane_" + tabbedPane.getClientId(facesContext) + "_ActiveStyle", false);
    }

    protected String getHeaderClasses(HtmlPanelTabbedPane tabbedPane, HtmlPanelTab tab, String defaultClass, String userClass) {
        String headerCellClass = defaultClass;
        String userTabStyleClass = tab.getStyleClass();
        if (userClass != null) {
            headerCellClass = headerCellClass + " " + userClass;
        }
        if (userTabStyleClass != null) {
            headerCellClass = headerCellClass + " " + userTabStyleClass;
        }
        return headerCellClass;
    }

    protected void writeTableStart(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane) throws IOException {
        String oldBgColor = tabbedPane.getBgcolor();
        tabbedPane.setBgcolor(null);
        writer.startElement("table", (UIComponent)tabbedPane);
        writer.writeAttribute("id", (Object)this.getTableStylableId(tabbedPane, facesContext), null);
        String oldTabbedStyleClass = tabbedPane.getStyleClass();
        tabbedPane.setStyleClass(oldTabbedStyleClass == null ? "myFaces_panelTabbedPane" : "myFaces_panelTabbedPane " + oldTabbedStyleClass);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)tabbedPane, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
        tabbedPane.setBgcolor(oldBgColor);
        tabbedPane.setStyleClass(oldTabbedStyleClass);
    }

    protected String getTableStylableId(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        String originalID = tabbedPane.getClientId(facesContext);
        return originalID.replace(':', '_');
    }

    protected String getTabIndexSubmitFieldIDAndName(HtmlPanelTabbedPane tabbedPane, FacesContext facesContext) {
        return tabbedPane.getClientId(facesContext) + "_indexSubmit";
    }

    protected String getHeaderCellID(HtmlPanelTab tab, FacesContext facesContext) {
        return tab.getClientId(facesContext) + "_headerCell";
    }

    private String getSubHeaderCellID(HtmlPanelTab tab, FacesContext facesContext) {
        return tab.getClientId(facesContext) + "_headerCell_sub";
    }

    protected void writeHeaderCell(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, HtmlPanelTab tab, int tabIndex, int visibleTabIndex, boolean active, boolean disabled) throws IOException {
        String label;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", (UIComponent)tabbedPane);
        writer.writeAttribute("id", (Object)this.getHeaderCellID(tab, facesContext), null);
        if (disabled) {
            String disabledClass = tabbedPane.getDisabledTabStyleClass();
            writer.writeAttribute("class", (Object)(DISABLED_HEADER_CELL_CLASS + (disabledClass == null ? "" : ' ' + disabledClass)), null);
        } else if (active) {
            writer.writeAttribute("class", (Object)this.getHeaderClasses(tabbedPane, tab, ACTIVE_HEADER_CELL_CLASS, tabbedPane.getActiveTabStyleClass()), null);
        } else {
            writer.writeAttribute("class", (Object)this.getHeaderClasses(tabbedPane, tab, INACTIVE_HEADER_CELL_CLASS, tabbedPane.getInactiveTabStyleClass()), null);
        }
        if (tab.getStyle() != null) {
            writer.writeAttribute("style", (Object)tab.getStyle(), null);
        }
        if ((label = tab.getLabel()) == null || label.length() == 0) {
            label = "Tab " + tabIndex;
        }
        if (disabled) {
            writer.startElement("label", (UIComponent)tabbedPane);
            writer.writeText((Object)label, null);
            writer.endElement("label");
        } else {
            writer.startElement("input", (UIComponent)tabbedPane);
            writer.writeAttribute("type", (Object)"submit", null);
            writer.writeAttribute("name", (Object)(tabbedPane.getClientId(facesContext) + "." + tabIndex), null);
            writer.writeAttribute("value", (Object)label, null);
            if (tabbedPane.isClientSide()) {
                String onclickEvent;
                String activeUserClass = tabbedPane.getActiveTabStyleClass();
                String inactiveUserClass = tabbedPane.getInactiveTabStyleClass();
                String activeSubStyleUserClass = tabbedPane.getActiveSubStyleClass();
                String inactiveSubStyleUserClass = tabbedPane.getInactiveSubStyleClass();
                String string = onclickEvent = tab.getAttributes().get("onclick") != null ? (String)tab.getAttributes().get("onclick") : "";
                if (!"".equals(onclickEvent) && onclickEvent.charAt(onclickEvent.length() - 1) != ';') {
                    onclickEvent = onclickEvent + ";";
                }
                writer.writeAttribute("onclick", (Object)(onclickEvent + "return myFaces_showPanelTab(" + tabIndex + ",'" + this.getTabIndexSubmitFieldIDAndName(tabbedPane, facesContext) + "'," + '\'' + this.getHeaderCellID(tab, facesContext) + "','" + tab.getClientId(facesContext) + TAB_DIV_SUFFIX + "'," + this.getHeaderCellsIDsVar(tabbedPane, facesContext) + ',' + this.getTabsIDsVar(tabbedPane, facesContext) + ',' + (activeUserClass == null ? "null" : '\'' + activeUserClass + '\'') + ',' + (inactiveUserClass == null ? "null" : '\'' + inactiveUserClass + '\'') + ',' + (activeSubStyleUserClass == null ? "null" : '\'' + activeSubStyleUserClass + '\'') + ',' + (inactiveSubStyleUserClass == null ? "null" : '\'' + inactiveSubStyleUserClass + '\'') + ");"), null);
            }
            writer.endElement("input");
        }
        writer.endElement("td");
    }

    protected void writeSubHeaderCells(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, int visibleTabCount, int visibleTabSelectedIndex) throws IOException {
        String activeSubStyleUserClass = tabbedPane.getActiveSubStyleClass();
        String inactiveSubStyleUserClass = tabbedPane.getInactiveSubStyleClass();
        List children = tabbedPane.getChildren();
        StringBuffer classes = new StringBuffer();
        int len = children.size();
        int renderedIndex = 0;
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (!(child instanceof HtmlPanelTab) || !child.isRendered()) continue;
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            HtmlRendererUtils.writePrettyIndent(facesContext);
            writer.startElement("td", (UIComponent)tabbedPane);
            writer.writeAttribute("id", (Object)this.getSubHeaderCellID((HtmlPanelTab)child, facesContext), null);
            classes.setLength(0);
            classes.append(SUB_HEADER_CELL_CLASS);
            if (renderedIndex == 0) {
                classes.append(' ');
                classes.append(SUB_HEADER_CELL_CLASS_FIRST);
            }
            if (renderedIndex == visibleTabCount) {
                classes.append(' ');
                classes.append(SUB_HEADER_CELL_CLASS_LAST);
            }
            if (renderedIndex == visibleTabSelectedIndex) {
                if (activeSubStyleUserClass != null) {
                    classes.append(' ');
                    classes.append(activeSubStyleUserClass);
                }
            } else if (inactiveSubStyleUserClass != null) {
                classes.append(' ');
                classes.append(inactiveSubStyleUserClass);
            }
            classes.append(' ');
            classes.append(renderedIndex == visibleTabSelectedIndex ? SUB_HEADER_CELL_CLASS_ACTIVE : SUB_HEADER_CELL_CLASS_INACTIVE);
            writer.writeAttribute("class", (Object)classes.toString(), null);
            writer.write("&#160;");
            writer.endElement("td");
            ++renderedIndex;
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        HtmlRendererUtils.writePrettyIndent(facesContext);
        writer.startElement("td", (UIComponent)tabbedPane);
        writer.writeAttribute("class", (Object)("myFaces_panelTabbedPane_subHeaderCell myFaces_panelTabbedPane_subHeaderCell_last" + (inactiveSubStyleUserClass != null ? ' ' + inactiveSubStyleUserClass : "")), null);
        writer.write("&#160;");
        writer.endElement("td");
    }

    protected void writeTabsContents(ResponseWriter writer, FacesContext facesContext, HtmlPanelTabbedPane tabbedPane, int selectedIndex) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        int tabIdx = 0;
        List children = tabbedPane.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            UIComponent child = this.getUIComponent((UIComponent)children.get(i));
            if (child instanceof HtmlPanelTab) {
                String activeTabVar = tabbedPane.getActiveTabVar();
                if (activeTabVar != null) {
                    Map requestMap = facesContext.getExternalContext().getRequestMap();
                    requestMap.put(activeTabVar, tabIdx == selectedIndex);
                }
                HtmlPanelTab tab = (HtmlPanelTab)child;
                writer.startElement("div", (UIComponent)tabbedPane);
                writer.writeAttribute("id", (Object)(tab.getClientId(facesContext) + TAB_DIV_SUFFIX), null);
                if (tabIdx != selectedIndex) {
                    writer.writeAttribute("style", (Object)"display:none", null);
                }
                if (tabbedPane.isClientSide() || selectedIndex == tabIdx) {
                    RendererUtils.renderChild(facesContext, child);
                }
                writer.endElement("div");
                ++tabIdx;
                if (activeTabVar == null) continue;
                Map requestMap = facesContext.getExternalContext().getRequestMap();
                requestMap.remove(tabbedPane.getActiveTabVar());
                continue;
            }
            RendererUtils.renderChild(facesContext, child);
        }
    }

    private UIComponent getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UIForm || uiComponent instanceof UINamingContainer) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    protected void writeFormEnd(ResponseWriter writer, FacesContext facesContext) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        viewHandler.writeState(facesContext);
        writer.endElement("form");
    }

    protected boolean isDisabled(FacesContext facesContext, HtmlPanelTab tab) {
        return !UserRoleUtils.isEnabledOnUserRole((UIComponent)tab) || tab.isDisabled();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

