/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.taglib;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.custom.tree.HtmlTree;
import org.apache.myfaces.custom.tree.model.DefaultTreeModel;
import org.apache.myfaces.custom.tree.model.TreeModel;
import org.apache.myfaces.custom.tree.model.TreePath;
import org.apache.myfaces.shared_tomahawk.taglib.html.HtmlPanelGroupTag;

public class AbstractTreeTag
extends HtmlPanelGroupTag {
    private String value;
    private String expandRoot;

    public String getComponentType() {
        return "org.apache.myfaces.HtmlTree";
    }

    public String getRendererType() {
        return "org.apache.myfaces.HtmlTree";
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String isExpandRoot() {
        return this.expandRoot;
    }

    public void setExpandRoot(String expandRoot) {
        this.expandRoot = expandRoot;
    }

    public int doStartTag() throws JspException {
        TreeModel model;
        ValueBinding valueBinding;
        TreeModel treeModel;
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.value != null && (treeModel = (TreeModel)(valueBinding = context.getApplication().createValueBinding(this.value)).getValue(context)) == null) {
            treeModel = new DefaultTreeModel();
            valueBinding.setValue(context, (Object)treeModel);
        }
        int answer = super.doStartTag();
        HtmlTree tree = (HtmlTree)this.getComponentInstance();
        if (this.getCreated() && Boolean.parseBoolean(this.expandRoot) && (model = tree.getModel(context)) != null) {
            tree.expandPath(new TreePath(new Object[]{model.getRoot()}), context);
        }
        tree.addToModelListeners();
        return answer;
    }

    public void release() {
        super.release();
        this.value = null;
        this.expandRoot = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.value != null) {
            if (AbstractTreeTag.isValueReference((String)this.value)) {
                ValueBinding binding = context.getApplication().createValueBinding(this.value);
                component.setValueBinding("model", binding);
            }
        } else {
            ValueBinding binding = component.getValueBinding("model");
            if (binding == null) {
                binding = context.getApplication().createValueBinding("#{sessionScope.tree}");
            }
            component.setValueBinding("model", binding);
        }
    }
}

