/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class HTMLEncoder {
    private static final String HEX_CHARSET = "0123456789ABCDEF";
    private static final String UTF8 = "UTF-8";

    public static String encode(String string) {
        return HTMLEncoder.encode(string, false, true);
    }

    public static String encode(String string, boolean encodeNewline) {
        return HTMLEncoder.encode(string, encodeNewline, true);
    }

    public static String encode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp) {
        return HTMLEncoder.encode(string, encodeNewline, encodeSubsequentBlanksToNbsp, true);
    }

    public static String encode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            block0 : switch (c) {
                case '\"': {
                    app = "&quot;";
                    break;
                }
                case '&': {
                    app = "&amp;";
                    break;
                }
                case '<': {
                    app = "&lt;";
                    break;
                }
                case '>': {
                    app = "&gt;";
                    break;
                }
                case ' ': {
                    if (!encodeSubsequentBlanksToNbsp || i != 0 && (i - 1 < 0 || string.charAt(i - 1) != ' ')) break;
                    app = "&#160;";
                    break;
                }
                case '\n': {
                    if (!encodeNewline) break;
                    app = "<br/>";
                    break;
                }
                default: {
                    if (!encodeNonLatin) break;
                    switch (c) {
                        case '\u00e4': {
                            app = "&auml;";
                            break block0;
                        }
                        case '\u00c4': {
                            app = "&Auml;";
                            break block0;
                        }
                        case '\u00f6': {
                            app = "&ouml;";
                            break block0;
                        }
                        case '\u00d6': {
                            app = "&Ouml;";
                            break block0;
                        }
                        case '\u00fc': {
                            app = "&uuml;";
                            break block0;
                        }
                        case '\u00dc': {
                            app = "&Uuml;";
                            break block0;
                        }
                        case '\u00df': {
                            app = "&szlig;";
                            break block0;
                        }
                        case '\u20ac': {
                            app = "&euro;";
                            break block0;
                        }
                        case '\u00ab': {
                            app = "&laquo;";
                            break block0;
                        }
                        case '\u00bb': {
                            app = "&raquo;";
                            break block0;
                        }
                        case '\u00a0': {
                            app = "&#160;";
                            break block0;
                        }
                    }
                    if (c < '\u0080') break;
                    app = "&#" + c + ";";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuffer(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static String encodeURIAtributte(String string, String characterEncoding) throws IOException {
        StringBuilder sb = null;
        boolean endLoop = false;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c == '\"' || c == '<' || c == '>' || c == '\\' || c == '^' || c == '`' || c == '{' || c == '|' || c == '}') {
                app = HTMLEncoder.percentEncode(c, UTF8);
            } else if (c == '%') {
                if (i + 2 < string.length()) {
                    char c1 = string.charAt(i + 1);
                    char c2 = string.charAt(i + 2);
                    if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'Z') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z'))) {
                        app = HTMLEncoder.percentEncode(c, UTF8);
                    }
                } else {
                    app = HTMLEncoder.percentEncode(c, UTF8);
                }
            } else if ((c == '?' || c == '#') && i + 1 < string.length()) {
                app = c + HTMLEncoder.encodeURIQuery(string.substring(i + 1), characterEncoding);
                endLoop = true;
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
            } else if (sb != null) {
                sb.append(c);
            }
            if (endLoop) break;
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    private static String percentEncode(char c, String characterEncoding) {
        String app = null;
        app = c > '\u007f' ? HTMLEncoder.percentEncodeNonUsAsciiCharacter(c, characterEncoding) : "%" + HEX_CHARSET.charAt((c >> 4) % 16) + HEX_CHARSET.charAt(c % 16);
        return app;
    }

    private static String percentEncodeNonUsAsciiCharacter(char c, String characterEncoding) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10);
        StringBuffer builder = new StringBuffer();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, characterEncoding);
            writer.write(c);
            writer.flush();
        }
        catch (IOException e) {
            baos.reset();
            return null;
        }
        byte[] byteArray = baos.toByteArray();
        for (int i = 0; i < byteArray.length; ++i) {
            builder.append('%');
            builder.append(HEX_CHARSET.charAt((((short)byteArray[i] & 0xFF) >> 4) % 16));
            builder.append(HEX_CHARSET.charAt(((short)byteArray[i] & 0xFF) % 16));
        }
        return builder.toString();
    }

    private static String encodeURIQuery(String string, String characterEncoding) {
        StringBuilder sb = null;
        boolean endLoop = false;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c == '\"' || c == '<' || c == '>' || c == '\\' || c == '^' || c == '`' || c == '{' || c == '|' || c == '}') {
                app = HTMLEncoder.percentEncode(c, characterEncoding);
            } else if (c == '%') {
                if (i + 2 < string.length()) {
                    char c1 = string.charAt(i + 1);
                    char c2 = string.charAt(i + 2);
                    if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'Z') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z'))) {
                        app = HTMLEncoder.percentEncode(c, characterEncoding);
                    }
                } else {
                    app = HTMLEncoder.percentEncode(c, characterEncoding);
                }
            } else if (c == '&') {
                if (i + 4 < string.length()) {
                    if ('a' != string.charAt(i + 1) || 'm' != string.charAt(i + 2) || 'p' != string.charAt(i + 3) || ';' != string.charAt(i + 4)) {
                        app = "&amp;";
                    }
                } else {
                    app = "&amp;";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
            } else if (sb != null) {
                sb.append(c);
            }
            if (endLoop) break;
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }
}

