/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.custom.newspaper;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.component.UIComponent;


// Generated from class org.apache.myfaces.custom.newspaper.AbstractHtmlNewspaperTable.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlNewspaperTable extends org.apache.myfaces.custom.newspaper.AbstractHtmlNewspaperTable
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Data";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlNewspaperTable";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.HtmlNewspaperTable";


    public HtmlNewspaperTable()
    {
        setRendererType("org.apache.myfaces.HtmlNewspaperTable");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }



    
    // Property: newspaperColumns
    public int getNewspaperColumns()
    {
        return (Integer) getStateHelper().eval(PropertyKeys.newspaperColumns, 1);
    }
    
    public void setNewspaperColumns(int newspaperColumns)
    {
        getStateHelper().put(PropertyKeys.newspaperColumns, newspaperColumns ); 
    }    
    // Property: newspaperOrientation
    public String getNewspaperOrientation()
    {
        return (String) getStateHelper().eval(PropertyKeys.newspaperOrientation);
    }
    
    public void setNewspaperOrientation(String newspaperOrientation)
    {
        getStateHelper().put(PropertyKeys.newspaperOrientation, newspaperOrientation ); 
    }    
    // Property: datafld
    public String getDatafld()
    {
        return (String) getStateHelper().eval(PropertyKeys.datafld);
    }
    
    public void setDatafld(String datafld)
    {
        getStateHelper().put(PropertyKeys.datafld, datafld ); 
    }    
    // Property: datasrc
    public String getDatasrc()
    {
        return (String) getStateHelper().eval(PropertyKeys.datasrc);
    }
    
    public void setDatasrc(String datasrc)
    {
        getStateHelper().put(PropertyKeys.datasrc, datasrc ); 
    }    
    // Property: dataformatas
    public String getDataformatas()
    {
        return (String) getStateHelper().eval(PropertyKeys.dataformatas);
    }
    
    public void setDataformatas(String dataformatas)
    {
        getStateHelper().put(PropertyKeys.dataformatas, dataformatas ); 
    }    
    // Property: align
    public String getAlign()
    {
        return (String) getStateHelper().eval(PropertyKeys.align);
    }
    
    public void setAlign(String align)
    {
        getStateHelper().put(PropertyKeys.align, align ); 
    }    

    protected enum PropertyKeys
    {
         newspaperColumns
        , newspaperOrientation
        , datafld
        , datasrc
        , dataformatas
        , align
    }

 }
