/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.custom.sortheader;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.component.UIComponent;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;


// Generated from class org.apache.myfaces.custom.sortheader.AbstractHtmlCommandSortHeader.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlCommandSortHeader extends org.apache.myfaces.custom.sortheader.AbstractHtmlCommandSortHeader
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Command";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlCommandSortHeader";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.SortHeader";


    public HtmlCommandSortHeader()
    {
        setRendererType("org.apache.myfaces.SortHeader");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }



    
    // Property: columnName
    public String getColumnName()
    {
        return (String) getStateHelper().eval(PropertyKeys.columnName);
    }
    
    public void setColumnName(String columnName)
    {
        getStateHelper().put(PropertyKeys.columnName, columnName ); 
    }    
    // Property: propertyName
    public String getPropertyName()
    {
        return (String) getStateHelper().eval(PropertyKeys.propertyName);
    }
    
    public void setPropertyName(String propertyName)
    {
        getStateHelper().put(PropertyKeys.propertyName, propertyName ); 
    }    
    // Property: arrow
    public boolean isArrow()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.arrow, false);
    }
    
    public void setArrow(boolean arrow)
    {
        getStateHelper().put(PropertyKeys.arrow, arrow ); 
    }    

    protected enum PropertyKeys
    {
         columnName
        , propertyName
        , arrow
    }

 }
