/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.captcha;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.custom.captcha.CAPTCHAResource;
import org.apache.myfaces.custom.captcha.util.CAPTCHAImageGenerator;
import org.apache.myfaces.custom.captcha.util.CAPTCHATextGenerator;
import org.apache.myfaces.custom.captcha.util.ColorGenerator;
import org.apache.myfaces.shared_tomahawk.resource.ResourceHandlerSupport;
import org.apache.myfaces.tomahawk.application.DefaultResourceHandlerSupport;

public class CAPTCHAResourceHandlerWrapper
extends ResourceHandlerWrapper {
    public static final String CAPTCHA_LIBRARY = "oam.custom.captcha";
    private ResourceHandler _delegate;
    private ResourceHandlerSupport _resourceHandlerSupport;

    public CAPTCHAResourceHandlerWrapper(ResourceHandler delegate) {
        this._delegate = delegate;
    }

    public ResourceHandler getWrapped() {
        return this._delegate;
    }

    public Resource createResource(String resourceName, String libraryName) {
        if (libraryName != null && CAPTCHA_LIBRARY.equals(libraryName)) {
            return this.internalCreateResource(resourceName, libraryName);
        }
        return super.createResource(resourceName, libraryName);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        if (libraryName != null && CAPTCHA_LIBRARY.equals(libraryName)) {
            return this.internalCreateResource(resourceName, libraryName);
        }
        return super.createResource(resourceName, libraryName, contentType);
    }

    private Resource internalCreateResource(String resourceName, String libraryName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.isResourceRequest(facesContext)) {
            Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
            String captchaSessionKeyName = ((String)requestMap.get("captchaSessionKeyName")).toString();
            return new CAPTCHAResource(this.getResourceHandlerSupport(), captchaSessionKeyName, resourceName);
        }
        String captchaSessionKeyName = (String)facesContext.getAttributes().get("captchaSessionKeyName");
        return new CAPTCHAResource(this.getResourceHandlerSupport(), captchaSessionKeyName, resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String libraryName = (String)requestMap.get("ln");
        if (libraryName != null && CAPTCHA_LIBRARY.equals(libraryName)) {
            String captchaSessionKeyName = ((String)requestMap.get("captchaSessionKeyName")).toString();
            String resourceBasePath = this.getResourceHandlerSupport().calculateResourceBasePath(facesContext);
            Object response = facesContext.getExternalContext().getResponse();
            HttpServletResponse httpServletResponse = CAPTCHAResourceHandlerWrapper.getHttpServletResponse(response);
            String resourceName = null;
            if (!resourceBasePath.startsWith("/javax.faces.resource")) {
                httpServletResponse.setStatus(404);
                return;
            }
            resourceName = resourceBasePath.substring("/javax.faces.resource".length() + 1);
            if (captchaSessionKeyName == null) {
                httpServletResponse.setStatus(404);
                return;
            }
            Resource resource = null;
            resource = libraryName != null ? facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName) : facesContext.getApplication().getResourceHandler().createResource(resourceName);
            if (resource == null) {
                httpServletResponse.setStatus(404);
                return;
            }
            if (!resource.userAgentNeedsUpdate(facesContext)) {
                httpServletResponse.setStatus(304);
                return;
            }
            httpServletResponse.setContentType(resource.getContentType());
            Map headers = resource.getResponseHeaders();
            for (Map.Entry entry : headers.entrySet()) {
                httpServletResponse.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
            try {
                CAPTCHAImageGenerator captchaImageGenerator = new CAPTCHAImageGenerator();
                ServletOutputStream out = httpServletResponse.getOutputStream();
                try {
                    Color endingColor = ColorGenerator.generateRandomColor(null);
                    Color startingColor = ColorGenerator.generateRandomColor(endingColor);
                    String captchaText = CAPTCHATextGenerator.generateRandomText();
                    facesContext.getExternalContext().getSessionMap().put(captchaSessionKeyName, captchaText);
                    captchaImageGenerator.generateImage((OutputStream)out, captchaText, startingColor, endingColor);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                Logger log = Logger.getLogger(CAPTCHAResourceHandlerWrapper.class.getName());
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe("Error trying to load resource " + resourceName + " with library " + libraryName + " :" + e.getMessage());
                }
                httpServletResponse.setStatus(404);
            }
        } else {
            super.handleResourceRequest(facesContext);
        }
    }

    public boolean libraryExists(String libraryName) {
        if (libraryName != null && CAPTCHA_LIBRARY.equals(libraryName)) {
            return true;
        }
        return super.libraryExists(libraryName);
    }

    public void setResourceHandlerSupport(ResourceHandlerSupport resourceHandlerSupport) {
        this._resourceHandlerSupport = resourceHandlerSupport;
    }

    protected ResourceHandlerSupport getResourceHandlerSupport() {
        if (this._resourceHandlerSupport == null) {
            this._resourceHandlerSupport = new DefaultResourceHandlerSupport();
        }
        return this._resourceHandlerSupport;
    }

    private static HttpServletResponse getHttpServletResponse(Object response) {
        if (response != null) {
            if (response instanceof HttpServletResponse) {
                return (HttpServletResponse)response;
            }
            if (response instanceof ServletResponseWrapper) {
                response = ((ServletResponseWrapper)response).getResponse();
            }
        }
        return null;
    }
}

