/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.NewspaperTable;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.ext.HtmlDataTableHack;
import org.apache.myfaces.component.html.ext.SortCriterion;
import org.apache.myfaces.component.html.ext.SortableModel;
import org.apache.myfaces.component.html.ext.UIComponentPerspective;
import org.apache.myfaces.component.html.ext._DetailStampFacetAndChildrenIterator;
import org.apache.myfaces.component.html.ext._SerializableArrayDataModel;
import org.apache.myfaces.component.html.ext._SerializableDataModel;
import org.apache.myfaces.component.html.ext._SerializableListDataModel;
import org.apache.myfaces.component.html.ext._SerializableResultDataModel;
import org.apache.myfaces.component.html.ext._SerializableResultSetDataModel;
import org.apache.myfaces.component.html.ext._SerializableScalarDataModel;
import org.apache.myfaces.custom.column.HtmlSimpleColumn;
import org.apache.myfaces.custom.crosstable.UIColumns;
import org.apache.myfaces.custom.sortheader.HtmlCommandSortHeader;
import org.apache.myfaces.renderkit.html.util.TableContext;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHtmlDataTable
extends HtmlDataTableHack
implements UserRoleAware,
NewspaperTable {
    private static final Log log = LogFactory.getLog(AbstractHtmlDataTable.class);
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private static final boolean DEFAULT_SORTASCENDING = true;
    private static final boolean DEFAULT_SORTABLE = false;
    private static final boolean DEFAULT_EMBEDDED = false;
    private static final boolean DEFAULT_DETAILSTAMP_EXPANDED = false;
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final Integer DEFAULT_NEWSPAPER_COLUMNS = new Integer(1);
    private static final String DEFAULT_NEWSPAPER_ORIENTATION = "vertical";
    private static final String DEFAULT_DETAILSTAMP_LOCATION = "after";
    private static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    public static final String NEWSPAPER_COLUMNS_PROPERTY = "newspaperColumns";
    public static final String SPACER_FACET_NAME = "spacer";
    public static final String NEWSPAPER_ORIENTATION_PROPERTY = "newspaperOrientation";
    public static final String DETAIL_STAMP_FACET_NAME = "detailStamp";
    public static final String DETAIL_STAMP_ROW_FACET_NAME = "detailStampRow";
    public static final String TABLE_ROW_FACET_NAME = "row";
    private _SerializableDataModel _preservedDataModel;
    private boolean _isValidChildren = true;
    private Map<String, Boolean> _expandedNodes = new HashMap<String, Boolean>();
    private TableContext _tableContext = null;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataTable";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Table";
    private static final boolean DEFAULT_PRESERVEDATAMODEL = false;
    private static final boolean DEFAULT_PRESERVESORT = true;
    private static final boolean DEFAULT_RENDEREDIFEMPTY = true;

    public TableContext getTableContext() {
        if (this._tableContext == null) {
            this._tableContext = new TableContext();
        }
        return this._tableContext;
    }

    public void setDetailStamp(UIComponent facet) {
        this.getFacets().put(DETAIL_STAMP_FACET_NAME, facet);
    }

    public UIComponent getDetailStamp() {
        return (UIComponent)this.getFacets().get(DETAIL_STAMP_FACET_NAME);
    }

    @Override
    public String getContainerClientId(FacesContext context) {
        String standardClientId = super.getContainerClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return standardClientId;
        }
        String forcedIdIndex = this.getForceIdIndexFormula();
        if (forcedIdIndex == null || forcedIdIndex.length() == 0) {
            return standardClientId;
        }
        String indexLessClientId = this.getClientId(context);
        String parsedForcedClientId = indexLessClientId + forcedIdIndex;
        return parsedForcedClientId;
    }

    public UIComponent findComponent(String expr) {
        if (expr.length() > 0 && Character.isDigit(expr.charAt(0))) {
            char separator = UINamingContainer.getSeparatorChar((FacesContext)this.getFacesContext());
            int separatorIndex = expr.indexOf(separator);
            String rowIndexStr = expr;
            String remainingPart = null;
            if (separatorIndex != -1) {
                rowIndexStr = expr.substring(0, separatorIndex);
                remainingPart = expr.substring(separatorIndex + 1);
            }
            int rowIndex = Integer.valueOf(rowIndexStr);
            if (remainingPart == null) {
                log.error((Object)("Wrong syntax of expression : " + expr + " rowIndex was provided, but no component name."));
                return null;
            }
            UIComponent comp = super.findComponent(remainingPart);
            if (comp == null) {
                return null;
            }
            UIComponentPerspective perspective = new UIComponentPerspective((UIData)this, comp, rowIndex);
            return perspective;
        }
        return super.findComponent(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (context == null) throw new NullPointerException();
        if (clientId == null) throw new NullPointerException();
        if (callback == null) {
            throw new NullPointerException();
        }
        String baseClientId = this.getClientId(context);
        boolean returnValue = baseClientId.equals(clientId);
        this.pushComponentToEL(context, (UIComponent)this);
        try {
            if (returnValue) {
                try {
                    callback.invokeContextCallback(context, (UIComponent)this);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
            Iterator it2 = this.getFacets().values().iterator();
            while (!returnValue && it2.hasNext()) {
                returnValue = ((UIComponent)it2.next()).invokeOnComponent(context, clientId, callback);
            }
            if (returnValue) {
                boolean it2 = returnValue;
                return it2;
            }
            if (!clientId.startsWith(baseClientId)) return returnValue;
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            ValueExpression rowKeyVE = this.getValueExpression("rowKey");
            boolean rowKeyFound = false;
            if (rowKeyVE != null) {
                int oldRow = this.getRowIndex();
                try {
                    int rowsToProcess = this.getRows();
                    if (rowsToProcess == 0) {
                        rowsToProcess = this.getRowCount();
                    }
                    int rowIndex = this.getFirst();
                    for (int rowsProcessed = 0; rowsProcessed < rowsToProcess; ++rowsProcessed, ++rowIndex) {
                        this.setRowIndex(rowIndex);
                        if (!this.isRowAvailable()) break;
                        if (!clientId.startsWith(this.getContainerClientId(context))) continue;
                        rowKeyFound = true;
                        break;
                    }
                    if (rowKeyFound) {
                        returnValue = this.invokeOnComponentTraverseRow(context, clientId, callback);
                    }
                }
                finally {
                    this.setRowIndex(oldRow);
                }
            }
            if (rowKeyVE == null && clientId.matches(baseClientId + separator + "[0-9]+" + separator + ".*")) {
                String subId = clientId.substring(baseClientId.length() + 1);
                String clientRow = subId.substring(0, subId.indexOf(separator));
                int oldRow = this.getRowIndex();
                try {
                    this.setRowIndex(Integer.parseInt(clientRow));
                    if (!this.isRowAvailable()) {
                        boolean bl = false;
                        return bl;
                    }
                    returnValue = this.invokeOnComponentTraverseRow(context, clientId, callback);
                    return returnValue;
                }
                finally {
                    this.setRowIndex(oldRow);
                }
            }
            if (rowKeyFound) return returnValue;
            Iterator itChildren = this.getChildren().iterator();
            block19: while (true) {
                if (returnValue) return returnValue;
                if (!itChildren.hasNext()) return returnValue;
                UIComponent child = (UIComponent)itChildren.next();
                if (child instanceof UIColumn && clientId.equals(child.getClientId(context))) {
                    try {
                        callback.invokeContextCallback(context, child);
                    }
                    catch (Exception e) {
                        throw new FacesException((Throwable)e);
                    }
                    returnValue = true;
                }
                Iterator itChildFacets = child.getFacets().values().iterator();
                while (true) {
                    if (returnValue || !itChildFacets.hasNext()) continue block19;
                    returnValue = ((UIComponent)itChildFacets.next()).invokeOnComponent(context, clientId, callback);
                }
                break;
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    private boolean invokeOnComponentTraverseRow(FacesContext context, String clientId, ContextCallback callback) {
        boolean returnValue = false;
        Iterator it1 = this.getChildren().iterator();
        while (!returnValue && it1.hasNext()) {
            returnValue = ((UIComponent)it1.next()).invokeOnComponent(context, clientId, callback);
        }
        if (!returnValue) {
            UIComponent tableRowFacet;
            UIComponent detailStampFacet;
            UIComponent detailStampRowFacet = this.getFacet(DETAIL_STAMP_ROW_FACET_NAME);
            if (detailStampRowFacet != null) {
                returnValue = detailStampRowFacet.invokeOnComponent(context, clientId, callback);
            }
            if ((detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
                returnValue = detailStampFacet.invokeOnComponent(context, clientId, callback);
            }
            if ((tableRowFacet = this.getFacet(TABLE_ROW_FACET_NAME)) != null) {
                returnValue = tableRowFacet.invokeOnComponent(context, clientId, callback);
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block33: {
            if (!this.isVisitable(context)) {
                return false;
            }
            int oldRowIndex = this.getRowIndex();
            this.setRowIndex(-1);
            this.pushComponentToEL(context.getFacesContext(), (UIComponent)this);
            try {
                boolean doVisitChildren;
                VisitResult visitResult = context.invokeVisitCallback((UIComponent)this, callback);
                switch (visitResult) {
                    case COMPLETE: {
                        boolean bl = true;
                        return bl;
                    }
                    case REJECT: {
                        boolean bl = false;
                        return bl;
                    }
                }
                Collection subtreeIdsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
                boolean bl = doVisitChildren = subtreeIdsToVisit != null && !subtreeIdsToVisit.isEmpty();
                if (!doVisitChildren) break block33;
                for (UIComponent facet : this.getFacets().values()) {
                    if (!facet.visitTree(context, callback)) continue;
                    boolean bl2 = true;
                    return bl2;
                }
                Boolean skipIterationHint = (Boolean)context.getFacesContext().getAttributes().get(SKIP_ITERATION_HINT);
                if (skipIterationHint != null && skipIterationHint.booleanValue()) {
                    if (this.getChildCount() <= 0) break block33;
                    for (UIComponent child : this.getChildren()) {
                        if (!child.visitTree(context, callback)) continue;
                        boolean bl3 = true;
                        return bl3;
                    }
                    break block33;
                }
                for (UIComponent child : this.getChildren()) {
                    if (!(child instanceof UIColumn)) continue;
                    VisitResult columnResult = context.invokeVisitCallback(child, callback);
                    if (columnResult == VisitResult.COMPLETE) {
                        boolean bl4 = true;
                        return bl4;
                    }
                    for (UIComponent facet : child.getFacets().values()) {
                        if (!facet.visitTree(context, callback)) continue;
                        boolean bl5 = true;
                        return bl5;
                    }
                }
                boolean visitDetailStamp = this.getFacet(DETAIL_STAMP_FACET_NAME) != null;
                boolean visitDetailStampRow = this.getFacet(DETAIL_STAMP_ROW_FACET_NAME) != null;
                boolean visitTableRow = this.getFacet(TABLE_ROW_FACET_NAME) != null;
                int rowsToProcess = this.getRows();
                if (rowsToProcess == 0) {
                    rowsToProcess = this.getRowCount();
                }
                int rowIndex = this.getFirst();
                int rowsProcessed = 0;
                while (rowsProcessed < rowsToProcess) {
                    UIComponent tableRowFacet;
                    UIComponent detailStampFacet;
                    UIComponent detailStampRowFacet;
                    this.setRowIndex(rowIndex);
                    if (!this.isRowAvailable()) {
                        boolean bl6 = false;
                        return bl6;
                    }
                    for (UIComponent child : this.getChildren()) {
                        if (!(child instanceof UIColumn)) continue;
                        for (UIComponent grandchild : child.getChildren()) {
                            if (!grandchild.visitTree(context, callback)) continue;
                            boolean bl7 = true;
                            return bl7;
                        }
                    }
                    if (visitDetailStampRow && (detailStampRowFacet = this.getFacet(DETAIL_STAMP_ROW_FACET_NAME)).visitTree(context, callback)) {
                        boolean bl8 = true;
                        return bl8;
                    }
                    if (visitDetailStamp && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)).visitTree(context, callback)) {
                        boolean bl9 = true;
                        return bl9;
                    }
                    if (visitTableRow && (tableRowFacet = this.getFacet(TABLE_ROW_FACET_NAME)).visitTree(context, callback)) {
                        boolean bl10 = true;
                        return bl10;
                    }
                    ++rowsProcessed;
                    ++rowIndex;
                }
            }
            finally {
                this.popComponentFromEL(context.getFacesContext());
                this.setRowIndex(oldRowIndex);
            }
        }
        return false;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        UIComponent tableRowFacet;
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        String previousRowDataVar = this.getPreviousRowDataVar();
        if (rowIndexVar != null || rowCountVar != null || previousRowDataVar != null) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (previousRowDataVar != null && rowIndex >= 0) {
                if (this.isRowAvailable()) {
                    requestMap.put(previousRowDataVar, this.getRowData());
                } else {
                    requestMap.put(previousRowDataVar, null);
                }
            }
            super.setRowIndex(rowIndex);
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(rowIndexVar, new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(rowCountVar, new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(rowIndexVar);
                }
                if (rowCountVar != null) {
                    requestMap.remove(rowCountVar);
                }
                if (previousRowDataVar != null) {
                    requestMap.remove(previousRowDataVar);
                }
            }
        } else {
            super.setRowIndex(rowIndex);
        }
        UIComponent detailStampRowFacet = this.getFacet(DETAIL_STAMP_ROW_FACET_NAME);
        if (detailStampRowFacet != null) {
            detailStampRowFacet.setId(detailStampRowFacet.getId());
        }
        if ((tableRowFacet = this.getFacet(TABLE_ROW_FACET_NAME)) != null) {
            tableRowFacet.setId(tableRowFacet.getId());
        }
        if (this.getStateHelper().get((Serializable)((Object)PropertyKeys.varDetailToggler)) != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            requestMap.put(this.getStateHelper().get((Serializable)((Object)PropertyKeys.varDetailToggler)), this);
        }
    }

    @Override
    protected Object saveDescendantComponentStates() {
        UIComponent detailStampFacet;
        if (this.getFacetCount() > 0 && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            return this.saveDescendantComponentStates(new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), false);
        }
        return super.saveDescendantComponentStates();
    }

    @Override
    protected void restoreDescendantComponentStates(Object state) {
        UIComponent detailStampFacet;
        if (this.getFacetCount() > 0 && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            this.restoreDescendantComponentStates(new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), state, false);
            return;
        }
        super.restoreDescendantComponentStates(state);
    }

    @Override
    protected void restoreFullDescendantComponentDeltaStates(FacesContext facesContext, Map<String, Object> rowState, Object initialState) {
        UIComponent detailStampFacet;
        if (this.getFacetCount() > 0 && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            this.restoreFullDescendantComponentDeltaStates(facesContext, new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), rowState, initialState, false, this.getContainerClientId(facesContext));
            return;
        }
        super.restoreFullDescendantComponentDeltaStates(facesContext, rowState, initialState);
    }

    @Override
    protected void restoreFullDescendantComponentStates(FacesContext facesContext, Object initialState) {
        UIComponent detailStampFacet;
        if (this.getFacetCount() > 0 && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            this.restoreFullDescendantComponentStates(facesContext, new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), initialState, false);
            return;
        }
        super.restoreFullDescendantComponentStates(facesContext, initialState);
    }

    @Override
    protected Collection<Object[]> saveDescendantInitialComponentStates(FacesContext facesContext) {
        UIComponent detailStampFacet;
        if (this.getFacetCount() > 0 && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            return this.saveDescendantInitialComponentStates(facesContext, new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), false);
        }
        return super.saveDescendantInitialComponentStates(facesContext);
    }

    @Override
    protected Map<String, Object> saveFullDescendantComponentStates(FacesContext facesContext) {
        UIComponent detailStampFacet;
        if (this.getFacetCount() > 0 && (detailStampFacet = this.getFacet(DETAIL_STAMP_FACET_NAME)) != null) {
            return this.saveFullDescendantComponentStates(facesContext, null, new _DetailStampFacetAndChildrenIterator(detailStampFacet, this.getChildren()), false, this.getContainerClientId(facesContext));
        }
        return super.saveFullDescendantComponentStates(facesContext);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 1);
        this.processColumnFacets(context, 1);
        this.processColumnChildren(context, 1);
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.setRowIndex(-1);
        this.processColumns(context, 1);
        this.setRowIndex(-1);
        this.processDetails(context, 1);
        this.setRowIndex(-1);
    }

    private void processFacets(FacesContext context, int processAction) {
        for (Map.Entry entry : this.getFacets().entrySet()) {
            if (DETAIL_STAMP_FACET_NAME.equals(entry.getKey())) continue;
            this.process(context, (UIComponent)entry.getValue(), processAction);
        }
    }

    private void processColumnFacets(FacesContext context, int processAction) {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIColumn) || !child.isRendered()) continue;
            for (UIComponent facet : child.getFacets().values()) {
                this.process(context, facet, processAction);
            }
        }
    }

    private void processColumnChildren(FacesContext context, int processAction) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIColumn) || !child.isRendered()) continue;
                for (UIComponent columnChild : child.getChildren()) {
                    this.process(context, columnChild, processAction);
                }
            }
        }
    }

    private void processDetails(FacesContext context, int processAction) {
        UIComponent facet = this.getFacet(DETAIL_STAMP_FACET_NAME);
        if (facet != null) {
            int first = this.getFirst();
            int rows = this.getRows();
            int last = rows == 0 ? this.getRowCount() : first + rows;
            for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
                this.setRowIndex(rowIndex);
                if (!this.isRowAvailable()) break;
                if (!this.isCurrentDetailExpanded()) continue;
                if (1 == processAction) {
                    this.resetAllSubmittedValues(facet);
                }
                this.process(context, facet, processAction);
            }
        }
    }

    private void resetAllSubmittedValues(UIComponent component) {
        if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setSubmittedValue(null);
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            this.resetAllSubmittedValues((UIComponent)it.next());
        }
    }

    private void processColumns(FacesContext context, int processAction) {
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIColumns)) continue;
            this.process(context, child, processAction);
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 2);
        this.processColumnFacets(context, 2);
        this.processColumnChildren(context, 2);
        this.setRowIndex(-1);
        this.processColumns(context, 2);
        this.setRowIndex(-1);
        this.processDetails(context, 2);
        this.setRowIndex(-1);
        if (context.getRenderResponse()) {
            this._isValidChildren = false;
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 3);
        this.processColumnFacets(context, 3);
        this.processColumnChildren(context, 3);
        this.setRowIndex(-1);
        this.processColumns(context, 3);
        this.setRowIndex(-1);
        this.processDetails(context, 3);
        this.setRowIndex(-1);
        if (this.isPreserveDataModel()) {
            this.updateModelFromPreservedDataModel(context);
        }
        if (context.getRenderResponse()) {
            this._isValidChildren = false;
        }
    }

    private void updateModelFromPreservedDataModel(FacesContext context) {
        DataModel qdm;
        ValueExpression vb = this.getValueExpression("value");
        if (vb != null && !vb.isReadOnly(context.getELContext()) && (qdm = this.getDataModel()) instanceof _SerializableDataModel) {
            _SerializableDataModel dm = (_SerializableDataModel)qdm;
            Class type = this.getValueType() == null ? vb.getType(context.getELContext()) : ClassUtils.simpleClassForName(this.getValueType());
            Class<?> dmType = dm.getClass();
            if (DataModel.class.isAssignableFrom(type)) {
                vb.setValue(context.getELContext(), (Object)dm);
            } else if (List.class.isAssignableFrom(type) || _SerializableListDataModel.class.isAssignableFrom(dmType)) {
                vb.setValue(context.getELContext(), dm.getWrappedData());
            } else if (OBJECT_ARRAY_CLASS.isAssignableFrom(type)) {
                List lst = (List)dm.getWrappedData();
                vb.setValue(context.getELContext(), (Object)lst.toArray(new Object[lst.size()]));
            } else {
                if (ResultSet.class.isAssignableFrom(type)) {
                    throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
                }
                List lst = (List)dm.getWrappedData();
                if (lst != null && lst.size() > 0) {
                    vb.setValue(context.getELContext(), lst.get(0));
                } else {
                    vb.setValue(context.getELContext(), null);
                }
            }
        }
        this._preservedDataModel = null;
    }

    @Override
    public void markInitialState() {
        if ((this.isPreserveRowComponentState() || this.isRowStatePreserved()) && this.getFacesContext().getAttributes().containsKey("javax.faces.view.ViewDeclarationLanguage.IS_BUILDING_INITIAL_STATE")) {
            this.replaceColumnsWithCommandSortHeadersIfNeeded(this.getFacesContext());
        }
        super.markInitialState();
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this._isValidChildren && !this.hasErrorMessages(context)) {
            this._preservedDataModel = null;
        }
        for (UIComponent component : this.getChildren()) {
            if (!(component instanceof UIColumns)) continue;
            ((UIColumns)component).encodeTableBegin(context);
        }
        this.replaceColumnsWithCommandSortHeadersIfNeeded(context);
        super.encodeBegin(context);
    }

    private void replaceColumnsWithCommandSortHeadersIfNeeded(FacesContext context) {
        for (UIComponent component : this.getChildren()) {
            HtmlCommandSortHeader sortHeader;
            if (!(component instanceof UIColumn)) continue;
            UIColumn aColumn = (UIColumn)component;
            Object headerFacet = aColumn.getHeader();
            boolean replaceHeaderFacets = this.isSortable();
            String columnName = null;
            String propertyName = null;
            boolean defaultSorted = false;
            if (aColumn instanceof HtmlSimpleColumn) {
                HtmlSimpleColumn asColumn = (HtmlSimpleColumn)aColumn;
                propertyName = asColumn.getSortPropertyName();
                defaultSorted = asColumn.isDefaultSorted();
                if (asColumn.isSortable()) {
                    replaceHeaderFacets = true;
                }
            }
            if (replaceHeaderFacets && this.isSortHeaderNeeded(aColumn, (UIComponent)headerFacet)) {
                String string = propertyName = propertyName != null ? propertyName : this.getSortPropertyFromEL((UIComponent)aColumn);
                if (propertyName == null) {
                    log.warn((Object)("Couldn't determine sort property for column [" + aColumn.getId() + "]."));
                }
                if (headerFacet instanceof UIPanel) {
                    sortHeader = null;
                    for (UIComponent childHeaderFacet : headerFacet.getChildren()) {
                        if (!(childHeaderFacet instanceof HtmlCommandSortHeader)) continue;
                        sortHeader = (HtmlCommandSortHeader)childHeaderFacet;
                        break;
                    }
                    if (sortHeader != null) {
                        aColumn.getFacets().remove("header");
                        aColumn.setHeader((UIComponent)sortHeader);
                        headerFacet = sortHeader;
                        columnName = sortHeader.getColumnName();
                        propertyName = sortHeader.getPropertyName();
                        if (propertyName == null) {
                            propertyName = this.getSortPropertyFromEL((UIComponent)aColumn);
                            sortHeader.setPropertyName(propertyName);
                        }
                        if (propertyName == null) {
                            log.warn((Object)("Couldn't determine sort property for column [" + aColumn.getId() + "]."));
                        }
                    }
                }
                if (headerFacet != null && this.isSortHeaderNeeded(aColumn, (UIComponent)headerFacet)) {
                    aColumn.getFacets().remove("header");
                    sortHeader = this.createSortHeaderComponent(context, aColumn, (UIComponent)headerFacet, propertyName);
                    columnName = sortHeader.getColumnName();
                    aColumn.setHeader((UIComponent)sortHeader);
                }
            } else if (headerFacet instanceof HtmlCommandSortHeader) {
                sortHeader = (HtmlCommandSortHeader)headerFacet;
                columnName = sortHeader.getColumnName();
                propertyName = sortHeader.getPropertyName();
                if (propertyName == null) {
                    propertyName = this.getSortPropertyFromEL((UIComponent)aColumn);
                    sortHeader.setPropertyName(propertyName);
                }
                if (propertyName == null) {
                    log.warn((Object)("Couldn't determine sort property for column [" + aColumn.getId() + "]."));
                }
            }
            String sortColumn = this.getSortColumn();
            if (!defaultSorted || sortColumn != null && sortColumn.length() != 0) continue;
            this.setSortColumn(columnName);
            this.setSortProperty(propertyName);
        }
    }

    protected boolean isSortHeaderNeeded(UIColumn parentColumn, UIComponent headerFacet) {
        return !(headerFacet instanceof HtmlCommandSortHeader);
    }

    protected HtmlCommandSortHeader createSortHeaderComponent(FacesContext context, UIColumn parentColumn, UIComponent initialHeaderFacet, String propertyName) {
        Application application = context.getApplication();
        HtmlCommandSortHeader sortHeader = (HtmlCommandSortHeader)application.createComponent("org.apache.myfaces.HtmlCommandSortHeader");
        String id = context.getViewRoot().createUniqueId();
        sortHeader.setId(id);
        sortHeader.setColumnName(id);
        sortHeader.setPropertyName(propertyName);
        sortHeader.setArrow(true);
        sortHeader.setImmediate(true);
        sortHeader.getChildren().add(initialHeaderFacet);
        initialHeaderFacet.setParent((UIComponent)sortHeader);
        return sortHeader;
    }

    protected String getSortPropertyFromEL(UIComponent component) {
        if (this.getVar() == null) {
            log.warn((Object)"There is no 'var' specified on the dataTable, sort properties cannot be determined automaticaly.");
            return null;
        }
        for (UIComponent aChild : component.getChildren()) {
            if (!aChild.isRendered()) continue;
            ValueExpression vb = aChild.getValueExpression("value");
            if (vb != null) {
                int varEndIndex;
                String tempProp;
                StringTokenizer tokenizer;
                String expressionString = vb.getExpressionString();
                int varIndex = expressionString.indexOf(this.getVar() + ".");
                if (varIndex == -1 || !(tokenizer = new StringTokenizer(tempProp = expressionString.substring((varEndIndex = varIndex + this.getVar().length()) + 1, expressionString.length()), " +[]{}-/*|?:&<>!=()%")).hasMoreTokens()) continue;
                return tokenizer.nextToken();
            }
            String sortProperty = this.getSortPropertyFromEL(aChild);
            if (sortProperty == null) continue;
            return sortProperty;
        }
        return null;
    }

    protected int columnNameToIndex(String columnName) {
        int index = 0;
        for (UIComponent aChild : this.getChildren()) {
            UIComponent headerFacet;
            if (aChild instanceof UIColumn && (headerFacet = ((UIColumn)aChild).getHeader()) != null && headerFacet instanceof HtmlCommandSortHeader) {
                HtmlCommandSortHeader sortHeader = (HtmlCommandSortHeader)headerFacet;
                if (columnName != null && columnName.length() > 0 && columnName.equals(sortHeader.getColumnName())) {
                    return index;
                }
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        for (UIComponent component : this.getChildren()) {
            if (!(component instanceof UIColumns)) continue;
            ((UIColumns)component).encodeTableEnd(context);
        }
    }

    public int getFirst() {
        if (this._preservedDataModel != null) {
            return this._preservedDataModel.getFirst();
        }
        return super.getFirst();
    }

    public void setFirst(int first) {
        if (this._preservedDataModel != null) {
            this._preservedDataModel.setFirst(first);
        }
        super.setFirst(first);
    }

    public int getRows() {
        if (this._preservedDataModel != null) {
            return this._preservedDataModel.getRows();
        }
        return super.getRows();
    }

    public void setRows(int rows) {
        if (this._preservedDataModel != null) {
            this._preservedDataModel.setRows(rows);
        }
        super.setRows(rows);
    }

    @Override
    public Object saveState(FacesContext context) {
        boolean preserveSort = this.isPreserveSort();
        if (this.initialStateMarked()) {
            Object parentSaved = super.saveState(context);
            boolean preserveDataModel = this.isPreserveDataModel();
            if (parentSaved == null && !preserveSort && !preserveDataModel && this.isExpandedEmpty()) {
                return null;
            }
            Object[] values = new Object[5];
            values[0] = parentSaved;
            if (this.isPreserveDataModel()) {
                this._preservedDataModel = this.getSerializableDataModel();
                values[1] = AbstractHtmlDataTable.saveAttachedState((FacesContext)context, (Object)this._preservedDataModel);
            } else {
                values[1] = null;
            }
            values[2] = preserveSort ? this.getSortColumn() : null;
            values[3] = preserveSort ? Boolean.valueOf(this.isSortAscending()) : null;
            values[4] = this._expandedNodes;
            return values;
        }
        Object[] values = new Object[5];
        values[0] = super.saveState(context);
        if (this.isPreserveDataModel()) {
            this._preservedDataModel = this.getSerializableDataModel();
            values[1] = AbstractHtmlDataTable.saveAttachedState((FacesContext)context, (Object)this._preservedDataModel);
        } else {
            values[1] = null;
        }
        values[2] = preserveSort ? this.getSortColumn() : null;
        values[3] = preserveSort ? Boolean.valueOf(this.isSortAscending()) : null;
        values[4] = this._expandedNodes;
        return values;
    }

    @Override
    protected DataModel getDataModel() {
        if (this._preservedDataModel != null) {
            this.setDataModel(this._preservedDataModel);
            this._preservedDataModel = null;
        }
        return super.getDataModel();
    }

    @Override
    protected DataModel createDataModel() {
        DataModel dataModel = super.createDataModel();
        boolean isSortable = this.isSortable();
        if (!(dataModel instanceof SortableModel)) {
            for (UIComponent component : this.getChildren()) {
                if (!(component instanceof HtmlSimpleColumn)) continue;
                HtmlSimpleColumn aColumn = (HtmlSimpleColumn)component;
                if (this.isSortable()) {
                    aColumn.setSortable(true);
                }
                if (aColumn.isSortable()) {
                    isSortable = true;
                }
                String sortColumn = this.getSortColumn();
                if (!aColumn.isDefaultSorted() || sortColumn != null && sortColumn.length() != 0) continue;
                this.setSortProperty(aColumn.getSortPropertyName());
            }
            if (isSortable) {
                dataModel = new SortableModel(dataModel);
            }
        }
        if (isSortable && this.getSortProperty() != null) {
            SortCriterion criterion = new SortCriterion(this.getSortProperty(), this.isSortAscending());
            ArrayList<SortCriterion> criteria = new ArrayList<SortCriterion>();
            criteria.add(criterion);
            ((SortableModel)dataModel).setSortCriteria(criteria);
        }
        return dataModel;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._preservedDataModel = this.isPreserveDataModel() ? (_SerializableDataModel)AbstractHtmlDataTable.restoreAttachedState((FacesContext)context, (Object)values[1]) : null;
        if (this.isPreserveSort()) {
            String sortColumn = (String)values[2];
            Boolean sortAscending = (Boolean)values[3];
            if (sortColumn != null && sortAscending != null) {
                ValueExpression vb = this.getValueExpression("sortColumn");
                if (vb != null && !vb.isReadOnly(context.getELContext())) {
                    vb.setValue(context.getELContext(), (Object)sortColumn);
                }
                if ((vb = this.getValueExpression("sortAscending")) != null && !vb.isReadOnly(context.getELContext())) {
                    vb.setValue(context.getELContext(), (Object)sortAscending);
                }
            }
        }
        this._expandedNodes = (Map)values[4];
    }

    public _SerializableDataModel getSerializableDataModel() {
        DataModel dm = this.getDataModel();
        if (dm instanceof _SerializableDataModel) {
            return (_SerializableDataModel)dm;
        }
        return this.createSerializableDataModel();
    }

    private _SerializableDataModel createSerializableDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof DataModel) {
            return new _SerializableDataModel(this.getFirst(), this.getRows(), (DataModel)value);
        }
        if (value instanceof List) {
            return new _SerializableListDataModel(this.getFirst(), this.getRows(), (List)value);
        }
        if (value instanceof Collection) {
            return new _SerializableListDataModel(this.getFirst(), this.getRows(), new ArrayList((Collection)value));
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new _SerializableArrayDataModel(this.getFirst(), this.getRows(), (Object[])value);
        }
        if (value instanceof ResultSet) {
            return new _SerializableResultSetDataModel(this.getFirst(), this.getRows(), (ResultSet)value);
        }
        if (value instanceof Result) {
            return new _SerializableResultDataModel(this.getFirst(), this.getRows(), (Result)value);
        }
        return new _SerializableScalarDataModel(this.getFirst(), this.getRows(), value);
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setForceIdIndexFormula(String forceIdIndexFormula) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.forceIdIndexFormula), (Object)forceIdIndexFormula);
        ValueExpression vb = this.getValueExpression("forceIdIndexFormula");
        if (vb != null) {
            vb.setValue(this.getFacesContext().getELContext(), (Object)forceIdIndexFormula);
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.forceIdIndexFormula), null);
        }
    }

    public String getForceIdIndexFormula() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.forceIdIndexFormula));
    }

    public void setSortColumn(String sortColumn) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortColumn), (Object)sortColumn);
        ValueExpression vb = this.getValueExpression("sortColumn");
        if (vb != null) {
            vb.setValue(this.getFacesContext().getELContext(), (Object)sortColumn);
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortColumn), null);
        }
        this.setSortColumnIndex(this.columnNameToIndex(sortColumn));
    }

    public String getSortColumn() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortColumn));
    }

    public void setSortAscending(boolean sortAscending) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortAscending), (Object)sortAscending);
        ValueExpression vb = this.getValueExpression("sortAscending");
        if (vb != null) {
            vb.setValue(this.getFacesContext().getELContext(), (Object)sortAscending);
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortAscending), null);
        }
    }

    public boolean isSortAscending() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortAscending), (Object)true);
    }

    public abstract void setSortProperty(String var1);

    public abstract String getSortProperty();

    public abstract boolean isSortable();

    public abstract boolean isEmbedded();

    public abstract boolean isDetailStampExpandedDefault();

    public abstract String getDetailStampLocation();

    public abstract String getRowOnMouseOver();

    public abstract String getRowOnMouseOut();

    public abstract String getRowOnClick();

    public abstract String getRowOnDblClick();

    public abstract String getRowOnKeyDown();

    public abstract String getRowOnKeyPress();

    public abstract String getRowOnKeyUp();

    public abstract String getRowStyleClass();

    public abstract String getRowStyle();

    public abstract String getRowOnMouseDown();

    public abstract String getRowOnMouseMove();

    public abstract String getRowOnMouseUp();

    protected boolean isValidChildren() {
        return this._isValidChildren;
    }

    protected void setIsValidChildren(boolean isValidChildren) {
        this._isValidChildren = isValidChildren;
    }

    protected _SerializableDataModel getPreservedDataModel() {
        return this._preservedDataModel;
    }

    protected void setPreservedDataModel(_SerializableDataModel preservedDataModel) {
        this._preservedDataModel = preservedDataModel;
    }

    public boolean isCurrentDetailExpanded() {
        Boolean expanded = this._expandedNodes.get(this.getContainerClientId(this.getFacesContext()));
        if (expanded != null) {
            return expanded;
        }
        return this.isDetailStampExpandedDefault();
    }

    public void setVarDetailToggler(String varDetailToggler) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.varDetailToggler), (Object)varDetailToggler);
    }

    public String getVarDetailToggler() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.varDetailToggler));
    }

    public abstract String getRowGroupStyle();

    public abstract String getRowGroupStyleClass();

    public abstract String getBodyStyle();

    public abstract String getBodyStyleClass();

    public AbstractHtmlDataTable() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void toggleDetail() {
        String derivedRowKey = this.getContainerClientId(this.getFacesContext());
        boolean expanded = this.isDetailExpanded();
        if (expanded) {
            if (this.isDetailStampExpandedDefault()) {
                this._expandedNodes.put(derivedRowKey, Boolean.FALSE);
            } else {
                this._expandedNodes.remove(derivedRowKey);
            }
        } else if (this.isDetailStampExpandedDefault()) {
            this._expandedNodes.remove(derivedRowKey);
        } else {
            this._expandedNodes.put(derivedRowKey, Boolean.TRUE);
        }
    }

    public boolean isDetailExpanded() {
        Boolean expanded = this._expandedNodes.get(this.getContainerClientId(this.getFacesContext()));
        if (expanded == null) {
            return this.isDetailStampExpandedDefault();
        }
        return expanded;
    }

    public int getSortColumnIndex() {
        Integer sortColumnIndex = (Integer)this.getStateHelper().get((Serializable)((Object)PropertyKeys.sortColumnIndex));
        if (sortColumnIndex == null) {
            sortColumnIndex = -1;
        }
        if (sortColumnIndex == -1) {
            sortColumnIndex = this.columnNameToIndex(this.getSortColumn());
        }
        return sortColumnIndex;
    }

    public void setSortColumnIndex(int sortColumnIndex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortColumnIndex), (Object)sortColumnIndex);
    }

    @Override
    public abstract int getNewspaperColumns();

    @Override
    public abstract String getNewspaperOrientation();

    @Override
    public UIComponent getSpacer() {
        return (UIComponent)this.getFacets().get(SPACER_FACET_NAME);
    }

    public void setSpacer(UIComponent spacer) {
        this.getFacets().put(SPACER_FACET_NAME, spacer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAllDetails() {
        int rowCount = this.getRowCount();
        this._expandedNodes.clear();
        if (this.getRowKey() != null) {
            int oldRow = this.getRowIndex();
            try {
                for (int row = 0; row < rowCount; ++row) {
                    this.setRowIndex(row);
                    this._expandedNodes.put(this.getContainerClientId(this.getFacesContext()), Boolean.TRUE);
                }
            }
            finally {
                this.setRowIndex(oldRow);
            }
        } else {
            for (int row = 0; row < rowCount; ++row) {
                this._expandedNodes.put(new Integer(row).toString(), Boolean.TRUE);
            }
        }
    }

    public void collapseAllDetails() {
        this._expandedNodes.clear();
    }

    public boolean isExpandedEmpty() {
        boolean expandedEmpty = true;
        if (this._expandedNodes != null) {
            expandedEmpty = this._expandedNodes.isEmpty();
        }
        return expandedEmpty;
    }

    public void setExpandedEmpty(boolean expandedEmpty) {
        if (expandedEmpty && this._expandedNodes != null) {
            this._expandedNodes.clear();
        }
    }

    public abstract boolean isPreserveDataModel();

    public abstract boolean isPreserveSort();

    public abstract boolean isRenderedIfEmpty();

    public abstract String getRowIndexVar();

    public abstract String getRowCountVar();

    public abstract String getPreviousRowDataVar();

    public abstract String getSortedColumnVar();

    public abstract String getAlign();

    public abstract String getRowId();

    public abstract String getDatafld();

    public abstract String getDatasrc();

    public abstract String getDataformatas();

    public abstract String getValueType();

    public abstract boolean isAjaxRowRender();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        preservedDataModel,
        forceIdIndexFormula,
        sortColumn,
        sortAscending,
        varDetailToggler,
        expandedNodes,
        sortColumnIndex;

    }
}

