/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputHtml;

import java.io.Serializable;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlInputText;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.tomahawk.application.PreRenderViewAddResourceEvent;
import org.apache.myfaces.tomahawk.util.TomahawkResourceUtils;

@ListenerFor(systemEventClass=PreRenderViewAddResourceEvent.class)
public class InputHtml
extends HtmlInputText
implements NamingContainer,
UniqueIdVendor {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.InputHtml";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.InputHtml";
    private static final String INPUT_HTML_LIBRARY = "oam.custom.inputHtml";
    private static final String INPUT_HTML_LIBRARY_KUPU_DRAWERS = "oam.custom.inputHtml.kupudrawers";
    private static final Log log = LogFactory.getLog(HtmlInputText.class);

    public InputHtml() {
        this.setRendererType("org.apache.myfaces.InputHtml");
    }

    public void setRendererType(String rendererType) {
        if (!"javax.faces.Composite".equals(rendererType)) {
            super.setRendererType(rendererType);
        }
    }

    public void processEvent(ComponentSystemEvent event) {
        InputHtml editor;
        super.processEvent(event);
        if (event instanceof PreRenderViewAddResourceEvent && !HtmlRendererUtils.isDisplayValueOnly((UIComponent)(editor = (InputHtml)event.getComponent())) && !InputHtml.useFallback(editor)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            TomahawkResourceUtils.addOutputStylesheetResource(facesContext, INPUT_HTML_LIBRARY, "myFacesKupustyles.css");
            TomahawkResourceUtils.addOutputStylesheetResource(facesContext, INPUT_HTML_LIBRARY, "kupudrawerstyles.css");
            TomahawkResourceUtils.addOutputStylesheetResource(facesContext, INPUT_HTML_LIBRARY, "myFaces.css");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "sarissa.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "sarissa_ieemu_xpath.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupuhelpers.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupueditor.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupubasetools.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupuloggers.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupunoi18n.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupucleanupexpressions.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupucontentfilters.js");
            if (editor.isShowAnyToolBox()) {
                TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kuputoolcollapser.js");
            }
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupucontextmenu.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupuinit.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupustart.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupusourceedit.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupuspellchecker.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupudrawers.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "kupuundo.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "diff_match_patch.js");
            TomahawkResourceUtils.addOutputScriptResource(facesContext, INPUT_HTML_LIBRARY, "myFacesUtils.js");
            if (editor.getStyle() != null) {
                TomahawkResourceUtils.addInlineOutputStylesheetResource(facesContext, "#kupu-editor{height: inherit;}\ndiv.kupu-fulleditor{" + editor.getStyle() + "}");
            }
        }
    }

    private static boolean useFallback(InputHtml editor) {
        return editor.getFallback().equals("true");
    }

    public String getKupuConfig() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xml id=\"kupuconfig\" class=\"kupuconfig\">");
        builder.append("<kupuconfig>");
        builder.append("<dst>fulldoc.html</dst>");
        builder.append("<use_css>1</use_css>");
        builder.append("<reload_after_save>0</reload_after_save>");
        builder.append("<strict_output>1</strict_output>");
        builder.append("<content_type>application/xhtml+xml</content_type>");
        builder.append("<compatible_singletons>1</compatible_singletons>");
        builder.append("<table_classes>");
        builder.append("<class>plain</class>");
        builder.append("<class>listing</class>");
        builder.append("<class>grid</class>");
        builder.append("<class>data</class>");
        builder.append("</table_classes>");
        builder.append("<cleanup_expressions>");
        builder.append("<set>");
        builder.append("<name>Convert single quotes to curly ones</name>");
        builder.append("<expression>");
        builder.append("<reg>");
        builder.append("(\\W)'");
        builder.append("</reg>");
        builder.append("<replacement>");
        builder.append("\u0001&#8216;");
        builder.append("</replacement>");
        builder.append("</expression>");
        builder.append("<expression>");
        builder.append("<reg>");
        builder.append("'");
        builder.append("</reg>");
        builder.append("<replacement>");
        builder.append("&#8217;");
        builder.append("</replacement>");
        builder.append("</expression>");
        builder.append("</set>");
        builder.append("<set>");
        builder.append("<name>Reduce whitespace</name>");
        builder.append("<expression>");
        builder.append("<reg>");
        builder.append("[\n\r\t]");
        builder.append("</reg>");
        builder.append("<replacement>");
        builder.append("\\x20");
        builder.append("</replacement>");
        builder.append("</expression>");
        builder.append("<expression>");
        builder.append("<reg>");
        builder.append("[ ]{2}");
        builder.append("</reg>");
        builder.append("<replacement>");
        builder.append("\\x20");
        builder.append("</replacement>");
        builder.append("</expression>");
        builder.append("</set>");
        builder.append("</cleanup_expressions>");
        FacesContext context = this.getFacesContext();
        Resource resource = context.getApplication().getResourceHandler().createResource("drawer.xsl", INPUT_HTML_LIBRARY_KUPU_DRAWERS);
        builder.append("<image_xsl_uri>" + resource.getRequestPath() + "</image_xsl_uri>");
        builder.append("<link_xsl_uri>" + resource.getRequestPath() + "</link_xsl_uri>");
        resource = context.getApplication().getResourceHandler().createResource("imagelibrary.xml", INPUT_HTML_LIBRARY_KUPU_DRAWERS);
        builder.append("<image_libraries_uri>" + resource.getRequestPath() + "</image_libraries_uri>");
        resource = context.getApplication().getResourceHandler().createResource("linklibrary.xml", INPUT_HTML_LIBRARY_KUPU_DRAWERS);
        builder.append("<link_libraries_uri>" + resource.getRequestPath() + "</link_libraries_uri>");
        builder.append("<search_images_uri> </search_images_uri>");
        builder.append("<search_links_uri> </search_links_uri>");
        builder.append("</kupuconfig>");
        builder.append("</xml>");
        return builder.toString();
    }

    public String getDisplayValueOnlyText() {
        return this.getHtmlBody(RendererUtils.getStringValue(this.getFacesContext(), (UIComponent)this));
    }

    public String getFallbackText() {
        String text = RendererUtils.getStringValue(this.getFacesContext(), (UIComponent)this);
        return InputHtml.htmlToPlainText(text, this);
    }

    public String getHiddenText() {
        return RendererUtils.getStringValue(this.getFacesContext(), (UIComponent)this);
    }

    private static String htmlToPlainText(String html, InputHtml editor) {
        return editor.getHtmlBody(html).replaceAll("<br.*>", "\n").replaceAll("<.+?>", "");
    }

    public String getFormId() {
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)this, this.getFacesContext());
        if (parentFormInfo == null) {
            throw new FacesException("InputHtml must be embedded in a form.");
        }
        return parentFormInfo.getFormName();
    }

    public String getEncodedText() {
        String text = this.getValueAsHtmlDocument(this.getFacesContext());
        return text == null ? "" : JavascriptUtils.encodeString(text);
    }

    public String createUniqueId(FacesContext context, String seed) {
        StringBuilder bld = new StringBuilder();
        Long uniqueIdCounter = (Long)this.getStateHelper().get((Serializable)((Object)PropertyKeys.uniqueIdCounter));
        uniqueIdCounter = uniqueIdCounter == null ? 0L : uniqueIdCounter;
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.uniqueIdCounter), (Object)(uniqueIdCounter + 1L));
        if (seed == null) {
            return bld.append("j_id").append(uniqueIdCounter).toString();
        }
        return bld.append("j_id").append(seed).toString();
    }

    public String getFallback() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fallback), (Object)"false");
    }

    public void setFallback(String _fallback) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fallback), (Object)_fallback);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), (Object)"fragment");
    }

    public void setType(String _type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)_type);
    }

    public boolean isTypeDocument() {
        return this.getType().equals("document");
    }

    public boolean isAllowEditSource() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowEditSource), (Object)Boolean.TRUE);
    }

    public void setAllowEditSource(boolean allowEditSource) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowEditSource), (Object)allowEditSource);
    }

    public boolean isAllowExternalLinks() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowExternalLinks), (Object)Boolean.TRUE);
    }

    public void setAllowExternalLinks(boolean allowExternalLinks) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowExternalLinks), (Object)allowExternalLinks);
    }

    public boolean isAddKupuLogo() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.addKupuLogo), (Object)Boolean.TRUE);
    }

    public void setAddKupuLogo(boolean addKupuLogo) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.addKupuLogo), (Object)addKupuLogo);
    }

    public boolean isShowAllToolBoxes() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showAllToolBoxes), (Object)Boolean.FALSE);
    }

    public void setShowAllToolBoxes(boolean showAllToolBoxes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showAllToolBoxes), (Object)showAllToolBoxes);
    }

    public boolean isShowPropertiesToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showPropertiesToolBox), (Object)Boolean.FALSE);
    }

    public void setShowPropertiesToolBox(boolean showPropertiesToolBox) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showPropertiesToolBox), (Object)showPropertiesToolBox);
    }

    public boolean isShowLinksToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showLinksToolBox), (Object)Boolean.FALSE);
    }

    public void setShowLinksToolBox(boolean showLinksToolBox) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showLinksToolBox), (Object)showLinksToolBox);
    }

    public boolean isShowImagesToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showImagesToolBox), (Object)Boolean.FALSE);
    }

    public void setShowImagesToolBox(boolean showImagesToolBox) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showImagesToolBox), (Object)showImagesToolBox);
    }

    public boolean isShowTablesToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showTablesToolBox), (Object)Boolean.FALSE);
    }

    public void setShowTablesToolBox(boolean showTablesToolBox) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showTablesToolBox), (Object)showTablesToolBox);
    }

    public boolean isShowCleanupExpressionsToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showCleanupExpressionsToolBox), (Object)Boolean.FALSE);
    }

    public void setShowCleanupExpressionsToolBox(boolean showCleanupExpressionsToolBox) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showCleanupExpressionsToolBox), (Object)showCleanupExpressionsToolBox);
    }

    public boolean isShowDebugToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showDebugToolBox), (Object)Boolean.FALSE);
    }

    public void setShowDebugToolBox(boolean showTablesToolBox) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showDebugToolBox), (Object)showTablesToolBox);
    }

    public boolean isShowAnyToolBox() {
        return this.isShowAllToolBoxes() || this.isShowPropertiesToolBox() || this.isShowLinksToolBox() || this.isShowImagesToolBox() || this.isShowTablesToolBox() || this.isShowCleanupExpressionsToolBox() || this.isShowDebugToolBox();
    }

    public String getValueAsHtmlDocument(FacesContext context) {
        String val = RendererUtils.getStringValue(context, (UIComponent)this);
        if (InputHtml.isHtmlDocument(val)) {
            return val;
        }
        return "<html><body>" + (val == null ? "" : val) + "</body></html>";
    }

    private static boolean isHtmlDocument(String text) {
        if (text == null) {
            return false;
        }
        return text.indexOf("<body>") != -1 || text.indexOf("<body ") != -1 || text.indexOf("<BODY>") != -1 || text.indexOf("<BODY ") != -1;
    }

    public String getValueFromDocument(String text) {
        if (text == null) {
            return "";
        }
        if (this.isTypeDocument()) {
            return text.trim();
        }
        if (!InputHtml.isHtmlDocument(text)) {
            return text.trim();
        }
        String fragment = this.getHtmlBody(text);
        if (fragment.endsWith("<br />")) {
            return fragment.substring(0, fragment.length() - 6);
        }
        return fragment;
    }

    String getHtmlBody(String html) {
        if ((html = html.trim()).length() == 0) {
            return "";
        }
        String lcText = html.toLowerCase();
        int textLength = lcText.length();
        int bodyStartIndex = -1;
        while (bodyStartIndex < textLength) {
            char c;
            ++bodyStartIndex;
            if ((bodyStartIndex = lcText.indexOf("<body", bodyStartIndex)) == -1 || (c = lcText.charAt(bodyStartIndex += 5)) == '>') break;
            if (c != ' ' && c != '\t') continue;
            bodyStartIndex = lcText.indexOf(62, bodyStartIndex);
            break;
        }
        int bodyEndIndex = lcText.lastIndexOf("</body>") - 1;
        if (++bodyStartIndex < 0 || bodyEndIndex < 0 || bodyStartIndex > bodyEndIndex || bodyStartIndex >= textLength || bodyEndIndex >= textLength) {
            if (lcText.indexOf("<body/>") != -1 || lcText.indexOf("<body />") != -1) {
                return "";
            }
            int htmlStartIndex = lcText.indexOf("<html>");
            int htmlEndIndex = lcText.indexOf("</html>");
            if (htmlStartIndex != -1 && htmlEndIndex > htmlStartIndex) {
                return html.substring(htmlStartIndex + 6, htmlEndIndex);
            }
            if (this.isTypeDocument()) {
                log.warn((Object)("Couldn't extract HTML body from :\n" + html));
            }
            return html.trim();
        }
        return html.substring(bodyStartIndex, bodyEndIndex + 1).trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        fallback,
        type,
        allowEditSource,
        allowExternalLinks,
        addKupuLogo,
        showAllToolBoxes,
        showPropertiesToolBox,
        showLinksToolBox,
        showImagesToolBox,
        showTablesToolBox,
        showCleanupExpressionsToolBox,
        showDebugToolBox,
        uniqueIdCounter;

    }
}

