/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.util;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomahawkResourceUtils {
    public static final String HEAD_LOCATION = "head";
    public static final String BODY_LOCATION = "body";
    public static final String FORM_LOCATION = "form";
    public static final String ADDED_RESOURCES_SET = "org.apache.myfaces.ADDED_RESOURCES_SET";

    private static Map<String, Boolean> getAddedResources(FacesContext facesContext) {
        HashMap map = (HashMap)facesContext.getAttributes().get(ADDED_RESOURCES_SET);
        if (map == null) {
            map = new HashMap();
            facesContext.getAttributes().put(ADDED_RESOURCES_SET, map);
        }
        return map;
    }

    public static void resetAddedResources(FacesContext facesContext) {
        facesContext.getAttributes().remove(ADDED_RESOURCES_SET);
    }

    public static void markResourceAsAdded(FacesContext facesContext, String libraryName, String resourceName) {
        TomahawkResourceUtils.getAddedResources(facesContext).put(libraryName != null ? libraryName + '/' + resourceName : resourceName, Boolean.TRUE);
    }

    public static boolean isAddedResource(FacesContext facesContext, String libraryName, String resourceName) {
        return TomahawkResourceUtils.getAddedResources(facesContext).containsKey(libraryName != null ? libraryName + '/' + resourceName : resourceName);
    }

    public static void addOutputScriptResource(FacesContext facesContext, String libraryName, String resourceName) {
        if (TomahawkResourceUtils.isAddedResource(facesContext, libraryName, resourceName)) {
            return;
        }
        UIOutput outputScript = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Script");
        outputScript.getAttributes().put("library", libraryName);
        outputScript.getAttributes().put("name", resourceName);
        outputScript.setTransient(true);
        outputScript.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputScript);
        TomahawkResourceUtils.markResourceAsAdded(facesContext, libraryName, resourceName);
    }

    public static void addOutputStylesheetResource(FacesContext facesContext, String libraryName, String resourceName) {
        if (TomahawkResourceUtils.isAddedResource(facesContext, libraryName, resourceName)) {
            return;
        }
        UIOutput outputStylesheet = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Stylesheet");
        outputStylesheet.getAttributes().put("library", libraryName);
        outputStylesheet.getAttributes().put("name", resourceName);
        outputStylesheet.setTransient(true);
        outputStylesheet.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputStylesheet);
        TomahawkResourceUtils.markResourceAsAdded(facesContext, libraryName, resourceName);
    }

    public static void addInlineOutputStylesheetResource(FacesContext facesContext, Object value) {
        UIOutput stylesheet = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.Text");
        UIOutput outputStylesheet = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Stylesheet");
        stylesheet.setValue(value);
        stylesheet.setTransient(true);
        stylesheet.setId(facesContext.getViewRoot().createUniqueId());
        outputStylesheet.getChildren().add(stylesheet);
        outputStylesheet.setTransient(true);
        outputStylesheet.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputStylesheet);
    }

    public static void addInlineOutputScriptResource(FacesContext facesContext, String target, Object value) {
        UIOutput script = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.Text");
        UIOutput outputScript = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Script");
        if (target != null) {
            script.getAttributes().put("target", target);
        }
        script.setValue(value);
        script.setTransient(true);
        script.setId(facesContext.getViewRoot().createUniqueId());
        outputScript.getChildren().add(script);
        outputScript.setTransient(true);
        outputScript.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputScript);
    }

    public static String getIconSrc(FacesContext facesContext, String libraryName, String resourceName) {
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        Resource resource = libraryName != null && libraryName.length() > 0 ? resourceHandler.createResource(resourceName, libraryName) : resourceHandler.createResource(resourceName);
        if (resource == null) {
            return "RES_NOT_FOUND";
        }
        return resource.getRequestPath();
    }
}

