/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import org.apache.myfaces.component.html.ext.HtmlDataTable;

public class HtmlTableRow
extends UIPanel {
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.HtmlTableRow";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlTableRow";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.HtmlTableRow";
    private String _alternateClientId;

    public HtmlTableRow() {
        this.setRendererType("org.apache.myfaces.HtmlTableRow");
    }

    public String getClientId(FacesContext context) {
        String inheritedClientId = super.getClientId(context);
        if (this.getParent() instanceof HtmlDataTable) {
            HtmlDataTable dataTable = (HtmlDataTable)this.getParent();
            if (dataTable.getNewspaperColumns() > 1) {
                if (this._alternateClientId == null) {
                    char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
                    this._alternateClientId = dataTable.getClientId() + separator + this.getNewspaperRowIndex(dataTable) + separator + this.getId();
                    return this._alternateClientId;
                }
                return this._alternateClientId;
            }
            return inheritedClientId;
        }
        return inheritedClientId;
    }

    public int getNewspaperRowIndex(HtmlDataTable dataTable) {
        int last;
        int rowCount = dataTable.getRowCount();
        int first = dataTable.getFirst();
        int rows = dataTable.getRows();
        if (rows <= 0) {
            last = rowCount;
        } else {
            last = first + rows;
            if (last > rowCount) {
                last = rowCount;
            }
        }
        int newspaperColumns = dataTable.getNewspaperColumns();
        int newspaperRows = (last - first) % newspaperColumns == 0 ? (last - first) / newspaperColumns : (last - first) / newspaperColumns + 1;
        int currentRow = dataTable.getRowIndex();
        int nr = "horizontal".equals(dataTable.getNewspaperOrientation()) ? (currentRow - first) / newspaperColumns : (currentRow - first) % newspaperRows;
        return nr;
    }

    public void setId(String id) {
        super.setId(id);
        this._alternateClientId = null;
    }

    public String getFamily() {
        return "org.apache.myfaces.HtmlTableRow";
    }
}

