/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navmenu.htmlnavmenu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItems;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionListener;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.navmenu.NavigationMenuItem;
import org.apache.myfaces.custom.navmenu.NavigationMenuUtils;
import org.apache.myfaces.custom.navmenu.UINavigationMenuItem;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlCommandNavigationItem;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlNavigationMenuRendererUtils;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlPanelNavigationMenu;
import org.apache.myfaces.renderkit.html.ext.HtmlLinkRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.tomahawk.application.PreRenderViewAddResourceEvent;
import org.apache.myfaces.tomahawk.util.TomahawkResourceUtils;

@ListenerFor(systemEventClass=PreRenderViewAddResourceEvent.class)
public class HtmlNavigationMenuRenderer
extends HtmlLinkRenderer
implements ComponentSystemEventListener {
    private static final Log log = LogFactory.getLog(HtmlNavigationMenuRenderer.class);
    public static final String RENDERER_TYPE = "org.apache.myfaces.NavigationMenu";
    private static final Integer ZERO_INTEGER = new Integer(0);
    private static final String HORIZ_MENU_SCRIPT = "HMenuIEHover.js";

    public void processEvent(ComponentSystemEvent event) {
        HtmlPanelNavigationMenu panelNav;
        if (event.getComponent() instanceof HtmlPanelNavigationMenu && HtmlNavigationMenuRendererUtils.isListLayout(panelNav = (HtmlPanelNavigationMenu)event.getComponent()) && panelNav.isRenderAll()) {
            this.addResourcesToHeader(FacesContext.getCurrentInstance());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlCommandNavigationItem) {
            super.decode(facesContext, component);
        } else {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlCommandNavigationItem) {
            super.encodeBegin(facesContext, component);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlCommandNavigationItem) {
            super.encodeChildren(facesContext, component);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlCommandNavigationItem) {
            super.encodeEnd(facesContext, component);
            return;
        }
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        RendererUtils.checkParamValidity(facesContext, component, HtmlPanelNavigationMenu.class);
        HtmlPanelNavigationMenu panelNav = (HtmlPanelNavigationMenu)component;
        if (HtmlNavigationMenuRendererUtils.isListLayout(panelNav)) {
            HtmlPanelNavigationMenu panelNavPrev;
            boolean preprocess = true;
            boolean clientStateSaving = facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext);
            if (clientStateSaving) {
                panelNavPrev = this.findPreviousPanelNav(facesContext, panelNav);
                if (panelNavPrev != null) {
                    preprocess = false;
                    if (!panelNavPrev.equals(panelNav)) {
                        UIComponent parent = panelNav.getParent();
                        int insertPos = parent.getChildren().indexOf(panelNav);
                        parent.getChildren().set(insertPos, panelNavPrev);
                        panelNavPrev.setParent(parent);
                        panelNav.setParent(null);
                        panelNav = panelNavPrev;
                    }
                }
            } else if (panelNav.getPreprocessed() != null && panelNav.getPreprocessed().booleanValue()) {
                preprocess = false;
            }
            if (preprocess) {
                panelNav.setPreprocessed(Boolean.TRUE);
                this.preprocessNavigationItems(facesContext, (UIComponent)panelNav, panelNav.getChildren(), new UniqueId());
                if (!clientStateSaving && (panelNavPrev = this.findPreviousPanelNav(facesContext, panelNav)) != null) {
                    this.restoreOpenActiveStates(facesContext, panelNav, panelNavPrev.getChildren());
                }
            }
            if (log.isDebugEnabled()) {
                HtmlNavigationMenuRendererUtils.debugTree(log, facesContext, panelNav.getChildren(), 0);
            }
            this.renderListLayout(facesContext, panelNav);
        } else {
            this.renderTableLayout(facesContext, panelNav);
        }
    }

    private void restoreOpenActiveStates(FacesContext facesContext, HtmlPanelNavigationMenu panelNav, List children) {
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            HtmlCommandNavigationItem item;
            HtmlCommandNavigationItem prevItem;
            UIComponent uiComponent = (UIComponent)children.get(i);
            if (!(uiComponent instanceof HtmlCommandNavigationItem) || !(prevItem = (HtmlCommandNavigationItem)uiComponent).isOpen() && !prevItem.isActive() || (item = (HtmlCommandNavigationItem)panelNav.findComponent(uiComponent.getClientId(facesContext))) == null) continue;
            if (item.getActiveDirectly() != null && item.getActiveDirectly().booleanValue()) {
                item.setActive(prevItem.isActive());
            } else {
                this.copyValueBinding((UIComponent)prevItem, (UIComponent)item, "active");
            }
            if (item.getOpenDirectly() != null && item.getOpenDirectly().booleanValue()) {
                item.setOpen(prevItem.isOpen());
            } else {
                this.copyValueBinding((UIComponent)prevItem, (UIComponent)item, "open");
            }
            if (!panelNav.isExpandAll() || prevItem.isActive()) {
                item.toggleOpen();
            }
            if (!prevItem.isOpen()) continue;
            this.restoreOpenActiveStates(facesContext, panelNav, prevItem.getChildren());
        }
    }

    private HtmlPanelNavigationMenu findPreviousPanelNav(FacesContext facesContext, HtmlPanelNavigationMenu panelNav) {
        UIViewRoot previousViewRoot = this.findPreviousRoot(facesContext);
        if (previousViewRoot != null) {
            return (HtmlPanelNavigationMenu)previousViewRoot.findComponent(panelNav.getClientId(facesContext));
        }
        return null;
    }

    private UIViewRoot findPreviousRoot(FacesContext facesContext) {
        return (UIViewRoot)facesContext.getExternalContext().getRequestMap().get(HtmlPanelNavigationMenu.PREVIOUS_VIEW_ROOT);
    }

    protected void renderListLayout(FacesContext facesContext, HtmlPanelNavigationMenu panelNav) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (panelNav.getChildCount() > 0) {
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("ul", (UIComponent)panelNav);
            Map behaviors = panelNav.getClientBehaviors();
            if (behaviors != null && !behaviors.isEmpty()) {
                writer.writeAttribute("id", (Object)panelNav.getClientId(facesContext), null);
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)panelNav, behaviors);
                HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)panelNav, HTML.UL_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)panelNav, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)panelNav, HTML.UL_PASSTHROUGH_ATTRIBUTES);
            }
            this.activeOnViewId((UIComponent)panelNav, facesContext.getViewRoot().getViewId());
            if (panelNav.isExpandAll()) {
                this.expandAll((UIComponent)panelNav);
            }
            HtmlNavigationMenuRendererUtils.renderChildrenListLayout(facesContext, writer, panelNav, panelNav.getChildren(), 0);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.endElement("ul");
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"PanelNavaigationMenu without children.");
        }
    }

    private void renderTableLayout(FacesContext facesContext, HtmlPanelNavigationMenu panelNav) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (panelNav.getChildCount() > 0) {
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("table", (UIComponent)panelNav);
            Map behaviors = panelNav.getClientBehaviors();
            if (behaviors != null && !behaviors.isEmpty()) {
                writer.writeAttribute("id", (Object)panelNav.getClientId(facesContext), null);
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)panelNav, behaviors);
                HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)panelNav, HTML.TABLE_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)panelNav, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)panelNav, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
            }
            if (panelNav.getStyle() == null && panelNav.getStyleClass() == null) {
                writer.writeAttribute("border", (Object)ZERO_INTEGER, null);
            }
            HtmlNavigationMenuRendererUtils.renderChildrenTableLayout(facesContext, writer, panelNav, panelNav.getChildren(), 0);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.endElement("table");
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"PanelNavaigationMenu without children.");
        }
    }

    private void addResourcesToHeader(FacesContext context) {
        TomahawkResourceUtils.addOutputScriptResource(context, "oam.custom.navmenu.htmlnavmenu", HORIZ_MENU_SCRIPT);
    }

    private void preprocessNavigationItems(FacesContext facesContext, UIComponent parent, List children, UniqueId uniqueId) {
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (child instanceof HtmlCommandNavigationItem) {
                HtmlCommandNavigationItem navMenuItem = (HtmlCommandNavigationItem)child;
                this.preprocessNavigationItems(facesContext, (UIComponent)navMenuItem, navMenuItem.getChildren(), uniqueId);
                continue;
            }
            if (child instanceof UINavigationMenuItem) {
                UINavigationMenuItem uiNavMenuItem = (UINavigationMenuItem)child;
                this.createHtmlCommandNavigationItem(facesContext, parent, i, uiNavMenuItem, uniqueId);
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            ArrayList list = new ArrayList();
            if (child.getId() == null) {
                child.setId("testit");
            }
            NavigationMenuUtils.addNavigationMenuItems((UISelectItems)child, list);
            this.addUINavigationMenuItems(facesContext, parent, children, i + 1, list);
        }
    }

    private void addUINavigationMenuItems(FacesContext facesContext, UIComponent parent, List children, int startIndex, List menuItems) {
        String clientId = parent.getClientId(facesContext);
        clientId = clientId.replaceAll(":", "_");
        int sizej = menuItems.size();
        for (int j = 0; j < sizej; ++j) {
            NavigationMenuItem navigationMenuItem = (NavigationMenuItem)((Object)menuItems.get(j));
            UINavigationMenuItem uiNavigationMenuItem = (UINavigationMenuItem)facesContext.getApplication().createComponent("org.apache.myfaces.NavigationMenuItem");
            uiNavigationMenuItem.setId(clientId + "_uinavmitem" + (startIndex + j));
            uiNavigationMenuItem.getClientId(facesContext);
            children.add(startIndex++, uiNavigationMenuItem);
            uiNavigationMenuItem.setParent(parent);
            if (navigationMenuItem.getAction() != null) {
                uiNavigationMenuItem.setAction(HtmlNavigationMenuRendererUtils.getMethodBinding(facesContext, navigationMenuItem.getAction(), false));
            }
            if (navigationMenuItem.getActionListener() != null) {
                uiNavigationMenuItem.setActionListener(HtmlNavigationMenuRendererUtils.getMethodBinding(facesContext, navigationMenuItem.getActionListener(), true));
            }
            uiNavigationMenuItem.setIcon(navigationMenuItem.getIcon());
            uiNavigationMenuItem.setRendered(navigationMenuItem.isRendered());
            uiNavigationMenuItem.setActiveOnViewIds(navigationMenuItem.getActiveOnViewIds());
            uiNavigationMenuItem.setSplit(navigationMenuItem.isSplit());
            uiNavigationMenuItem.setItemLabel(navigationMenuItem.getLabel());
            uiNavigationMenuItem.setOpen(navigationMenuItem.isOpen());
            uiNavigationMenuItem.setActive(navigationMenuItem.isActive());
            uiNavigationMenuItem.setValue(navigationMenuItem.getValue());
            HtmlNavigationMenuRendererUtils.setAttributeValue(facesContext, (UIComponent)uiNavigationMenuItem, "externalLink", navigationMenuItem.getExternalLink());
            uiNavigationMenuItem.setTransient(false);
            uiNavigationMenuItem.setTarget(navigationMenuItem.getTarget());
            uiNavigationMenuItem.setDisabled(navigationMenuItem.isDisabled());
            uiNavigationMenuItem.setDisabledStyle(navigationMenuItem.getDisabledStyle());
            uiNavigationMenuItem.setDisabledStyleClass(navigationMenuItem.getDisabledStyleClass());
            if (navigationMenuItem.getNavigationMenuItems() == null || navigationMenuItem.getNavigationMenuItems().length <= 0) continue;
            this.addUINavigationMenuItems(facesContext, (UIComponent)uiNavigationMenuItem, uiNavigationMenuItem.getChildren(), 0, Arrays.asList(navigationMenuItem.getNavigationMenuItems()));
        }
    }

    private HtmlPanelNavigationMenu getParentPanelNavigation(UIComponent uiComponent) {
        UIComponent parent;
        UIComponent p;
        if (uiComponent instanceof HtmlPanelNavigationMenu) {
            return (HtmlPanelNavigationMenu)uiComponent;
        }
        for (p = parent = uiComponent.getParent(); p != null && !(p instanceof HtmlPanelNavigationMenu); p = p.getParent()) {
        }
        if (p == null) {
            log.error((Object)"HtmlCommandNavigation without parent HtmlPanelNavigation ?!");
            return null;
        }
        return (HtmlPanelNavigationMenu)p;
    }

    private void createHtmlCommandNavigationItem(FacesContext facesContext, UIComponent parent, int i, UINavigationMenuItem uiNavMenuItem, UniqueId uniqueId) {
        HtmlPanelNavigationMenu menu = this.getParentPanelNavigation(parent);
        HtmlCommandNavigationItem newItem = (HtmlCommandNavigationItem)facesContext.getApplication().createComponent("org.apache.myfaces.HtmlCommandNavigationItem");
        String parentId = parent.getClientId(facesContext);
        parentId = parentId.replaceAll(":", "_");
        int id = uniqueId.next();
        newItem.setId(parentId + "_item" + id);
        newItem.getClientId(facesContext);
        newItem.setRendererType(RENDERER_TYPE);
        parent.getChildren().add(i + 1, newItem);
        newItem.setParent(parent);
        newItem.setAction(uiNavMenuItem.getAction());
        newItem.setActionListener(uiNavMenuItem.getActionListener());
        ActionListener[] listeners = uiNavMenuItem.getActionListeners();
        for (int j = 0; j < listeners.length; ++j) {
            newItem.addActionListener(listeners[j]);
        }
        newItem.setValue(uiNavMenuItem.getValue());
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "immediate")) {
            newItem.setImmediate(uiNavMenuItem.isImmediate());
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "transient")) {
            newItem.setTransient(uiNavMenuItem.isTransient());
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "rendered")) {
            newItem.setRendered(uiNavMenuItem.isRendered());
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "externalLink")) {
            newItem.setExternalLink(uiNavMenuItem.getExternalLink());
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "activeOnViewIds")) {
            newItem.setActiveOnViewIds(uiNavMenuItem.getActiveOnViewIds());
        }
        if (uiNavMenuItem.isOpen() && !menu.isExpandAll()) {
            newItem.toggleOpen();
        }
        if (uiNavMenuItem.getActiveDirectly() != null) {
            newItem.setActive(uiNavMenuItem.isActive());
        } else {
            newItem.setValueBinding("active", uiNavMenuItem.getValueBinding("active"));
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "target")) {
            newItem.setTarget(uiNavMenuItem.getTarget());
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "disabled")) {
            newItem.setDisabled(uiNavMenuItem.isDisabled());
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "disabledStyle")) {
            newItem.setDisabledStyle(uiNavMenuItem.getDisabledStyle());
        }
        if (!this.copyValueBinding((UIComponent)uiNavMenuItem, (UIComponent)newItem, "disabledStyleClass")) {
            newItem.setDisabledStyleClass(uiNavMenuItem.getDisabledStyleClass());
        }
        if (uiNavMenuItem.getActiveOnViewIdsDirectly() != null) {
            newItem.setActiveOnViewIds(uiNavMenuItem.getActiveOnViewIdsDirectly());
        }
        if (parent instanceof HtmlPanelNavigationMenu) {
            if (newItem.getDisabledStyle() == null) {
                newItem.setDisabledStyle(((HtmlPanelNavigationMenu)parent).getDisabledStyle());
            }
            if (newItem.getDisabledStyleClass() == null) {
                newItem.setDisabledStyleClass(((HtmlPanelNavigationMenu)parent).getDisabledStyleClass());
            }
            if (((HtmlPanelNavigationMenu)parent).isDisabled()) {
                newItem.setDisabled(true);
            }
        }
        if (parent instanceof HtmlCommandNavigationItem) {
            if (newItem.getDisabledStyle() == null) {
                newItem.setDisabledStyle(((HtmlCommandNavigationItem)parent).getDisabledStyle());
            }
            if (newItem.getDisabledStyleClass() == null) {
                newItem.setDisabledStyleClass(((HtmlCommandNavigationItem)parent).getDisabledStyleClass());
            }
            if (((HtmlCommandNavigationItem)parent).isDisabled()) {
                newItem.setDisabled(true);
            }
        }
        if (uiNavMenuItem.getIcon() != null) {
            UIGraphic uiGraphic = (UIGraphic)facesContext.getApplication().createComponent("javax.faces.Graphic");
            uiGraphic.setId(parentId + "_img" + id);
            uiGraphic.getClientId(facesContext);
            newItem.getChildren().add(uiGraphic);
            uiGraphic.setParent((UIComponent)newItem);
            if (NavigationMenuUtils.isValueReference(uiNavMenuItem.getIcon())) {
                uiGraphic.setValueBinding("value", facesContext.getApplication().createValueBinding(uiNavMenuItem.getIcon()));
            } else {
                uiGraphic.setValue((Object)uiNavMenuItem.getIcon());
            }
        } else {
            UIOutput uiOutput = (UIOutput)facesContext.getApplication().createComponent("javax.faces.Output");
            uiOutput.setId(parentId + "_txt" + id);
            uiOutput.getClientId(facesContext);
            newItem.getChildren().add(uiOutput);
            uiOutput.setParent((UIComponent)newItem);
            if (uiNavMenuItem.getItemLabel() != null) {
                if (NavigationMenuUtils.isValueReference(uiNavMenuItem.getItemLabel())) {
                    uiOutput.setValueBinding("value", facesContext.getApplication().createValueBinding(uiNavMenuItem.getItemLabel()));
                } else {
                    uiOutput.setValue((Object)uiNavMenuItem.getItemLabel());
                }
            } else {
                Object value = uiNavMenuItem.getValue();
                if (value != null && NavigationMenuUtils.isValueReference(value.toString())) {
                    uiOutput.setValueBinding("value", facesContext.getApplication().createValueBinding(value.toString()));
                } else {
                    uiOutput.setValue(uiNavMenuItem.getValue());
                }
            }
        }
        log.debug((Object)"Instance of UINavigationMenuItem, preprocess childrens");
        this.preprocessNavigationItems(facesContext, (UIComponent)newItem, uiNavMenuItem.getChildren(), uniqueId);
    }

    private boolean copyValueBinding(UIComponent source, UIComponent target, String binding) {
        ValueBinding valueBinding = source.getValueBinding(binding);
        if (valueBinding == null) {
            return false;
        }
        target.setValueBinding(binding, valueBinding);
        return true;
    }

    protected String getStyle(FacesContext facesContext, UIComponent link) {
        if (!(link instanceof HtmlCommandNavigationItem)) {
            throw new IllegalArgumentException("expected instance of " + HtmlCommandNavigationItem.class.getName());
        }
        UIComponent navPanel = HtmlNavigationMenuRendererUtils.getPanel(link);
        HtmlCommandNavigationItem navItem = (HtmlCommandNavigationItem)link;
        if (navItem.isActive()) {
            return ((HtmlPanelNavigationMenu)navPanel).getActiveItemStyle();
        }
        if (navItem.isOpen()) {
            return ((HtmlPanelNavigationMenu)navPanel).getOpenItemStyle();
        }
        return ((HtmlPanelNavigationMenu)navPanel).getItemStyle();
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent link) {
        if (!(link instanceof HtmlCommandNavigationItem)) {
            throw new IllegalArgumentException();
        }
        UIComponent navPanel = HtmlNavigationMenuRendererUtils.getPanel(link);
        HtmlCommandNavigationItem navItem = (HtmlCommandNavigationItem)link;
        if (navItem.isActive()) {
            return ((HtmlPanelNavigationMenu)navPanel).getActiveItemClass();
        }
        if (navItem.isOpen()) {
            return ((HtmlPanelNavigationMenu)navPanel).getOpenItemClass();
        }
        return ((HtmlPanelNavigationMenu)navPanel).getItemClass();
    }

    private void expandAll(UIComponent parent) {
        if (parent instanceof HtmlCommandNavigationItem) {
            HtmlCommandNavigationItem navItem = (HtmlCommandNavigationItem)parent;
            navItem.setOpen(true);
        }
        List children = parent.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            this.expandAll(child);
        }
    }

    private void activeOnViewId(UIComponent parent, String viewId) {
        int i;
        if (parent instanceof HtmlCommandNavigationItem) {
            HtmlCommandNavigationItem navItem = (HtmlCommandNavigationItem)parent;
            String[] viewIds = navItem.getActiveOnVieIds();
            for (i = 0; i < viewIds.length; ++i) {
                if (!viewId.equals(viewIds[i])) continue;
                navItem.toggleOpen();
                navItem.setActive(true);
                return;
            }
        }
        List children = parent.getChildren();
        for (i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            this.activeOnViewId(child, viewId);
        }
    }

    private static class UniqueId {
        private int _id;

        private UniqueId() {
        }

        public int next() {
            return this._id++;
        }

        public void decrease() {
            --this._id;
        }
    }
}

